/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findbyprimarykey;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class HomeInterfaceFindByPrimaryKeyArg
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean findByPrimaryKeyMethodFound = false;
        boolean foundOne = false;
        boolean oneFailed = false;
        boolean paramValid = false;
        boolean onlyOneParam = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> homeInterfaceClass = jcl.loadClass(home);
            Method[] ejbFinderMethods = homeInterfaceClass.getDeclaredMethods();
            String primaryKeyType = ((EjbEntityDescriptor)descriptor).getPrimaryKeyClassName();
            for (int j = 0; j < ejbFinderMethods.length; ++j) {
                paramValid = false;
                onlyOneParam = false;
                findByPrimaryKeyMethodFound = false;
                if (!ejbFinderMethods[j].getName().equals("findByPrimaryKey")) continue;
                findByPrimaryKeyMethodFound = true;
                Class<?>[] ejbFinderMethodParameterTypes = ejbFinderMethods[j].getParameterTypes();
                if (ejbFinderMethodParameterTypes.length == 1) {
                    onlyOneParam = true;
                    for (int k = 0; k < ejbFinderMethodParameterTypes.length; ++k) {
                        if (!ejbFinderMethodParameterTypes[k].getName().equals(primaryKeyType)) continue;
                        paramValid = true;
                        break;
                    }
                } else {
                    onlyOneParam = false;
                    paramValid = false;
                }
                if (findByPrimaryKeyMethodFound && paramValid) {
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j].getName()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "A findByPrimaryKey method with valid parameter type was found."));
                    foundOne = true;
                    break;
                }
                if (findByPrimaryKeyMethodFound && onlyOneParam && !paramValid) {
                    this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j].getName()}));
                    this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "A findByPrimaryKey method was found, but with non-PrimaryKeyClass arg parameter type."));
                    continue;
                }
                if (!findByPrimaryKeyMethodFound || onlyOneParam) continue;
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j].getName()}));
                this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "A findByPrimaryKey method was found, but with non-single arg parameters."));
            }
            if (!foundOne) {
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug3", "For home interface [ {0} ]", new Object[]{homeInterfaceClass.getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No single arg findByPrimaryKey(PrimaryKeyClass) method was found in home interface class [ {0} ].", new Object[]{homeInterfaceClass.getName()}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable.", new Object[]{home}));
            return oneFailed;
        }
    }
}

