/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;

public class TransactionDemarcationComponentInterface
extends EjbTest
implements EjbCheck {
    static String[] EJBObjectMethods = new String[]{"getEJBHome", "getHandle", "getEJBLocalHome", "getPrimaryKey", "isIdentical"};
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        try {
            if (descriptor instanceof EjbEntityDescriptor) {
                boolean oneFailed = false;
                if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor, MethodDescriptor.EJB_REMOTE);
                }
                if (!oneFailed && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor, MethodDescriptor.EJB_LOCAL);
                }
                if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
                return this.result;
            }
            this.addNaDetails(this.result, this.compName);
            this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
            return this.result;
        }
        catch (Throwable t) {
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Component interface does not contain class [ {0} ] within bean [ {1} ]", new Object[]{t.getMessage(), descriptor.getName()}));
            return this.result;
        }
    }

    private boolean commonToBothInterfaces(String component, EjbDescriptor descriptor, String methodIntf) {
        boolean oneFailed = false;
        try {
            Arrays.sort(EJBObjectMethods);
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> componentInterfaceClass = jcl.loadClass(component);
            Method[] componentInterfaceMethods = componentInterfaceClass.getDeclaredMethods();
            boolean lookForIt = false;
            for (int i = 0; i < componentInterfaceMethods.length; ++i) {
                if (Arrays.binarySearch(EJBObjectMethods, componentInterfaceMethods[i].getName()) < 0) {
                    try {
                        ContainerTransaction containerTransaction = null;
                        boolean resolved = false;
                        if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                            Enumeration ee = descriptor.getMethodContainerTransactions().keys();
                            while (ee.hasMoreElements()) {
                                lookForIt = false;
                                MethodDescriptor methodDescriptor = (MethodDescriptor)ee.nextElement();
                                lookForIt = methodDescriptor.getName().equals(MethodDescriptor.ALL_EJB_METHODS) ? (methodDescriptor.getEjbClassSymbol() == null ? true : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) ? true : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCAL) ? true : (methodDescriptor.getEjbClassSymbol().equals("") ? true : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) ? false : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME) ? false : false)))))) : (methodDescriptor.getParameterClassNames() == null ? (methodDescriptor.getEjbClassSymbol() == null || methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCAL)) && componentInterfaceMethods[i].getName().equals(methodDescriptor.getName()) : (methodDescriptor.getEjbClassSymbol() == null || methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCAL)) && componentInterfaceMethods[i].getName().equals(methodDescriptor.getName()) && MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(componentInterfaceMethods[i], methodIntf).getParameterClassNames()));
                                if (!lookForIt) continue;
                                containerTransaction = (ContainerTransaction)descriptor.getMethodContainerTransactions().get(methodDescriptor);
                                if (containerTransaction != null) {
                                    String transactionAttribute = containerTransaction.getTransactionAttribute();
                                    if (ContainerTransaction.NOT_SUPPORTED.equals(transactionAttribute) || ContainerTransaction.SUPPORTS.equals(transactionAttribute) || ContainerTransaction.REQUIRED.equals(transactionAttribute) || ContainerTransaction.REQUIRES_NEW.equals(transactionAttribute) || ContainerTransaction.MANDATORY.equals(transactionAttribute) || ContainerTransaction.NEVER.equals(transactionAttribute) || !transactionAttribute.equals("")) {
                                        this.addGoodDetails(this.result, this.compName);
                                        this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: [ {0} ] TransactionAttribute [ {1} ] for method [ {2} ] is valid. Transaction attributes must be defined for all methods except getEJBHome, getHandle, getPrimaryKey, and isIdentical methods of component interface [ {3} ].", new Object[]{componentInterfaceMethods[i].getName(), transactionAttribute, methodDescriptor.getName(), component}));
                                        resolved = true;
                                        continue;
                                    }
                                    oneFailed = true;
                                    this.addErrorDetails(this.result, this.compName);
                                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] TransactionAttribute [ {1} ] for method [ {2} ] is not valid.   Transaction attributes must be defined for all methods except getEJBHome, getHandle, getPrimaryKey, and isIdentical methods of component interface [ {3} ]", new Object[]{componentInterfaceMethods[i].getName(), transactionAttribute, methodDescriptor.getName(), component}));
                                    continue;
                                }
                                oneFailed = true;
                                this.addErrorDetails(this.result, this.compName);
                                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: TransactionAttribute is null for method [ {0} ]", new Object[]{methodDescriptor.getName()}));
                            }
                            if (!resolved) {
                                oneFailed = true;
                                this.addErrorDetails(this.result, this.compName);
                                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: Transaction attributes must be specified for the methods defined in the component interface [ {0} ].  Method [ {1} ] has no transaction attribute defined within this bean [ {2} ].", new Object[]{component, componentInterfaceMethods[i].getName(), descriptor.getName()}));
                            }
                        } else {
                            oneFailed = true;
                            this.addErrorDetails(this.result, this.compName);
                            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: There are no method permissions within this bean [ {0} ].   Transaction attributes must be specified for the methods defined in the component interface [ {1} ].  Method [ {2} ] has no transaction attribute defined.", new Object[]{descriptor.getName(), component, componentInterfaceMethods[i].getName()}));
                        }
                        if (!oneFailed || i != componentInterfaceMethods.length - 1) continue;
                        return oneFailed;
                    }
                    catch (Exception e) {
                        this.addErrorDetails(this.result, this.compName);
                        this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Component interface [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{component, e.getMessage(), descriptor.getName()}));
                        oneFailed = true;
                        return oneFailed;
                    }
                }
                oneFailed = true;
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedExcep", "Error: Method [ {0} ] should not be assigned a transaction attribute.", new Object[]{componentInterfaceMethods[i].getName()}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: Component interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{component, descriptor.getName()}));
            oneFailed = true;
            return oneFailed;
        }
    }
}

