/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class PersistenceFieldsElement
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbEntityDescriptor) {
            block13: {
                String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
                if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistentType)) {
                    if (1 != ((EjbCMPEntityDescriptor)descriptor).getCMPVersion()) {
                        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.notApplicable3", "Test do not apply to this cmp-version of container managed persistence EJBs"));
                        return result;
                    }
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{persistentType});
                    Set persistentFields = ((EjbCMPEntityDescriptor)descriptor).getPersistenceDescriptor().getCMPFields();
                    Iterator iterator = persistentFields.iterator();
                    try {
                        Context context = this.getVerifierContext();
                        ClassLoader jcl = context.getClassLoader();
                        Class<?> c = jcl.loadClass(descriptor.getEjbClassName());
                        boolean oneFailed = false;
                        while (iterator.hasNext()) {
                            Descriptor persistentField = (Descriptor)iterator.next();
                            try {
                                Field field = c.getField(persistentField.getName());
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] field found in [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                            }
                            catch (NoSuchFieldException e) {
                                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: NoSuchFieldException: [ {0} ] not found in [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                                if (oneFailed) continue;
                                oneFailed = true;
                            }
                            catch (SecurityException e) {
                                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: SecurityException: [ {0} ] not found in [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                                if (oneFailed) continue;
                                oneFailed = true;
                            }
                        }
                        if (oneFailed) {
                            result.setStatus(1);
                            break block13;
                        }
                        result.setStatus(0);
                    }
                    catch (ClassNotFoundException e) {
                        Verifier.debug(e);
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failedException3", "Error: Fields don't exist or are not loadable within bean [ {0} ]", new Object[]{descriptor.getName()}));
                    }
                } else if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistentType)) {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Expected persistence type [ {0} ], but [ {1} ] bean has persistence type [ {2} ]", new Object[]{EjbEntityDescriptor.CONTAINER_PERSISTENCE, descriptor.getName(), persistentType}));
                } else {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] is not valid persistentType within bean [ {1} ]", new Object[]{persistentType, descriptor.getName()}));
                }
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

