/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.io.Serializable;
import java.util.logging.Level;
import javax.ejb.TimedObject;

public class EntityBeanExtendsSerializableClass
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbEntityDescriptor) {
            try {
                Context context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class<?> c = jcl.loadClass(descriptor.getEjbClassName());
                boolean validBean = true;
                Class<?> superClass = c.getSuperclass();
                if (validBean) {
                    if (!superClass.getName().equals("java.lang.Object")) {
                        if (!EntityBeanExtendsSerializableClass.isValidSerializableType(superClass) && !EntityBeanExtendsSerializableClass.isTimedObject(superClass)) {
                            validBean = false;
                            result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "[ {0} ] extends class [ {1} ] which is not serializable. ", new Object[]{descriptor.getEjbClassName(), superClass.getName()}));
                            result.setStatus(2);
                            return result;
                        }
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed1", "Bean [ {0} ] extends class [ {1} ] which is serializable. ", new Object[]{descriptor.getEjbClassName(), superClass.getName()}));
                        block2: do {
                            Class<?>[] interfaces = c.getInterfaces();
                            for (int i = 0; i < interfaces.length; ++i) {
                                this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{interfaces[i].getName()});
                                if (EntityBeanExtendsSerializableClass.isValidSerializableType(interfaces[i]) || EntityBeanExtendsSerializableClass.isTimedObject(interfaces[i])) continue;
                                validBean = false;
                                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".failed", "[ {0} ] implements interface [ {1} ] which is not serializable. ", new Object[]{descriptor.getEjbClassName(), interfaces[i].getName()}));
                                result.setStatus(2);
                                continue block2;
                            }
                        } while ((c = c.getSuperclass()) != null && validBean);
                    }
                    if (validBean) {
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Bean [ {0} ] implements interfaces which are all serializable. ", new Object[]{descriptor.getEjbClassName()}));
                        result.setStatus(0);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }

    public static boolean isValidSerializableType(Class serClass) {
        return Serializable.class.isAssignableFrom(serClass);
    }

    public static boolean isTimedObject(Class serClass) {
        return TimedObject.class.isAssignableFrom(serClass);
    }
}

