/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class BusinessMethodStatic
extends EjbTest
implements EjbCheck {
    Result result = null;
    int foundAtLeastOne = 0;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else if (this.foundAtLeastOne == 0) {
                this.result.setStatus(3);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> rc = jcl.loadClass(remote);
            boolean businessFound = false;
            boolean isStatic = false;
            Method[] remoteMethods = rc.getMethods();
            for (int h = 0; h < remoteMethods.length; ++h) {
                if (remoteMethods[h].getDeclaringClass().getName().equals("javax.ejb.EJBObject") || remoteMethods[h].getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) continue;
                businessFound = false;
                isStatic = false;
                Class<?> c = jcl.loadClass(descriptor.getEjbClassName());
                do {
                    Method[] methods = c.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals(remoteMethods[h].getName())) continue;
                        ++this.foundAtLeastOne;
                        businessFound = true;
                        int modifiers = methods[i].getModifiers();
                        if (Modifier.isStatic(modifiers)) {
                            isStatic = true;
                        }
                        if (businessFound && !isStatic) {
                            this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly declares non-static business method [ {1} ].", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                            continue;
                        }
                        if (!businessFound || !isStatic) continue;
                        oneFailed = true;
                        this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: static business method [ {0} ] was found, but business method cannot be declared as static.", new Object[]{methods[i].getName()}));
                    }
                } while ((c = c.getSuperclass()) != null && !businessFound);
            }
            if (this.foundAtLeastOne == 0) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] does not declare any business methods. ", new Object[]{descriptor.getEjbClassName()}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            oneFailed = true;
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{remote, descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

