/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.lang.reflect.Method;

public class BusinessMethodRmiIIOPArgs
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            int foundAtLeastOne = 0;
            try {
                if (descriptor.getRemoteClassName() == null || "".equals(descriptor.getRemoteClassName())) {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", " [ {0} ] does not have a remote interface. ", new Object[]{descriptor.getEjbClassName()}));
                    return result;
                }
                Context context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class<?> rc = jcl.loadClass(descriptor.getRemoteClassName());
                boolean businessFound = false;
                boolean isLegalRMIIIOP = false;
                Method[] remoteMethods = rc.getMethods();
                for (int h = 0; h < remoteMethods.length; ++h) {
                    if (remoteMethods[h].getDeclaringClass().getName().equals("javax.ejb.EJBObject")) continue;
                    businessFound = false;
                    isLegalRMIIIOP = false;
                    Class<?> c = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] methods = c.getDeclaredMethods();
                        for (int i = 0; i < methods.length; ++i) {
                            if (!methods[i].getName().equals(remoteMethods[h].getName())) continue;
                            ++foundAtLeastOne;
                            businessFound = true;
                            Class[] businessMethodParameterTypes = methods[i].getParameterTypes();
                            if (RmiIIOPUtils.isValidRmiIIOPParameters(businessMethodParameterTypes)) {
                                isLegalRMIIIOP = true;
                            }
                            if (businessFound && isLegalRMIIIOP) {
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly declares business method [ {1} ] with valid RMI-IIOP parameter types.", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                                continue;
                            }
                            if (!businessFound || isLegalRMIIIOP) continue;
                            oneFailed = true;
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: business method [ {0} ] was found, but business method has illegal parameter values.   Business methods arguments types must be legal types for RMI-IIOP.", new Object[]{methods[i].getName()}));
                        }
                    } while ((c = c.getSuperclass()) != null && !businessFound);
                }
                if (foundAtLeastOne == 0) {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", " [ {0} ] does not declare any business methods. ", new Object[]{descriptor.getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{descriptor.getRemoteClassName(), descriptor.getEjbClassName(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (foundAtLeastOne == 0) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }
}

