/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class BusinessMethodName
extends EjbTest
implements EjbCheck {
    Result result = null;
    boolean businessFound = false;
    boolean conflictsWithEJBArchitecture = false;
    int foundAtLeastOne = 0;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        Object rc = null;
        this.compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else if (this.foundAtLeastOne == 0) {
                this.result.setStatus(3);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> rc = jcl.loadClass(remote);
            boolean businessFound = false;
            boolean conflictsWithEJBArchitecture = false;
            Method[] remoteMethods = rc.getMethods();
            for (int h = 0; h < remoteMethods.length; ++h) {
                if (remoteMethods[h].getDeclaringClass().getName().equals("javax.ejb.EJBObject")) continue;
                businessFound = false;
                conflictsWithEJBArchitecture = false;
                Class<?> c = jcl.loadClass(descriptor.getEjbClassName());
                do {
                    Method[] methods = c.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals(remoteMethods[h].getName())) continue;
                        ++this.foundAtLeastOne;
                        businessFound = true;
                        if (methods[i].getName().startsWith("ejb") || methods[i].getName().equals("class$") || methods[i].getName().equals("setSessionContext")) {
                            conflictsWithEJBArchitecture = true;
                        }
                        if (businessFound && !conflictsWithEJBArchitecture) {
                            this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly declares properly named business method [ {1} ].", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                            continue;
                        }
                        if (!businessFound || !conflictsWithEJBArchitecture) continue;
                        oneFailed = true;
                        this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business Method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Business method [ {0} ] was found, but was not properly named.  [ {1} ] must not conflict with the names of the methods defined by the EJB architecture", new Object[]{methods[i].getName(), methods[i].getName()}));
                    }
                } while ((c = c.getSuperclass()) != null && !businessFound);
            }
            if (this.foundAtLeastOne == 0) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", " [ {0} ] does not declare any business methods.", new Object[]{descriptor.getEjbClassName()}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            oneFailed = true;
            this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{remote, descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

