/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class BusinessMethodExceptionCheck
extends EjbTest
implements EjbCheck {
    Result result = null;
    int foundWarning = 0;
    int foundAtLeastOne = 0;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor) {
            boolean oneFailed = false;
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else if (this.foundAtLeastOne == 0) {
                this.result.setStatus(3);
            } else if (this.foundWarning > 0) {
                this.result.setStatus(2);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean , but called with {2}.", new Object[]{this.getClass(), "Session", descriptor.getName()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> rc = jcl.loadClass(remote);
            Class<?> c = jcl.loadClass(descriptor.getEjbClassName());
            Method[] remoteMethods = rc.getMethods();
            for (int i = 0; i < remoteMethods.length; ++i) {
                if (remoteMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBObject") || remoteMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) continue;
                Class[] parameterTypes = remoteMethods[i].getParameterTypes();
                Method method = BusinessMethodExceptionCheck.getMethod(c, remoteMethods[i].getName(), parameterTypes);
                if (method == null) continue;
                ++this.foundAtLeastOne;
                Class<?>[] exceptionsRemote = remoteMethods[i].getExceptionTypes();
                Class<?>[] exceptions = method.getExceptionTypes();
                for (int m = 0; m < exceptions.length; ++m) {
                    boolean flag = false;
                    for (int n = 0; n < exceptionsRemote.length; ++n) {
                        if (!exceptionsRemote[n].getName().equals(exceptions[m].getName())) continue;
                        flag = true;
                    }
                    if (flag) continue;
                    this.result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business Method [ {1} ]", new Object[]{c.getName(), method.getName()}));
                    this.result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning1", "Not Compatible Exception:\n A public business method [ {0} ] was found, but\n according to  EJB spec, all the exceptions defined\n in the throws clause of the matching method of the session \n bean  class must be defined in the throws clause of \n the method of the remote interface. Exception [ {1} ] \n is not  defined in bean's remote interface. ", new Object[]{method.getName(), exceptions[m].getName()}));
                    ++this.foundWarning;
                }
            }
            if (this.foundWarning == 0) {
                this.addGoodDetails(this.result, this.compName);
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] ", new Object[]{c.getName()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "All the exceptions defined in the throws clause of the matching\nbusiness methods are defined in the throws clause of the method\nof the remote interface "));
            }
            if (this.foundAtLeastOne == 0) {
                this.addNaDetails(this.result, this.compName);
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", " [ {0} ] does not declare any business methods. ", new Object[]{descriptor.getEjbClassName()}));
            }
            return oneFailed;
        }
        catch (Exception e) {
            Verifier.debug(e);
            oneFailed = true;
            this.addErrorDetails(this.result, this.compName);
            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{remote, descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

