/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;
import java.util.Set;

public class SecurityIdentityRefs
extends EjbTest {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (descriptor.getUsesCallerIdentity()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.notApplicable3", "Bean [ {0} ] does not specify a run-as identity", new Object[]{descriptor.getName()}));
            return result;
        }
        RunAsIdentityDescriptor identity = descriptor.getRunAsIdentity();
        if (identity == null) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.notApplicable2", "Bean [ {0} ] does not specify a security identity", new Object[]{descriptor.getName()}));
            return result;
        }
        EjbBundleDescriptor bundleDescriptor = descriptor.getEjbBundleDescriptor();
        Set roles = bundleDescriptor.getRoles();
        Iterator roleIterator = roles.iterator();
        while (roleIterator.hasNext()) {
            Role role = (Role)roleIterator.next();
            if (!role.getName().equals(identity.getRoleName())) continue;
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.passed", "Security identity run-as specified identity [ {0} ] role is found in the list of roles", new Object[]{role.getName()}));
            return result;
        }
        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.failed", "Security identity run-as specified identity [ {0} ] role is not valid", new Object[]{identity.getRoleName()}));
        return result;
    }
}

