/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;

public class LocalInterfaceExposed
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceClassExist.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        EjbBundleDescriptor bundle = descriptor.getEjbBundleDescriptor();
        Iterator iterator = bundle.getEjbs().iterator();
        HashSet<String> localInterfaces = new HashSet<String>();
        while (iterator.hasNext()) {
            EjbAbstractDescriptor entity = (EjbAbstractDescriptor)iterator.next();
            if (!(entity instanceof EjbSessionDescriptor) && !(entity instanceof EjbEntityDescriptor) || entity.getLocalClassName() == null || "".equals(entity.getLocalClassName())) continue;
            localInterfaces.add(entity.getLocalClassName());
        }
        Context context = this.getVerifierContext();
        ClassLoader jcl = context.getClassLoader();
        iterator = bundle.getEjbs().iterator();
        EjbDescriptor entity = null;
        try {
            while (iterator.hasNext()) {
                entity = (EjbDescriptor)iterator.next();
                if (!(entity instanceof EjbSessionDescriptor) && !(entity instanceof EjbEntityDescriptor)) continue;
                if (entity.getRemoteClassName() != null && !"".equals(entity.getRemoteClassName())) {
                    Class<?> c = jcl.loadClass(entity.getRemoteClassName());
                    Method[] methods = c.getDeclaredMethods();
                    String localIntf = "";
                    for (int i = 0; i < methods.length; ++i) {
                        Iterator itr = localInterfaces.iterator();
                        while (itr.hasNext()) {
                            localIntf = (String)itr.next();
                            if (!methods[i].getReturnType().getName().equals(localIntf)) continue;
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.LocalInterfaceExposed.failed", "Error : Local Interface [ {0} ] has been exposed in remote interface [ {1} ]", new Object[]{localIntf, entity.getRemoteClassName()}));
                            return result;
                        }
                    }
                    continue;
                }
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "Valid: No remote interface found.", new Object[0]));
                return result;
            }
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: Local Interfaces have not  been exposed in remote interface [ {0} ]", new Object[]{entity.getRemoteClassName()}));
            return result;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Verifier.debug(e);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.LocalInterfaceExposed.failedException", "Error: [ {0} ] class not found.", new Object[]{entity.getRemoteClassName()}));
            return result;
        }
    }
}

