/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;

public class EjbRefNamePrefixed
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        boolean oneWarning = false;
        if (!descriptor.getEjbReferenceDescriptors().isEmpty()) {
            Iterator itr = descriptor.getEjbReferenceDescriptors().iterator();
            while (itr.hasNext()) {
                EjbReferenceDescriptor nextEjbReference = (EjbReferenceDescriptor)itr.next();
                String ejbRefName = nextEjbReference.getName();
                if (ejbRefName.startsWith("ejb/")) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] is prefixed with recommended string ejb/ within bean [ {1} ]", new Object[]{ejbRefName, descriptor.getName()}));
                    continue;
                }
                if (!oneWarning) {
                    oneWarning = true;
                }
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: [ {0} ] is not prefixed with recommended string ejb/ within bean [ {1} ]", new Object[]{ejbRefName, descriptor.getName()}));
            }
            if (oneWarning) {
                result.setStatus(2);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no ejb references to other beans within this bean [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

