/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.ejb.TimedObject;

public class ContainerTransactionStyle3
extends EjbTest
implements EjbCheck {
    Result result = null;
    int na = 0;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return this.result;
        }
        try {
            boolean oneFailed = false;
            boolean remoteInterfaceType = false;
            boolean localInterfaceType = false;
            boolean remoteHomeInterfaceType = false;
            boolean localHomeInterfaceType = false;
            if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                if (!"".equals(descriptor.getRemoteClassName()) && descriptor.getRemoteClassName() != null) {
                    remoteInterfaceType = true;
                }
                if (!"".equals(descriptor.getLocalClassName()) && descriptor.getLocalClassName() != null) {
                    localInterfaceType = true;
                }
                if (!"".equals(descriptor.getHomeClassName()) && descriptor.getHomeClassName() != null) {
                    remoteHomeInterfaceType = true;
                }
                if (!"".equals(descriptor.getLocalHomeClassName()) && descriptor.getLocalHomeClassName() != null) {
                    localHomeInterfaceType = true;
                }
                if (oneFailed = this.commonToBothInterfaces(remoteInterfaceType, remoteHomeInterfaceType, localInterfaceType, localHomeInterfaceType, descriptor)) {
                    this.result.setStatus(1);
                } else if (this.na == descriptor.getMethodContainerTransactions().size()) {
                    this.result.setStatus(3);
                } else {
                    this.result.setStatus(0);
                }
            } else {
                this.addNaDetails(this.result, this.compName);
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no method permissions within this bean [ {0} ]", new Object[]{descriptor.getName()}));
            }
            return this.result;
        }
        catch (Throwable t) {
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{descriptor.getName(), t.getMessage(), descriptor.getName()}));
            return this.result;
        }
    }

    private boolean commonToBothInterfaces(boolean remoteInterfaceType, boolean remoteHomeInterfaceType, boolean localInterfaceType, boolean localHomeInterfaceType, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        boolean foundItInWildCard = false;
        boolean foundItInLocalInterface = false;
        boolean foundItInLocalHomeInterface = false;
        String remote = "";
        String home = "";
        String local = "";
        String localHome = "";
        boolean style2 = false;
        boolean foundItInHomeInterface = false;
        boolean foundItInRemoteInterface = false;
        Class<?> hc = null;
        Class<?> rc = null;
        Class<?> lhc = null;
        Class<?> lc = null;
        try {
            Method[] localMethods;
            Method[] localHomeMethods;
            Method[] remoteMethods;
            Method[] homeMethods;
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            if (remoteInterfaceType && remoteHomeInterfaceType) {
                remote = descriptor.getRemoteClassName();
                home = descriptor.getHomeClassName();
                hc = jcl.loadClass(home);
                homeMethods = hc.getMethods();
                rc = jcl.loadClass(remote);
                remoteMethods = rc.getMethods();
            } else {
                homeMethods = new Method[]{};
                remoteMethods = new Method[]{};
            }
            if (localInterfaceType && localHomeInterfaceType) {
                local = descriptor.getLocalClassName();
                localHome = descriptor.getLocalHomeClassName();
                lhc = jcl.loadClass(localHome);
                localHomeMethods = lhc.getMethods();
                lc = jcl.loadClass(local);
                localMethods = lc.getMethods();
            } else {
                localHomeMethods = new Method[]{};
                localMethods = new Method[]{};
            }
            boolean isTimedObject = TimedObject.class.isAssignableFrom(jcl.loadClass(descriptor.getEjbClassName()));
            Enumeration ee = descriptor.getMethodContainerTransactions().keys();
            while (ee.hasMoreElements()) {
                foundItInWildCard = false;
                style2 = false;
                foundItInHomeInterface = false;
                foundItInRemoteInterface = false;
                foundItInLocalHomeInterface = false;
                foundItInLocalInterface = false;
                MethodDescriptor methodDescriptor = (MethodDescriptor)ee.nextElement();
                if (methodDescriptor.getName().equals(MethodDescriptor.ALL_EJB_METHODS)) {
                    foundItInWildCard = true;
                } else if (methodDescriptor.getParameterClassNames() == null) {
                    style2 = true;
                }
                if (!foundItInWildCard && !style2) {
                    String[] params;
                    if (isTimedObject && MethodDescriptor.EJB_BEAN.equals(methodDescriptor.getEjbClassSymbol()) && methodDescriptor.getName().equals("ejbTimeout") && (params = methodDescriptor.getJavaParameterClassNames()).length == 1 && params[0].trim().equals("javax.ejb.Timer")) {
                        this.addGoodDetails(this.result, this.compName);
                        this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "Container Transaction method name [ ejbTimeout ] defined in [ {0} ] class.", new Object[]{descriptor.getName()}));
                        continue;
                    }
                    if (remoteHomeInterfaceType) {
                        for (int i = 0; i < homeMethods.length; ++i) {
                            if (methodDescriptor.getEjbClassSymbol() != null && (!methodDescriptor.getEjbClassSymbol().equals("") && !methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) || !homeMethods[i].getName().equals(methodDescriptor.getName()) || !MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(homeMethods[i], MethodDescriptor.EJB_HOME).getParameterClassNames()))) continue;
                            foundItInHomeInterface = true;
                            break;
                        }
                    }
                    if (localHomeInterfaceType) {
                        for (int i = 0; i < localHomeMethods.length; ++i) {
                            if (methodDescriptor.getEjbClassSymbol() != null && (!methodDescriptor.getEjbClassSymbol().equals("") && !methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME) || !localHomeMethods[i].getName().equals(methodDescriptor.getName()) || !MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(localHomeMethods[i], MethodDescriptor.EJB_LOCALHOME).getParameterClassNames()))) continue;
                            foundItInLocalHomeInterface = true;
                            break;
                        }
                    }
                    if (!foundItInHomeInterface) {
                        if (remoteInterfaceType) {
                            for (int j = 0; j < remoteMethods.length; ++j) {
                                if (methodDescriptor.getEjbClassSymbol() != null && (!methodDescriptor.getEjbClassSymbol().equals("") && !methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) || !remoteMethods[j].getName().equals(methodDescriptor.getName()) || !MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(remoteMethods[j], MethodDescriptor.EJB_REMOTE).getParameterClassNames()))) continue;
                                foundItInRemoteInterface = true;
                                break;
                            }
                        }
                        if (localInterfaceType) {
                            for (int j = 0; j < localMethods.length; ++j) {
                                if (methodDescriptor.getEjbClassSymbol() != null && (!methodDescriptor.getEjbClassSymbol().equals("") && !methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCAL) || !localMethods[j].getName().equals(methodDescriptor.getName()) || !MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(localMethods[j], MethodDescriptor.EJB_LOCAL).getParameterClassNames()))) continue;
                                foundItInLocalInterface = true;
                                break;
                            }
                        }
                    }
                }
                if (foundItInWildCard) {
                    ++this.na;
                    this.addNaDetails(this.result, this.compName);
                    this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Container Transaction method name [ {0} ], test not applicable.", new Object[]{methodDescriptor.getName()}));
                    continue;
                }
                if (style2) {
                    ++this.na;
                    this.addNaDetails(this.result, this.compName);
                    this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable3", "Container Transaction method name [ {0} ] uses style2 container transaction, test not applicable.", new Object[]{methodDescriptor.getName()}));
                    continue;
                }
                if (foundItInHomeInterface) {
                    this.addGoodDetails(this.result, this.compName);
                    this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Container Transaction method name [ {0} ] defined in [ {1} ] interface.", new Object[]{methodDescriptor.getName(), "Home"}));
                    continue;
                }
                if (foundItInRemoteInterface) {
                    this.addGoodDetails(this.result, this.compName);
                    this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Container Transaction method name [ {0} ] defined in [ {1} ] interface.", new Object[]{methodDescriptor.getName(), "Remote"}));
                    continue;
                }
                if (foundItInLocalHomeInterface) {
                    this.addGoodDetails(this.result, this.compName);
                    this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Container Transaction method name [ {0} ] defined in [ {1} ] interface.", new Object[]{methodDescriptor.getName(), "LocalHome"}));
                    continue;
                }
                if (foundItInLocalInterface) {
                    this.addGoodDetails(this.result, this.compName);
                    this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Container Transaction method name [ {0} ] defined in [ {1} ] interface.", new Object[]{methodDescriptor.getName(), "Local"}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Container Transaction method name [ {0} ] not defined in [ {1} ] or [ {2} ] interface.", new Object[]{methodDescriptor.getName(), "Home", "Component"}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            oneFailed = true;
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] or [{1}] or Remote interface [ {2} ] or [{3}] does not exist or is not loadable within bean [ {4} ]", new Object[]{home, localHome, remote, local, descriptor.getName()}));
            return oneFailed;
        }
    }
}

