/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Method;

public class ApplicationExceptionHomeInterfaceMethods
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return this.result;
        }
        boolean oneFailed = false;
        if (descriptor.getHomeClassName() != null) {
            oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
        }
        if (!oneFailed && descriptor.getLocalHomeClassName() != null) {
            oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
        }
        if (oneFailed) {
            this.result.setStatus(1);
        } else {
            this.result.setStatus(0);
        }
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        ComponentNameConstructor compName = null;
        try {
            compName = new ComponentNameConstructor(descriptor);
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> c = jcl.loadClass(home);
            Method[] methods = c.getDeclaredMethods();
            boolean validApplicationException = false;
            for (int i = 0; i < methods.length; ++i) {
                validApplicationException = false;
                Class[] methodExceptionTypes = methods[i].getExceptionTypes();
                if (EjbUtils.isValidApplicationException(methodExceptionTypes)) {
                    validApplicationException = true;
                }
                if (validApplicationException) {
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The method [ {0} ] throws valid application exceptions in Home interface [ {1} ]", new Object[]{methods[i].getName(), home}));
                    continue;
                }
                if (validApplicationException) continue;
                if (!oneFailed) {
                    oneFailed = true;
                }
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: method [ {0} ] does not throw valid application exceptions in Home interface [ {1} ]", new Object[]{methods[i].getName(), home}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            oneFailed = true;
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
            return oneFailed;
        }
        catch (Throwable t) {
            Verifier.debug(t);
            oneFailed = true;
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedThrowable", "Error: [ {0} ] class encountered [ {1} ]. Cannot access methods of class [ {2} ] within [ {3} ].", new Object[]{home, t.toString(), t.getMessage(), descriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri()}));
            return oneFailed;
        }
    }
}

