/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.managed;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public abstract class ManagedConnectionFactoryTest
extends ConnectorTest {
    private String managedConnectionFactoryImpl;

    protected Class getManagedConnectionFactoryImpl(ConnectorDescriptor descriptor) throws ClassNotFoundException {
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        if (outboundRA == null) {
            return null;
        }
        Set connDefs = outboundRA.getConnectionDefs();
        Iterator iter = connDefs.iterator();
        while (iter.hasNext()) {
            ConnectionDefDescriptor connDefDesc = (ConnectionDefDescriptor)iter.next();
            this.managedConnectionFactoryImpl = connDefDesc.getManagedConnectionFactoryImpl();
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getRarClassLoader();
            Class<?> implClass = jcl.loadClass(this.managedConnectionFactoryImpl);
            if (!ManagedConnectionFactoryTest.isImplementorOf(implClass, "javax.resource.spi.ManagedConnectionFactory")) continue;
            return implClass;
        }
        return null;
    }

    protected Class testManagedConnectionFactoryImpl(ConnectorDescriptor descriptor, Result result) {
        Class mcf = null;
        ComponentNameConstructor compName = null;
        try {
            compName = new ComponentNameConstructor(descriptor);
            mcf = this.getManagedConnectionFactoryImpl(descriptor);
            if (mcf == null) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.ManagedConnectionFactoryTest.nonimpl", "Error: The resource adapter must implement the javax.resource.spi.ManagedConnectionFactory interface and declare it in the managedconnecttionfactory-class deployment descriptor."));
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.ManagedConnectionFactoryTest.nonexist", "Error: The class [ {0} ] as defined in the managedconnecttionfactory-class deployment descriptor does not exist", new Object[]{this.managedConnectionFactoryImpl}));
        }
        return mcf;
    }

    protected boolean testImplementationOf(ConnectorDescriptor descriptor, String interfaceName, Result result) {
        Class mcf = this.testManagedConnectionFactoryImpl(descriptor, result);
        if (mcf != null) {
            return ManagedConnectionFactoryTest.testImplementationOf(mcf, interfaceName, result);
        }
        return false;
    }
}

