/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.managed;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public class CheckConnectionFactoryImplReferenceable
extends ConnectorTest
implements ConnectorCheck {
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (!descriptor.getOutBoundDefined()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.notApplicableForInboundRA", "Resource Adapter does not provide outbound communication"));
            return result;
        }
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        if (outboundRA == null) {
            return null;
        }
        boolean oneFailed = false;
        Set connDefs = outboundRA.getConnectionDefs();
        Iterator iter = connDefs.iterator();
        while (iter.hasNext()) {
            ConnectionDefDescriptor connDefDesc = (ConnectionDefDescriptor)iter.next();
            String connectionImpl = connDefDesc.getConnectionFactoryImpl();
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getRarClassLoader();
            Class<?> implClass = null;
            try {
                implClass = jcl.loadClass(connectionImpl);
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: The class [ {0} ] as defined under connectionfactory-impl-class in the deployment descriptor does not exist", new Object[]{connectionImpl}));
                return result;
            }
            if (CheckConnectionFactoryImplReferenceable.isImplementorOf(implClass, "javax.resource.Referenceable")) continue;
            oneFailed = true;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: connectionfactory-impl-class [ {0} ] does not implement javax.resource.Referenceable", new Object[]{implClass.getName()}));
            return result;
        }
        if (!oneFailed) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Success: all connectionfactory-impl-class implement javax.resource.Referenceable"));
        }
        return result;
    }
}

