/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.cci.CCITest;
import java.util.Iterator;
import java.util.Set;

public abstract class ConnectionFactoryTest
extends CCITest {
    protected Class getConnectionFactoryImpl(ConnectorDescriptor descriptor, Result result) {
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        if (outboundRA == null) {
            return null;
        }
        Set connDefs = outboundRA.getConnectionDefs();
        Iterator iter = connDefs.iterator();
        while (iter.hasNext()) {
            ConnectionDefDescriptor connDefDesc = (ConnectionDefDescriptor)iter.next();
            String impl = connDefDesc.getConnectionFactoryImpl();
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getRarClassLoader();
            Class<?> implClass = null;
            try {
                implClass = jcl.loadClass(impl);
            }
            catch (ClassNotFoundException cnfe) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionFactoryTest.nonexist", "Error: The class [ {0} ] as defined in the connectionfactory-impl-class deployment descriptor does not exist", new Object[]{impl}));
                return null;
            }
            if (!ConnectionFactoryTest.isImplementorOf(implClass, "javax.resource.cci.ConnectionFactory")) continue;
            return implClass;
        }
        return null;
    }

    protected Class testConnectionFactoryImpl(ConnectorDescriptor descriptor, Result result) {
        Class mcf = this.getConnectionFactoryImpl(descriptor, result);
        if (mcf == null) {
            ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionFactoryTest.nonimpl", "Error: The resource adapter must implement the javax.resource.cci.ConnectionFactory interface and declare it in the connectionfactory-impl-class deployment descriptor."));
        }
        return mcf;
    }

    protected boolean testImplementationOf(ConnectorDescriptor descriptor, String interfaceName, Result result) {
        Class mcf = this.testConnectionFactoryImpl(descriptor, result);
        if (mcf != null) {
            return ConnectionFactoryTest.testImplementationOf(mcf, interfaceName, result);
        }
        return false;
    }
}

