/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public abstract class CCITest
extends ConnectorTest {
    protected boolean isCCIImplemented(ConnectorDescriptor descriptor, Result result) {
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        if (outboundRA == null) {
            return false;
        }
        Set connDefs = outboundRA.getConnectionDefs();
        Iterator iter = connDefs.iterator();
        while (iter.hasNext()) {
            ConnectionDefDescriptor connDefDesc = (ConnectionDefDescriptor)iter.next();
            String intf = connDefDesc.getConnectionFactoryIntf();
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getRarClassLoader();
            Class<?> implClass = null;
            try {
                implClass = jcl.loadClass(intf);
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.failed", "The class [ {0} ] is not contained in the archive file", new Object[]{intf}));
                continue;
            }
            if (!CCITest.isImplementorOf(implClass, "javax.resource.cci.ConnectionFactory")) continue;
            return true;
        }
        return false;
    }

    protected String getConnectionInterface(ConnectorDescriptor descriptor, Result result) {
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        if (outboundRA == null) {
            return null;
        }
        Set connDefs = outboundRA.getConnectionDefs();
        Iterator iter = connDefs.iterator();
        while (iter.hasNext()) {
            ConnectionDefDescriptor connDefDesc = (ConnectionDefDescriptor)iter.next();
            String intf = connDefDesc.getConnectionIntf();
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getRarClassLoader();
            Class<?> intfClass = null;
            try {
                intfClass = jcl.loadClass(intf);
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.failed", "The class [ {0} ] is not contained in the archive file", new Object[]{intf}));
                continue;
            }
            if (!CCITest.isImplementorOf(intfClass, "javax.resource.cci.Connection")) continue;
            return intf;
        }
        return null;
    }
}

