/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public class CredentialInterface
extends ConnectorTest
implements ConnectorCheck {
    private static String[] allowedInterfaces = new String[]{"javax.resource.spi.security.PasswordCredential", "org.ietf.jgss.GSSCredential", "javax.resource.spi.security.GenericCredential"};

    public Result check(ConnectorDescriptor descriptor) {
        boolean oneFailed = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (!descriptor.getOutBoundDefined()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.notApplicableForInboundRA", "Resource Adapter does not provide outbound communication"));
            return result;
        }
        Set mechanisms = descriptor.getOutboundResourceAdapter().getAuthMechanisms();
        if (mechanisms.isEmpty()) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.AuthMechType.nonexist", "No authentication mechanism defined for this resource adapater"));
            return result;
        }
        Iterator mechIterator = mechanisms.iterator();
        while (mechIterator.hasNext()) {
            AuthMechanism am = (AuthMechanism)mechIterator.next();
            String credInterface = am.getCredentialInterface();
            boolean allowedInterface = false;
            if (credInterface != null) {
                for (int i = 0; i < allowedInterfaces.length; ++i) {
                    if (!credInterface.equals(allowedInterfaces[i])) continue;
                    allowedInterface = true;
                    break;
                }
            }
            if (allowedInterface && credInterface != null) continue;
            oneFailed = true;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.CredentialInterface.failed", "Authentication mechanism credential interface [ {0} ] defined in the credential-interface tag is not allowed", new Object[]{credInterface}));
        }
        if (!oneFailed) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.CredentialInterface.passed", "All defined authorization mechanism credential interfaces are allowed"));
        }
        return result;
    }
}

