/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;

public abstract class ConnectorTest
extends VerifierTest
implements VerifierCheck,
ConnectorCheck {
    static /* synthetic */ Class class$java$lang$Object;

    public Result check(Descriptor descriptor) {
        return this.check((ConnectorDescriptor)descriptor);
    }

    public abstract Result check(ConnectorDescriptor var1);

    protected Class findImplementorOf(ConnectorDescriptor desc, String interfaceName) {
        try {
            String uri = this.getAbstractArchiveUri(desc);
            FileArchive arch = new FileArchive();
            arch.open(uri);
            Enumeration en = arch.entries();
            while (en.hasMoreElements()) {
                String elementName = (String)en.nextElement();
                if (!elementName.endsWith(".class")) continue;
                String className = elementName.substring(0, elementName.length() - ".class".length()).replace('/', '.');
                try {
                    Class<?> c = null;
                    Context context = this.getVerifierContext();
                    ClassLoader jcl = context.getRarClassLoader();
                    c = jcl.loadClass(className);
                    if (!ConnectorTest.isImplementorOf(c, interfaceName) || c.getSuperclass() == null) continue;
                    return c;
                }
                catch (ClassNotFoundException cnfe) {
                }
            }
        }
        catch (IOException ioe) {
            Verifier.debug(ioe);
        }
        return null;
    }

    protected boolean checkMethodImpl(Class clazz, String methodName, Class[] parmTypes, String methodSignature, Result result) {
        Method m = null;
        Class c = clazz;
        do {
            try {
                m = c.getDeclaredMethod(methodName, parmTypes);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            c = c.getSuperclass();
        } while (m != null && c != null && c != (class$java$lang$Object == null ? ConnectorTest.class$("java.lang.Object") : class$java$lang$Object));
        if (m == null) {
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.MethodOverride.failed", "Warning: The class [ {0} ] does not override the method [ {1} ]", new Object[]{clazz.getName(), methodSignature}));
            return false;
        }
        result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.MethodOverride.passed", "The class [ {0} ] overrides the method [ {1} ]", new Object[]{clazz.getName(), methodSignature}));
        return true;
    }

    protected boolean findImplementorOf(ConnectorDescriptor desc, String interfaceName, Result result) {
        Class c = this.findImplementorOf(desc, interfaceName);
        if (c != null) {
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.findImplementor.passed", "The class [ {0} ] implements the [ {1} ] interface", new Object[]{c.getName(), interfaceName}));
            return true;
        }
        result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.findImplementor.failed", "Error: There is no implementation of the [ {0} ] provided", new Object[]{interfaceName}));
        return false;
    }

    protected boolean isClassLoadable(String className, Result result) {
        Context context = this.getVerifierContext();
        ClassLoader jcl = context.getClassLoader();
        try {
            jcl.loadClass(className);
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.passed", "The class [ {0} ] is contained in the archive file", new Object[]{className}));
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.failed", "The class [ {0} ] is not contained in the archive file", new Object[]{className}));
            return true;
        }
    }

    protected String getAbstractArchiveUri(ConnectorDescriptor desc) {
        String archBase = this.getVerifierContext().getAbstractArchive().getArchiveUri();
        if (desc.getApplication() != null) {
            String moduleName = desc.getModuleDescriptor().getArchiveUri();
            if (!moduleName.endsWith(".rar")) {
                return archBase;
            }
            String moduleDir = moduleName.replace('.', '_');
            String ret = archBase + File.separator + moduleDir;
            return ret;
        }
        return archBase;
    }
}

