/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests;

import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.XpathPrefixResolver;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.org.apache.xpath.internal.NodeSet;
import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.io.File;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class VerifierTest {
    private boolean addedError = false;
    private boolean addedGood = false;
    private boolean addedNa = false;
    private boolean addedWarning = false;
    protected Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    protected final boolean debug = Verifier.isDebug();
    protected static final LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private Context context = null;

    public void setVerifierContext(Context context) {
        this.context = context;
    }

    public Context getVerifierContext() {
        return this.context;
    }

    protected Result getInitializedResult() {
        this.logger.log(Level.FINE, "which.class.called.string", new Object[]{this.getClass()});
        Result result = new Result();
        result.init(this.getClass());
        this.logger.log(Level.FINE, "test.string.assertion", new Object[]{result.getAssertion()});
        return result;
    }

    public static boolean isSubclassOf(Class subClass, String superClassName) {
        if (subClass == null || superClassName == null) {
            return false;
        }
        Class c = subClass;
        do {
            if (c.getName().equals(superClassName)) {
                return true;
            }
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].getName().equals(superClassName)) {
                    return true;
                }
                if (!VerifierTest.isSubclassOf(interfaces[i], superClassName)) continue;
                return true;
            }
        } while ((c = c.getSuperclass()) != null);
        return false;
    }

    public static boolean isImplementorOf(Class c, String interfaceName) {
        if (c == null || interfaceName == null) {
            return false;
        }
        try {
            Class intf = Class.forName(interfaceName);
            return intf.isAssignableFrom(c);
        }
        catch (Exception e) {
            do {
                if (VerifierTest.isSubclassOf(c, interfaceName)) {
                    return true;
                }
                Class<?>[] interfaces = c.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!VerifierTest.isSubclassOf(interfaces[i], interfaceName)) continue;
                    return true;
                }
            } while ((c = c.getSuperclass()) != null);
            return false;
        }
    }

    public static Method getDeclaredMethod(Class clazz, String methodName, Class[] parmTypes) {
        Method m = null;
        Class c = clazz;
        do {
            try {
                m = clazz.getDeclaredMethod(methodName, parmTypes);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            c = c.getSuperclass();
        } while (m != null && c != null);
        return m;
    }

    public static Method getMethod(Class clazz, String methodName, Class[] parmTypes) {
        Method m = null;
        Class c = clazz;
        do {
            try {
                m = clazz.getMethod(methodName, parmTypes);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            c = c.getSuperclass();
        } while (m != null && c != null);
        return m;
    }

    public static boolean testImplementationOf(Class clazz, String interfaceName, Result result) {
        if (VerifierTest.isImplementorOf(clazz, interfaceName)) {
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.interfaceimplementation.passed", "The class [ {0} ] implements the [ {1} ] interface", new Object[]{clazz.getName(), interfaceName}));
            return true;
        }
        result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.interfaceimplementation.failed", "Error: The class [ {0} ] does not implement the [ {1} ] interface", new Object[]{clazz.getName(), interfaceName}));
        return false;
    }

    public static void testFileExistence(String uri, String fileName, String fileID, Result result) {
        FileArchive arch = null;
        ZipFile jarFile = null;
        if (fileName == null || fileName.length() == 0) {
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.notApplicable", "No {0} defined in deployment descriptors", new Object[]{fileID}));
            return;
        }
        try {
            arch = new FileArchive();
            arch.open(uri);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            File urif = new File(arch.getArchiveUri() + File.separator + fileName);
            if (urif.exists()) {
                result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.passed", "{0} [ {1} ] found in the archive", new Object[]{fileID, fileName}));
            } else {
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.failed", "Error: {0} [ {1} ] not found in the archive", new Object[]{fileID, fileName}));
            }
            urif = null;
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static boolean methodThrowException(Method method, String exception) {
        Class<?>[] exceptions = method.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!VerifierTest.isSubclassOf(exceptions[i], exception)) continue;
            return true;
        }
        return false;
    }

    public String getXPathValueForNonRuntime(String xpath) {
        try {
            String value = null;
            Document d = this.getVerifierContext().getDocument();
            if (d == null) {
                return null;
            }
            XObject result = XPathAPI.eval((Node)d, xpath, new XpathPrefixResolver(d));
            NodeList nl = result.nodelist();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i).getFirstChild();
                if (n == null) {
                    return null;
                }
                value = n.getNodeValue();
            }
            return value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getXPathValue(String xpath) {
        try {
            String value = null;
            Document d = this.getVerifierContext().getRuntimeDocument();
            if (d == null) {
                return null;
            }
            NodeList nl = XPathAPI.selectNodeList(d, xpath);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i).getFirstChild();
                if (n == null) {
                    return null;
                }
                value = n.getNodeValue();
            }
            return value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public int getCountNodeSet(String xpath) {
        try {
            Document d = this.getVerifierContext().getRuntimeDocument();
            if (d == null) {
                return -1;
            }
            NodeSet ns = new NodeSet(XPathAPI.selectNodeList(d, xpath));
            return ns.getLength();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public int getNonRuntimeCountNodeSet(String xpath) {
        try {
            Document d = this.getVerifierContext().getDocument();
            if (d == null) {
                return -1;
            }
            XObject result = XPathAPI.eval((Node)d, xpath, new XpathPrefixResolver(d));
            NodeList nl = result.nodelist();
            NodeSet ns = new NodeSet(nl);
            return ns.getLength();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public Float getRuntimeSpecVersion() {
        String docType = null;
        String versionStr = null;
        Float versionFloat = null;
        try {
            DocumentType dt = this.getVerifierContext().getRuntimeDocument().getDoctype();
            if (dt == null) {
                return null;
            }
            docType = dt.getPublicId();
            StringTokenizer st = new StringTokenizer(docType, "//");
            while (st.hasMoreElements()) {
                String tmp = st.nextToken();
                if (!tmp.startsWith("DTD")) continue;
                StringTokenizer versionST = new StringTokenizer(tmp);
                while (versionST.hasMoreElements()) {
                    versionStr = versionST.nextToken();
                    try {
                        versionFloat = Float.valueOf(versionStr);
                    }
                    catch (NumberFormatException nfe) {}
                }
            }
            return versionFloat;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void addGoodDetails(Result result, ComponentNameConstructor compName) {
        if (this.addedGood) {
            return;
        }
        this.addedGood = true;
        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
    }

    protected void addErrorDetails(Result result, ComponentNameConstructor compName) {
        if (this.addedError) {
            return;
        }
        this.addedError = true;
        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
    }

    protected void addWarningDetails(Result result, ComponentNameConstructor compName) {
        if (this.addedWarning) {
            return;
        }
        this.addedWarning = true;
        result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
    }

    protected void addNaDetails(Result result, ComponentNameConstructor compName) {
        if (this.addedNa) {
            return;
        }
        this.addedNa = true;
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
    }
}

