/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.EjbClosureCompiler;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl;
import com.sun.enterprise.util.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class EjbVerifier
extends BaseVerifier {
    private EjbBundleDescriptor ejbd = null;
    private String classPath;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EjbVerifier(FrameworkContext frameworkContext, EjbBundleDescriptor ejbd) {
        this.frameworkContext = frameworkContext;
        this.ejbd = ejbd;
    }

    public void verify() throws Exception {
        if (this.areTestsNotRequired(this.frameworkContext.isEjb())) {
            return;
        }
        this.preVerification();
        this.createClosureCompiler();
        this.verify(this.ejbd, new EjbCheckMgrImpl(this.frameworkContext));
    }

    public Descriptor getDescriptor() {
        return this.ejbd;
    }

    protected ClassLoader createClassLoader(File explodedArchive) throws MalformedURLException, IOException {
        JarClassLoader cl = new JarClassLoader();
        StringTokenizer st = new StringTokenizer(this.getClassPath(), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            try {
                cl.appendURL(new File(entry).toURL());
            }
            catch (MalformedURLException e) {
                LogRecord log = new LogRecord(Level.WARNING, "Ignoring " + entry);
                log.setThrown(e);
                this.frameworkContext.getResultManager().log(log);
            }
        }
        this.ejbd.setClassLoader(cl);
        return cl;
    }

    protected String getArchiveUri() {
        return new File(this.ejbd.getModuleDescriptor().getArchiveUri()).getName();
    }

    protected String[] getDDString() {
        String[] dd = new String[]{"META-INF/sun-ejb-jar.xml", "META-INF/ejb-jar.xml", "META-INF/webservices.xml"};
        return dd;
    }

    protected String getClassPath() throws IOException {
        String cp;
        if (this.classPath != null) {
            return this.classPath;
        }
        if (!this.ejbd.getModuleDescriptor().isStandalone()) {
            String ear_uri = this.frameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            if (!$assertionsDisabled && !ear.isDirectory()) {
                throw new AssertionError();
            }
            String earCP = ClassPathBuilder.buildClassPathForEar(ear);
            String module_uri = this.ejbd.getModuleDescriptor().getArchiveUri();
            File module = new File(module_uri);
            if (!($assertionsDisabled || module.isFile() && !module.isAbsolute())) {
                throw new AssertionError();
            }
            File explodedModuleDir = new File(ear_uri, module_uri.replaceAll("\\.", "_"));
            String moduleCP = ClassPathBuilder.buildClassPathForJar(explodedModuleDir);
            cp = moduleCP + File.pathSeparator + earCP;
        } else {
            String module_uri = this.frameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            if (!($assertionsDisabled || module.isDirectory() && module.isAbsolute())) {
                throw new AssertionError();
            }
            cp = ClassPathBuilder.buildClassPathForJar(module);
        }
        this.logger.log(Level.INFO, "Using CLASSPATH" + cp);
        this.classPath = cp;
        return this.classPath;
    }

    protected void createClosureCompiler() throws IOException {
        String specVer = this.ejbd.getSpecVersion();
        String cp = this.getClassPath();
        EjbClosureCompiler cc = new EjbClosureCompiler(specVer, ClassFileLoaderFactory.newInstance(new Object[]{cp}));
        this.context.setClosureCompiler(cc);
    }

    static {
        $assertionsDisabled = !EjbVerifier.class.desiredAssertionStatus();
    }
}

