/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.ejb;

import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.util.EjbBundleValidator;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.wsclient.WebServiceClientCheckMgrImpl;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGenerator;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class EjbCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private static final String testsListFileName = "TestNamesEjb.xml";
    private static final String sunONETestsListFileName = EjbCheckMgrImpl.getSunPrefix().concat("TestNamesEjb.xml");
    private Vector test = new Vector();
    private JDOCodeGenerator jdc = new JDOCodeGenerator();

    public EjbCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    public void check(Descriptor descriptor) throws Exception {
        EjbBundleDescriptor bundleDescriptor = (EjbBundleDescriptor)descriptor;
        this.setDescClassLoader(bundleDescriptor);
        try {
            EjbBundleValidator validator = new EjbBundleValidator();
            validator.accept(bundleDescriptor);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bundleDescriptor.containsCMPEntity()) {
            try {
                this.jdc.init(bundleDescriptor, this.context.getClassLoader(), this.getAbstractArchiveUri(bundleDescriptor));
            }
            catch (Throwable ex) {
                this.context.setJDOException(ex);
            }
        }
        this.context.setJDOCodeGenerator(this.jdc);
        Iterator itr = bundleDescriptor.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            super.check(ejbDescriptor);
        }
        this.checkWebServices(descriptor);
        this.checkWebServicesClient(descriptor);
        if (bundleDescriptor.containsCMPEntity() && this.context.getJDOException() == null) {
            try {
                this.jdc.cleanup();
            }
            catch (GeneratorException generatorException) {
                // empty catch block
            }
            this.context.setJDOCodeGenerator(null);
        }
    }

    protected String getTestsListFileName() {
        return testsListFileName;
    }

    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    protected Vector getTests() {
        return this.test;
    }

    protected void checkWebServicesClient(Descriptor descriptor) throws Exception {
        if (this.frameworkContext.isPartition() && !this.frameworkContext.isWebServicesClient()) {
            return;
        }
        EjbBundleDescriptor desc = (EjbBundleDescriptor)descriptor;
        WebServiceClientCheckMgrImpl webServiceClientCheckMgr = new WebServiceClientCheckMgrImpl(this.frameworkContext);
        if (desc.hasWebServiceClients()) {
            Set ejbdescs = desc.getEjbs();
            Iterator ejbIt = ejbdescs.iterator();
            while (ejbIt.hasNext()) {
                EjbDescriptor ejbDesc = (EjbDescriptor)ejbIt.next();
                this.context.setEjbDescriptorForServiceRef(ejbDesc);
                Set serviceRefDescriptors = ejbDesc.getServiceReferenceDescriptors();
                Iterator it = serviceRefDescriptors.iterator();
                while (it.hasNext()) {
                    webServiceClientCheckMgr.setVerifierContext(this.context);
                    webServiceClientCheckMgr.check((ServiceReferenceDescriptor)it.next());
                }
            }
            this.context.setEjbDescriptorForServiceRef(null);
        }
    }

    protected String getSpecVersion(Descriptor descriptor) {
        return ((EjbDescriptor)descriptor).getEjbBundleDescriptor().getSpecVersion();
    }

    protected void setModuleName(Result r) {
        r.setModuleName("ejb");
    }

    protected void loadTestInformationFromPropsFile() throws ParserConfigurationException, SAXException, IOException {
        Vector v = this.getTests();
        if (v.isEmpty()) {
            super.loadTestInformationFromPropsFile();
        }
    }

    protected String getArchiveUri(Descriptor descriptor) {
        String archiveUri = new File(((EjbDescriptor)descriptor).getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri()).getName();
        return archiveUri;
    }

    private String getAbstractArchiveUri(EjbBundleDescriptor desc) {
        String archBase = this.context.getAbstractArchive().getArchiveUri();
        if (desc.getApplication() != null) {
            String moduleName = desc.getModuleDescriptor().getArchiveUri();
            if (moduleName.lastIndexOf(".") != -1) {
                String moduleDir = moduleName.replace('.', '_');
                String ret = archBase + File.separator + moduleDir;
                return ret;
            }
            return archBase;
        }
        return archBase;
    }

    private void setDescClassLoader(EjbBundleDescriptor bundleDescriptor) {
        Iterator bundleItr = bundleDescriptor.getEjbs().iterator();
        while (bundleItr.hasNext()) {
            EjbDescriptor descriptor = (EjbDescriptor)bundleItr.next();
            if (!(descriptor instanceof IASEjbCMPEntityDescriptor)) continue;
            ((IASEjbCMPEntityDescriptor)descriptor).setClassLoader(this.context.getClassLoader());
        }
    }
}

