/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.JarArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.util.FileUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class VerifierUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyArchiveToDir(File source, File dest) throws IOException {
        Archive in = null;
        try {
            in = new JarArchiveFactory().openArchive(source.getAbsolutePath());
            VerifierUtils.copyArchiveToDir((AbstractArchive)in, dest);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void copyArchiveToDir(AbstractArchive source, File dest) throws IOException {
        Enumeration elements = source.entries();
        while (elements.hasMoreElements()) {
            String directory;
            File dir;
            String elementName = (String)elements.nextElement();
            InputStream is = source.getEntry(elementName);
            if (elementName.indexOf(47) != -1 && !(dir = new File(dest, directory = elementName.substring(0, elementName.lastIndexOf(47)))).exists()) {
                dir.mkdirs();
            }
            File elementFile = new File(dest, elementName);
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(elementFile));
            Archivist.copy(is, fos);
        }
    }

    public static List getJarsWars(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        if (new File(dir.getAbsolutePath() + File.separator + "META-INF" + File.separator + "ejb-jar.xml").exists()) {
            list.add(dir);
        }
        VerifierUtils.getJarsWars(dir, list);
        return list;
    }

    public static void getJarsWars(File dir, List list) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (file.getName().equals("classes") && file.getParentFile().getName().equals("WEB-INF") || file.getName().endsWith("_rar") || file.getName().endsWith("_jar")) {
                    list.add(file);
                    continue;
                }
                VerifierUtils.getJarsWars(file, list);
                continue;
            }
            String name = file.getName();
            if (!name.endsWith(".jar") && !FileUtil.isEJBJar(file) && !FileUtil.isAppClientJar(file) && !FileUtil.isWARFile(file)) continue;
            list.add(files[i]);
        }
    }
}

