/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.appclient.DummyRoleMapperFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.archivist.FileArchiveFactory;
import com.sun.enterprise.deployment.archivist.PluggableArchivistsHelper;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.deployment.backend.AppInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.EarExploder;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.OptionalPkgDependency;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.APIRepository;
import com.sun.enterprise.tools.verifier.app.ApplicationVerifier;
import com.sun.enterprise.tools.verifier.appclient.AppClientVerifier;
import com.sun.enterprise.tools.verifier.connector.ConnectorVerifier;
import com.sun.enterprise.tools.verifier.ejb.EjbVerifier;
import com.sun.enterprise.tools.verifier.web.WebVerifier;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;

public class VerificationHandler {
    private final String TMPDIR = System.getProperty("java.io.tmpdir");
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddhhmmss");
    private final String explodeDir = this.TMPDIR + File.separator + "exploded" + this.dateFormatter.format(new Date());
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private FrameworkContext frameworkContext = null;
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");

    public VerificationHandler(FrameworkContext frameworkContext) throws IOException {
        this.frameworkContext = frameworkContext;
        frameworkContext.setResultManager(new ResultManager());
        this.init();
    }

    public ResultManager verifyArchive() {
        Application application = null;
        ResultManager resultManager = this.frameworkContext.getResultManager();
        try {
            application = this.getApplicationDescriptor();
        }
        catch (IOException e) {
            this.log("Problem in creating application descriptor", e);
            this.cleanTmpDirs();
            return resultManager;
        }
        catch (SAXParseException se) {
            this.log("Problem in parsing the xml file", se);
            this.cleanTmpDirs();
            return resultManager;
        }
        ((Descriptor)application).visit(new ApplicationValidator());
        this.runVerifier(new ApplicationVerifier(this.frameworkContext, application));
        Iterator itr = application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            this.runVerifier(new EjbVerifier(this.frameworkContext, ejbd));
        }
        itr = application.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor webd = (WebBundleDescriptor)itr.next();
            this.runVerifier(new WebVerifier(this.frameworkContext, webd));
        }
        itr = application.getApplicationClientDescriptors().iterator();
        while (itr.hasNext()) {
            ApplicationClientDescriptor appClientDescriptor = (ApplicationClientDescriptor)itr.next();
            this.runVerifier(new AppClientVerifier(this.frameworkContext, appClientDescriptor));
        }
        itr = application.getRarDescriptors().iterator();
        while (itr.hasNext()) {
            ConnectorDescriptor cond = (ConnectorDescriptor)itr.next();
            this.runVerifier(new ConnectorVerifier(this.frameworkContext, cond));
        }
        this.cleanTmpDirs();
        return resultManager;
    }

    private void init() throws IOException {
        this.logger.log(Level.FINE, this.getClass().getName() + ".debug.startingLoadJar");
        DeploymentLogger.get().setLevel(Level.OFF);
        DOLUtils.getDefaultLogger().setLevel(Level.OFF);
        this.initVerifierTmpDirs();
        try {
            APIRepository.Initialize(this.frameworkContext.getConfigDirStr() + File.separator + "standard-apis.xml");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String jarFile = this.frameworkContext.getJarFileName();
        OptionalPkgDependency.satisfyOptionalPackageDependencies();
        this.explodeArchive(new File(jarFile));
        Descriptor.setBoundsChecking(false);
        this.registerRoleMapperFactory();
    }

    private final void registerRoleMapperFactory() {
        DummyRoleMapperFactory srmf = new DummyRoleMapperFactory();
        SecurityRoleMapperFactoryMgr.registerFactory(srmf);
    }

    private void runVerifier(BaseVerifier baseVerifier) {
        try {
            baseVerifier.verify();
        }
        catch (Exception e) {
            this.log("Problem in running tests for :" + baseVerifier.getDescriptor().getName(), e);
        }
    }

    private Application getApplicationDescriptor() throws IOException, SAXParseException {
        PluggableArchivistsHelper defaultArchivists = new PluggableArchivistsHelper();
        defaultArchivists.registerArchivist(new ApplicationArchivist());
        defaultArchivists.registerArchivist(new WebArchivist());
        defaultArchivists.registerArchivist(new EjbArchivist());
        defaultArchivists.registerArchivist(new ConnectorArchivist());
        defaultArchivists.registerArchivist(new AppClientArchivist());
        AbstractArchive abstractArchive = new FileArchiveFactory().openArchive(this.frameworkContext.getExplodedArchivePath());
        this.frameworkContext.setAbstractArchive(abstractArchive);
        Archivist archivist = ArchivistFactory.getArchivistForArchive(abstractArchive);
        archivist.setPluggableArchivists(defaultArchivists);
        archivist.setXMLValidationLevel("full");
        archivist.setRuntimeXMLValidation(true);
        archivist.setRuntimeXMLValidationLevel("full");
        String jarName = new File(abstractArchive.getArchiveUri()).getName();
        return ApplicationArchivist.openArchive(jarName, archivist, abstractArchive, this.frameworkContext.isAreRuntimeTestsNeeded());
    }

    private void explodeArchive(File archiveFile) throws IOException {
        block5: {
            if (archiveFile.isDirectory()) {
                this.frameworkContext.setExplodedArchivePath(archiveFile.getAbsolutePath());
                return;
            }
            String appName = FileUtils.makeFriendlyFileNameNoExtension(archiveFile.getName());
            File appDir = new File(new File(this.explodeDir), appName);
            AppInfo ai = new AppInfo(appDir, appName, archiveFile);
            this.frameworkContext.setExplodedArchivePath(appDir.getAbsolutePath());
            try {
                if (FileUtil.isEARFile(archiveFile)) {
                    new EarExploder(ai).explode();
                    break block5;
                }
                if (FileUtil.isWARFile(archiveFile) || FileUtil.isRARFile(archiveFile) || FileUtil.isEJBJar(archiveFile) || FileUtil.isAppClientJar(archiveFile)) {
                    J2EEModuleExploder.explode(archiveFile, appDir, null);
                    break block5;
                }
                throw new FileNotFoundException("Deployment descriptor not found in " + archiveFile.getName());
            }
            catch (Exception e) {
                this.cleanTmpDirs();
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private boolean initVerifierTmpDirs() throws IOException {
        File test = new File(this.explodeDir);
        if (!test.isDirectory() && !test.getAbsoluteFile().mkdirs()) {
            this.logger.log(Level.SEVERE, this.getClass().getName() + ".explodedircreateerror", test.getAbsolutePath());
            throw new IOException(this.smh.getLocalString(this.getClass().getName() + ".explodedircreateerror", test.getAbsolutePath()));
        }
        return true;
    }

    private void cleanTmpDirs() {
        if (!new File(this.frameworkContext.getJarFileName()).isDirectory()) {
            FileUtil.deleteDir(new File(this.frameworkContext.getExplodedArchivePath()).getParentFile());
        }
    }

    private void log(String message, Exception e) {
        if (message == null) {
            message = "";
        }
        LogRecord logRecord = new LogRecord(Level.SEVERE, message);
        logRecord.setThrown(e);
        this.frameworkContext.getResultManager().log(logRecord);
    }
}

