/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss;

import com.sun.enterprise.server.ss.ASClientSocketImpl;
import com.sun.enterprise.server.ss.ASSocketService;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASServerSocketImpl
extends SocketImpl {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private InetAddress hostToBind;
    private int portToBind;
    private ServerSocketChannel ssc;
    private ServerSocket ss;
    private Selector selector;

    public int available() throws IOException {
        throw new UnsupportedOperationException("available() not supported in ASServerSocketImpl");
    }

    public void connect(String s, int i) throws IOException {
        throw new UnsupportedOperationException("connect() not supported in ASServerSocketImpl");
    }

    public void connect(InetAddress ia, int i) throws IOException {
        throw new UnsupportedOperationException("connect() not supported in ASServerSocketImpl");
    }

    public void connect(SocketAddress sa, int i) throws IOException {
        throw new UnsupportedOperationException("connect() not supported in ASServerSocketImpl");
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("getInputStream() not supported in ASServerSocketImpl");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("getOutputStream() not supported in ASServerSocketImpl");
    }

    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("shutdownInput() not supported in ASServerSocketImpl");
    }

    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("shutdownOutput() not supported in ASServerSocketImpl");
    }

    public boolean supportsUrgentData() {
        throw new UnsupportedOperationException("supportsUrgentData() not supported in ASServerSocketImpl");
    }

    public void sendUrgentData(int i) throws IOException {
        throw new UnsupportedOperationException("sendUrgentData() not supported in ASServerSocketImpl");
    }

    public void close() throws IOException {
        block3: {
            if (this.ss != null) {
                try {
                    this.ss.close();
                    this.ssc.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINE)) break block3;
                    logger.log(Level.FINE, "" + e.getMessage(), e);
                }
            }
        }
    }

    public void create(boolean stream) throws IOException {
    }

    public void bind(InetAddress host, int port) throws IOException {
        this.hostToBind = host;
        this.portToBind = port;
    }

    public void listen(int backlog) throws IOException {
        if (!ASSocketService.exists(this.portToBind)) {
            this.ssc = ServerSocketChannel.open();
            this.ss = this.ssc.socket();
        } else {
            this.ssc = ASSocketService.getServerSocketChannel(this.portToBind);
            this.ss = ASSocketService.getServerSocket(this.portToBind);
        }
        InetSocketAddress isa = new InetSocketAddress(this.hostToBind, this.portToBind);
        this.ss.bind(isa, backlog);
        this.localport = this.ss.getLocalPort();
        this.address = this.ss.getInetAddress();
    }

    public void accept(SocketImpl si) throws IOException {
        Socket sock = this.ss.accept();
        ((ASClientSocketImpl)si).setClientSocket(sock);
    }

    public void setOption(int opt, Object val) throws SocketException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "In ASServerSocketImpl.setOption, opt = " + opt + " val = " + val, new Exception());
        }
        switch (opt) {
            case 4102: {
                if (val == null || !(val instanceof Integer)) {
                    throw new SocketException("Bad parameter for SO_TIMEOUT");
                }
                int tmp = (Integer)val;
                if (tmp < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.ss.setSoTimeout(tmp);
                break;
            }
            case 4098: {
                if (val == null || !(val instanceof Integer) || (Integer)val <= 0) {
                    throw new SocketException("bad parameter for SO_SNDBUF or SO_RCVBUF");
                }
                this.ss.setReceiveBufferSize((Integer)val);
                break;
            }
            case 4: {
                if (val == null || !(val instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_REUSEADDR");
                }
                this.ss.setReuseAddress((Boolean)val);
                break;
            }
            default: {
                throw new SocketException("unrecognized TCP option: " + opt);
            }
        }
    }

    public Object getOption(int opt) throws SocketException {
        switch (opt) {
            case 4102: {
                try {
                    return new Integer(this.ss.getSoTimeout());
                }
                catch (IOException ioe) {
                    throw new SocketException(ioe.getMessage());
                }
            }
            case 4098: {
                return new Integer(this.ss.getReceiveBufferSize());
            }
            case 4: {
                return new Boolean(this.ss.getReuseAddress());
            }
        }
        throw new SocketException("unrecognized TCP option: " + opt);
    }
}

