/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.action.GetPropertyAction;

public class SystemOutandErrHandler {
    private static final String SYSTEMERR_LOGGER = "javax.enterprise.system.stream.err";
    private static final String SYSTEMOUT_LOGGER = "javax.enterprise.system.stream.out";
    private static PrintStream originalSystemErr;
    private static Logger soLogger;
    private static Logger seLogger;
    private static Level errLogLevel;
    private static Level outLogLevel;
    private static String lineSeparator;
    private static int lineSeparatorSize;
    private LoggingPrintStream lout;
    private LoggingPrintStream lerr;
    private LoggingByteArrayOutputStream buf;

    public SystemOutandErrHandler() {
        if (originalSystemErr != null) {
            RuntimeException e = new RuntimeException("recursivecall");
            originalSystemErr.println("recursive call into SystemOutandErrhandler");
            e.printStackTrace(originalSystemErr);
            return;
        }
        this.buf = new LoggingByteArrayOutputStream();
        seLogger = Logger.getLogger(SYSTEMERR_LOGGER);
        this.buf.setLogger(seLogger, errLogLevel);
        originalSystemErr = System.err;
        this.lerr = new LoggingPrintStream(this.buf);
        System.setErr(this.lerr);
        this.buf = new LoggingByteArrayOutputStream();
        soLogger = Logger.getLogger(SYSTEMOUT_LOGGER);
        this.buf.setLogger(soLogger, outLogLevel);
        this.lout = new LoggingPrintStream(this.buf);
        System.setOut(this.lout);
        lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        lineSeparatorSize = lineSeparator.length();
    }

    static {
        soLogger = null;
        seLogger = null;
        errLogLevel = Level.WARNING;
        outLogLevel = Level.INFO;
    }

    private class StackTraceObjects {
        private ByteArrayOutputStream stackTraceBuf = new ByteArrayOutputStream();
        private PrintStream stStream = new PrintStream(this.stackTraceBuf, true);
        private String stString;
        private ByteArrayOutputStream comparisonBuf = new ByteArrayOutputStream();
        private int comparisonBufIndex = 0;
        private PrintStream cbStream = new PrintStream(this.comparisonBuf, true);
        private int stackTraceBufBytes = 0;
        private int charsIgnored = 0;

        private StackTraceObjects(Throwable x) {
            x.printStackTrace(this.stStream);
            this.stString = this.stackTraceBuf.toString();
            this.stackTraceBufBytes = this.stackTraceBuf.size();
            this.cbStream.println(x);
        }

        public String toString() {
            return this.stString;
        }

        boolean ignorePrintln(String str) {
            this.cbStream.println(str);
            String cbString = this.comparisonBuf.toString();
            int cbLen = cbString.length();
            if (this.stString.regionMatches(this.charsIgnored, cbString, 0, cbLen)) {
                this.charsIgnored += cbLen;
                this.comparisonBuf.reset();
                return true;
            }
            return false;
        }

        boolean checkCompletion() {
            return this.charsIgnored >= this.stackTraceBufBytes;
        }
    }

    private class LoggingByteArrayOutputStream
    extends ByteArrayOutputStream {
        private Level logLevel;
        private Logger logger;
        private boolean recursiveWarnIssued = false;
        private boolean inFlush = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            if (super.size() == 0) {
                return;
            }
            if (super.size() == lineSeparatorSize && super.toString().equals(lineSeparator)) {
                return;
            }
            LoggingByteArrayOutputStream loggingByteArrayOutputStream = this;
            synchronized (loggingByteArrayOutputStream) {
                if (this.inFlush) {
                    originalSystemErr.println(this.toString());
                    if (!this.recursiveWarnIssued) {
                        RuntimeException e = new RuntimeException("recursivecall");
                        originalSystemErr.println("recursive call into SystemOutandErrhandler");
                        e.printStackTrace(originalSystemErr);
                        this.recursiveWarnIssued = true;
                    }
                    return;
                }
                this.inFlush = true;
                super.flush();
                this.logger.log(this.logLevel, this.toString());
                this.inFlush = false;
                super.reset();
            }
        }

        public void setLogger(Logger systemlogger, Level loglevel) {
            this.logger = systemlogger;
            this.logLevel = loglevel;
        }
    }

    private class LoggingPrintStream
    extends PrintStream {
        private ByteArrayOutputStream bufOut;
        private ThreadLocal perThreadStObjects;

        public LoggingPrintStream(LoggingByteArrayOutputStream buf) {
            super(buf, true);
            this.perThreadStObjects = new ThreadLocal();
            this.bufOut = buf;
        }

        public void println(Object x) {
            StackTraceObjects sTO = (StackTraceObjects)this.perThreadStObjects.get();
            if (sTO != null) {
                this.perThreadStObjects.set(null);
            }
            if (!(x instanceof Throwable)) {
                super.println(x);
                return;
            }
            sTO = new StackTraceObjects((Throwable)x);
            this.perThreadStObjects.set(sTO);
            super.println(sTO.toString());
        }

        public void println(String str) {
            StackTraceObjects sTO = (StackTraceObjects)this.perThreadStObjects.get();
            if (sTO == null) {
                super.println(str);
                return;
            }
            if (!sTO.ignorePrintln(str)) {
                this.perThreadStObjects.set(null);
                super.println(str);
                return;
            }
            if (sTO.checkCompletion()) {
                this.perThreadStObjects.set(null);
                return;
            }
        }
    }
}

