/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.logging.LogMBean;
import com.sun.enterprise.server.logging.LogRotationTimer;
import com.sun.enterprise.server.logging.ServerLogManager;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.server.logging.logviewer.backend.LogFile;
import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import com.sun.enterprise.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class FileandSyslogHandler
extends StreamHandler {
    private MeteredStream meter;
    private Date date = new Date();
    private static final String LOGS_DIR = "logs";
    private static String logFileName = "server.log";
    private String absoluteFileName = null;
    private static boolean isInitialized = false;
    private LogMBean logMBean;
    private LogService logService = null;
    private static final int WARNING = Level.WARNING.intValue();
    private static final int SEVERE = Level.SEVERE.intValue();
    private static final String INSTANCE_ROOT_PROPERTY = "com.sun.aas.instanceRoot";
    private static final int MINIMUM_FILE_ROTATION_VALUE = 500000;
    private int limitForFileRotation = 0;
    private Object fileUpdateLock = new Object();
    private boolean rotationInProgress = false;
    private static final FileandSyslogHandler thisInstance = new FileandSyslogHandler();
    private LinkedList pendingLogRecordList = new LinkedList();
    private static boolean rotationRequested = false;
    private static final String LOG_ROTATE_DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ss";
    private static final SimpleDateFormat logRotateDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
    private static Vector _recentErrors = new Vector();
    private static final int MAX_RECENT_ERRORS = 4;

    public static synchronized FileandSyslogHandler getInstance() {
        return thisInstance;
    }

    public static synchronized Vector getRecentErrorMessages() {
        return _recentErrors;
    }

    public static synchronized void clearRecentErrorMessages() {
        _recentErrors = new Vector();
    }

    private static synchronized void addRecentErrorMessage(String error) {
        if (_recentErrors.size() < 4) {
            _recentErrors.add(error);
        } else {
            _recentErrors.removeElementAt(0);
            _recentErrors.add(3, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeFileName(String fileName) {
        if (fileName.trim().equals(this.absoluteFileName)) {
            return;
        }
        FileandSyslogHandler fileandSyslogHandler = this;
        synchronized (fileandSyslogHandler) {
            super.flush();
            super.close();
            try {
                this.openFile(fileName);
                LogFilter.setLogFile(new LogFile(fileName));
                this.absoluteFileName = fileName;
            }
            catch (IOException ix) {
                new ErrorManager().error("FATAL ERROR: COULD NOT OPEN LOG FILE. Please Check to make sure that the directory for Logfile exists. Currently reverting back to use the  default server.log", ix, 4);
                try {
                    this.openFile(this.absoluteFileName);
                }
                catch (Exception e) {
                    new ErrorManager().error("FATAL ERROR: COULD NOT RE-OPEN SERVER LOG FILE. ", e, 4);
                }
            }
        }
    }

    String getAbsoluteLogFileName() {
        return this.absoluteFileName;
    }

    synchronized void setLimitForRotation(int rotationLimitInBytes) {
        if (rotationLimitInBytes == 0 || rotationLimitInBytes >= 500000) {
            this.limitForFileRotation = rotationLimitInBytes;
        }
    }

    private FileandSyslogHandler() {
        try {
            this.setFormatter(new UniformLogFormatter());
        }
        catch (Exception e) {
            new ErrorManager().error("FATAL ERROR: COULD NOT INSTANTIATE FILE AND SYSLOG HANDLER", e, 0);
        }
    }

    public String createFileName() {
        ServerContext sc = ApplicationServer.getServerContext();
        String instDir = "";
        instDir = sc != null ? sc.getInstanceEnvironment().getInstancesRoot() : System.getProperty(INSTANCE_ROOT_PROPERTY);
        String[] names = new String[]{instDir, LOGS_DIR, logFileName};
        return StringUtils.makeFilePath((String[])names, (boolean)false);
    }

    private void openFile(String fileName) throws IOException {
        File file = new File(fileName);
        FileOutputStream fout = new FileOutputStream(fileName, true);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, file.length());
        this.setOutputStream(this.meter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestRotation() {
        FileandSyslogHandler fileandSyslogHandler = this;
        synchronized (fileandSyslogHandler) {
            rotationRequested = true;
        }
    }

    private void rotate() {
        final FileandSyslogHandler thisInstance = this;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                thisInstance.flush();
                thisInstance.close();
                StringBuffer renamedFileName = null;
                try {
                    File oldFile = new File(FileandSyslogHandler.this.absoluteFileName);
                    renamedFileName = new StringBuffer(FileandSyslogHandler.this.absoluteFileName + "_");
                    logRotateDateFormatter.format(new Date(), renamedFileName, new FieldPosition(0));
                    File rotatedFile = new File(renamedFileName.toString());
                    boolean renameSuccess = oldFile.renameTo(rotatedFile);
                    if (!renameSuccess) {
                        FileandSyslogHandler.this.planBLogRotate(FileandSyslogHandler.this.absoluteFileName, renamedFileName.toString());
                        String freshServerLogFileName = FileandSyslogHandler.this.createFileName();
                        FileOutputStream fo = new FileOutputStream(freshServerLogFileName);
                        fo.close();
                    }
                    FileandSyslogHandler.this.openFile(FileandSyslogHandler.this.createFileName());
                    LogFilter.setLogFile(new LogFile(FileandSyslogHandler.this.absoluteFileName));
                    LogRotationTimer.getInstance().restartTimer();
                }
                catch (IOException ix) {
                    new ErrorManager().error("FATAL ERROR: COULD NOT OPEN LOG FILE..", ix, 4);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planBLogRotate(String originalFileName, String renamedFileName) {
        FileOutputStream fo = null;
        FileInputStream fi = null;
        try {
            fo = new FileOutputStream(renamedFileName);
            fi = new FileInputStream(originalFileName);
            int BUF_SIZE = 4096;
            byte[] buffer = new byte[BUF_SIZE];
            int i = -1;
            while ((i = fi.read(buffer)) != -1) {
                if (i == BUF_SIZE) {
                    fo.write(buffer);
                    continue;
                }
                byte[] tempBuffer = new byte[i];
                int j = 0;
                for (j = 0; j < i; ++j) {
                    tempBuffer[j] = buffer[j];
                }
                fo.write(tempBuffer);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                fo.close();
                fi.close();
            }
            catch (Exception e) {}
        }
    }

    public synchronized void publish(LogRecord record) {
        int level;
        if (this.rotationInProgress) {
            this.pendingLogRecordList.addLast(record);
            return;
        }
        if (this.meter == null) {
            try {
                this.absoluteFileName = this.createFileName();
                this.openFile(this.absoluteFileName);
            }
            catch (Exception e) {
                throw new RuntimeException("Serious Error Couldn't open Log File" + e);
            }
        }
        super.publish(record);
        this.flush();
        if (rotationRequested || this.limitForFileRotation > 0 && this.meter.written >= (long)this.limitForFileRotation) {
            this.rotationInProgress = true;
            this.rotate();
            this.rotationInProgress = false;
            rotationRequested = false;
            while (this.pendingLogRecordList.size() != 0) {
                this.publish((LogRecord)this.pendingLogRecordList.removeFirst());
            }
        }
        if ((level = record.getLevel().intValue()) != WARNING && level != SEVERE) {
            return;
        }
        String logMessage = this.getFormatter().format(record);
        FileandSyslogHandler.addRecentErrorMessage(logMessage);
        if (this.logService == null) {
            this.logService = ServerLogManager.getLogService();
        }
        if (this.logService == null) {
            return;
        }
        if (record.getLevel().intValue() == WARNING) {
            LogMBean.getInstance().raiseWarningAlarm(logMessage);
        } else if (record.getLevel().intValue() == SEVERE) {
            LogMBean.getInstance().raiseSevereAlarm(logMessage);
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        long written;

        MeteredStream(OutputStream out, long written) {
            this.out = out;
            this.written = written;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += (long)buff.length;
        }

        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += (long)len;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

