/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.DeployEventListenerHelper;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEventListener;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class WebModuleDeployEventListener
implements ModuleDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(WebModuleDeployEventListener.class);
    private Hashtable cachedWebModules = new Hashtable();
    private WebModulesManager webModulesManager = null;
    protected WebContainer webContainer = null;

    private WebModuleDeployEventListener() {
    }

    public WebModuleDeployEventListener(WebContainer webContainer) {
        this.webContainer = webContainer;
        AdminEventListenerRegistry.addModuleDeployEventListener(this);
    }

    private WebModuleConfig loadWebModuleConfig(WebModule wm) {
        WebModuleConfig wmInfo = new WebModuleConfig();
        wmInfo.setBean(wm);
        String wmID = wm.getName();
        String location = wm.getLocation();
        try {
            Application app = this.getWebModulesManager().getDescriptor(wmID, location);
            WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
            wmInfo.setDescriptor(wbd);
            String vs = ServerBeansFactory.getVirtualServersByAppName(wm.getConfigContext(), wmID);
            wmInfo.setVirtualServers(vs);
        }
        catch (ConfigException ce) {
            wmInfo = null;
        }
        return wmInfo;
    }

    private void moduleDeployed(ConfigContext config, String moduleName) throws AdminEventListenerException {
        WebModule webModule = (WebModule)this.cachedWebModules.get(moduleName);
        if (webModule == null) {
            webModule = this.getWebModule(config, moduleName);
            this.cachedWebModules.put(moduleName, webModule);
        }
        if (!this.isEnabled(config, moduleName)) {
            return;
        }
        String location = webModule.getLocation();
        File moduleBase = new File(location);
        String modulesRoot = this.webContainer.getModulesRoot();
        if (!moduleBase.isAbsolute()) {
            location = modulesRoot + File.separator + location;
            webModule.setLocation(location);
        }
        WebModuleConfig wmInfo = this.loadWebModuleConfig(webModule);
        this.webContainer.loadWebModule(wmInfo, "null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleUndeployed(ConfigContext config, String moduleName) throws AdminEventListenerException {
        String virtualServers;
        String contextRoot;
        WebBundleDescriptor wbd;
        String appName;
        block11: {
            WebModule webModule = (WebModule)this.cachedWebModules.get(moduleName);
            if (webModule == null) {
                webModule = this.getWebModule(config, moduleName);
            } else {
                this.cachedWebModules.remove(moduleName);
            }
            appName = null;
            try {
                Application app = this.getWebModulesManager().getDescriptor(webModule.getName(), webModule.getLocation());
                RoleMapper.removeRoleMapper(app.getRoleMapper().getName());
                wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
                appName = app.getRegistrationName();
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce);
            }
            contextRoot = webModule.getContextRoot();
            virtualServers = null;
            try {
                virtualServers = ServerBeansFactory.getVirtualServersByAppName(config, moduleName);
            }
            catch (ConfigException ce) {
                if (!_logger.isLoggable(Level.FINEST)) break block11;
                _logger.log(Level.FINEST, "Exception getting virtual servers by app name " + moduleName, ce);
            }
        }
        try {
            this.webContainer.unloadWebModule(contextRoot, appName, virtualServers, wbd);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                Switch.getSwitch().getNamingManager().unbindObjects(wbd);
            }
            catch (NamingException nameEx) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener]  Exception during namingManager.unbindObject", nameEx);
            }
            throw throwable;
        }
        try {
            Switch.getSwitch().getNamingManager().unbindObjects(wbd);
        }
        catch (NamingException nameEx) {
            _logger.log(Level.FINEST, "[WebModuleDeployEventListener]  Exception during namingManager.unbindObject", nameEx);
        }
    }

    public synchronized void moduleDeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
            }
            DeployEventListenerHelper.getDeployEventListenerHelper().synchronize(event);
            ConfigContext config = event.getConfigContext();
            String moduleName = event.getModuleName();
            try {
                this.getWebModulesManager().refreshConfigContext(config);
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce.getMessage());
            }
            this.moduleDeployed(config, moduleName);
        }
    }

    public synchronized void moduleUndeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
            }
            ConfigContext config = event.getOldConfigContext();
            String moduleName = event.getModuleName();
            try {
                this.getWebModulesManager().refreshConfigContext(config);
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce.getMessage());
            }
            this.moduleUndeployed(config, moduleName);
        }
    }

    public synchronized void moduleRedeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
            }
            String moduleName = event.getModuleName();
            ConfigContext oldConfig = event.getOldConfigContext();
            this.moduleUndeployed(oldConfig, moduleName);
            ConfigContext config = event.getConfigContext();
            this.moduleDeployed(config, moduleName);
        }
    }

    public synchronized void moduleEnabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
            }
            ConfigContext config = event.getConfigContext();
            String moduleName = event.getModuleName();
            WebModule webModule = (WebModule)this.cachedWebModules.get(moduleName);
            if (webModule == null) {
                webModule = this.getWebModule(config, moduleName);
                this.cachedWebModules.put(moduleName, webModule);
            }
            if (!this.isEnabled(event.getConfigContext(), moduleName)) {
                return;
            }
            String location = webModule.getLocation();
            File moduleBase = new File(location);
            String modulesRoot = this.webContainer.getModulesRoot();
            if (!moduleBase.isAbsolute()) {
                location = modulesRoot + File.separator + location;
                webModule.setLocation(location);
            }
            WebModuleConfig wmInfo = this.loadWebModuleConfig(webModule);
            this.webContainer.enableWebModule(wmInfo, "null");
        }
    }

    public synchronized void moduleDisabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            String virtualServers;
            String contextRoot;
            String appName;
            block7: {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
                }
                ConfigContext config = event.getConfigContext();
                String moduleName = event.getModuleName();
                WebModule webModule = (WebModule)this.cachedWebModules.get(moduleName);
                if (webModule == null) {
                    webModule = this.getWebModule(config, moduleName);
                }
                appName = null;
                try {
                    Application app = this.getWebModulesManager().getDescriptor(webModule.getName(), webModule.getLocation());
                    WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
                    appName = app.getRegistrationName();
                }
                catch (ConfigException ce) {
                    throw new AdminEventListenerException(ce);
                }
                contextRoot = webModule.getContextRoot();
                virtualServers = null;
                try {
                    virtualServers = ServerBeansFactory.getVirtualServersByAppName(config, moduleName);
                }
                catch (ConfigException ce) {
                    if (!_logger.isLoggable(Level.FINEST)) break block7;
                    _logger.log(Level.FINEST, "Exception getting virtual servers by app name " + moduleName, ce);
                }
            }
            this.webContainer.disableWebModule(contextRoot, appName, virtualServers);
        }
    }

    private WebModule getWebModule(ConfigContext config, String moduleName) throws AdminEventListenerException {
        WebModule webModule = null;
        try {
            webModule = (WebModule)ApplicationHelper.findApplication(config, moduleName);
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce);
        }
        if (webModule == null) {
            String msg = localStrings.getString("webmodule.module_not_found", moduleName);
            throw new AdminEventListenerException(msg);
        }
        return webModule;
    }

    public void moduleReferenceAdded(ModuleDeployEvent event) throws AdminEventListenerException {
    }

    public void moduleReferenceRemoved(ModuleDeployEvent event) throws AdminEventListenerException {
    }

    private boolean isEnabled(ConfigContext config, String moduleName) {
        try {
            ConfigBean app = ApplicationHelper.findApplication(config, moduleName);
            Server server = ServerBeansFactory.getServerBean(config);
            ApplicationRef appRef = server.getApplicationRefByRef(moduleName);
            return app != null && app.isEnabled() && appRef != null && appRef.isEnabled();
        }
        catch (ConfigException e) {
            AdminEventListenerException ex = new AdminEventListenerException();
            ex.initCause(e);
            _logger.log(Level.FINE, "Error in finding " + moduleName, e);
            return false;
        }
    }

    private WebModulesManager getWebModulesManager() throws ConfigException {
        if (this.webModulesManager == null) {
            this.webModulesManager = new WebModulesManager(ApplicationServer.getServerContext().getInstanceEnvironment());
        }
        return this.webModulesManager;
    }
}

