/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ConnectorService;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.DASResourcesUtil;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.server.ResourceDeployerFactory;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;

public class ResourcesUtil {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    static int NO_OF_ALL_CONNECTOR_RESOURCE_TYPE = 4;
    static int NO_OF_CONNECTOR_RESOURCE_TYPE = 3;
    static int NO_OF_JDBC_RESOURCE_TYPE = 2;
    private static ServerContext sc_ = null;
    private static Resources res = null;
    private static Domain dom = null;
    private static ConfigContext configContext_ = null;
    private static ResourcesUtil instance_ = null;
    private ConnectorConnectionPool[] standAloneRarConnectorConnectionPools = null;
    private ConnectorConnectionPool[] embeddedRarConnectorConnectionPools = null;
    private boolean filteredConnectorConnectionPool = false;
    private ConnectorResource[] standAloneRarConnectorResources = null;
    private ConnectorResource[] embeddedRarConnectorResources = null;
    private boolean filteredConnectorResources = false;
    private AdminObjectResource[] standAloneRarAdminObjectResources = null;
    private AdminObjectResource[] embeddedRarAdminObjectResources = null;
    private boolean filteredAdminObjectResources = false;
    private static Applications apps = null;
    private static ConnectorModule[] connectorModules = null;
    private static J2eeApplication[] j2eeApps = null;
    private boolean reinitConfigContext = true;
    private static final String JNDI_METHOD = "getJndiName";
    private static final String NAME_METHOD = "getName";

    public static ResourcesUtil getInstance(ServerContext sc) throws ConfigException {
        if (instance_ == null) {
            sc_ = sc;
            configContext_ = sc.getConfigContext();
            dom = ServerBeansFactory.getDomainBean(configContext_);
            res = dom.getResources();
            apps = dom.getApplications();
            connectorModules = apps.getConnectorModule();
            j2eeApps = apps.getJ2eeApplication();
            if (ResourcesUtil.isDAS()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Creating DASResourcesUtil. We are in DAS");
                }
                instance_ = new DASResourcesUtil();
            } else {
                instance_ = new ResourcesUtil();
            }
        }
        return instance_;
    }

    public static ResourcesUtil getInstance() {
        return instance_;
    }

    protected ResourcesUtil() {
    }

    public ConfigBean[][] getConnectorResources() throws ConfigException {
        ConfigBean[][] configBeanArray = new ConfigBean[NO_OF_ALL_CONNECTOR_RESOURCE_TYPE][];
        ConfigBean[] ccp = res.getConnectorConnectionPool();
        configBeanArray[0] = this.getReferencedBeans(ccp, NAME_METHOD);
        ConnectorResource[] cr = res.getConnectorResource();
        configBeanArray[1] = this.getReferencedConnectorResourceBeans(cr, JNDI_METHOD);
        ConfigBean[] ar = res.getAdminObjectResource();
        configBeanArray[2] = this.getReferencedBeans(ar, JNDI_METHOD);
        ConfigBean[] rac = res.getResourceAdapterConfig();
        configBeanArray[3] = this.getReferencedBeans(rac, NAME_METHOD);
        return configBeanArray;
    }

    public ConfigBean[][] getConnectorResources(boolean onlystandAloneRars) throws ConfigException {
        ConfigBean[][] configBeanArray = new ConfigBean[NO_OF_CONNECTOR_RESOURCE_TYPE][];
        configBeanArray[0] = this.getFilteredConnectorConnectionPools(onlystandAloneRars);
        configBeanArray[1] = this.getFilteredConnectorResources(onlystandAloneRars);
        configBeanArray[2] = this.getFilteredAdminObjectResources(onlystandAloneRars);
        return configBeanArray;
    }

    public ConfigBean[][] getStandAloneNonSystemRarConnectorResources() throws ConfigException {
        boolean onlystandAloneRars = true;
        ConfigBean[][] configBeanArray = new ConfigBean[NO_OF_CONNECTOR_RESOURCE_TYPE][];
        ConfigBean[] ccp = this.getFilteredConnectorConnectionPools(onlystandAloneRars);
        configBeanArray[0] = this.getNonSystemRarPools(ccp);
        ConfigBean[] connectorResource = this.getFilteredConnectorResources(onlystandAloneRars);
        configBeanArray[1] = this.getNonSystemRarResources(configBeanArray[0], connectorResource);
        ConfigBean[] adminObjectRes = this.getFilteredAdminObjectResources(onlystandAloneRars);
        configBeanArray[2] = this.getNonSystemRarAdminObjects(adminObjectRes);
        return configBeanArray;
    }

    private ConfigBean[] getNonSystemRarPools(ConfigBean[] ccp) {
        if (ccp == null || ccp.length == 0) {
            return null;
        }
        int noOfPools = 0;
        String rarName = null;
        Vector<Integer> indexes = new Vector<Integer>();
        for (int i = 0; i < ccp.length; ++i) {
            rarName = ((ConnectorConnectionPool)ccp[i]).getResourceAdapterName();
            if (rarName == null || this.belongToSystemRar(rarName)) continue;
            ++noOfPools;
            indexes.add(new Integer(i));
        }
        ConfigBean[] configBeanArray = null;
        if (noOfPools != 0) {
            configBeanArray = new ConfigBean[noOfPools];
        }
        int location = 0;
        for (int i = 0; i < indexes.size(); ++i) {
            location = (Integer)indexes.elementAt(i);
            configBeanArray[i] = ccp[location];
        }
        return configBeanArray;
    }

    private ConfigBean[] getNonSystemRarAdminObjects(ConfigBean[] adminObjectRes) {
        if (adminObjectRes == null || adminObjectRes.length == 0) {
            return null;
        }
        int noOfRes = 0;
        String rarName = null;
        Vector<Integer> indexes = new Vector<Integer>();
        for (int i = 0; i < adminObjectRes.length; ++i) {
            rarName = ((AdminObjectResource)adminObjectRes[i]).getResAdapter();
            if (rarName == null || this.belongToSystemRar(rarName)) continue;
            ++noOfRes;
            indexes.add(new Integer(i));
        }
        ConfigBean[] configBeanArray = null;
        if (noOfRes != 0) {
            configBeanArray = new ConfigBean[noOfRes];
        }
        int location = 0;
        for (int i = 0; i < indexes.size(); ++i) {
            location = (Integer)indexes.elementAt(i);
            configBeanArray[i] = adminObjectRes[location];
        }
        return configBeanArray;
    }

    private ConfigBean[] getNonSystemRarResources(ConfigBean[] ccp, ConfigBean[] connectorResource) {
        if (ccp == null || ccp.length == 0 || connectorResource == null || connectorResource.length == 0) {
            return null;
        }
        int noOfRes = 0;
        String poolName = null;
        String connectionPoolName = null;
        Vector<Integer> indexes = new Vector<Integer>();
        for (int i = 0; i < connectorResource.length; ++i) {
            poolName = ((ConnectorResource)connectorResource[i]).getPoolName();
            for (int j = 0; poolName != null && j < ccp.length; ++j) {
                connectionPoolName = ((ConnectorConnectionPool)ccp[j]).getName();
                if (!poolName.equals(connectionPoolName)) continue;
                ++noOfRes;
                indexes.add(new Integer(i));
            }
        }
        ConfigBean[] configBeanArray = null;
        if (noOfRes != 0) {
            configBeanArray = new ConfigBean[noOfRes];
        }
        int location = 0;
        for (int i = 0; i < indexes.size(); ++i) {
            location = (Integer)indexes.elementAt(i);
            configBeanArray[i] = connectorResource[location];
        }
        return configBeanArray;
    }

    public ConfigBean[] getResourceAdapterConfigs() throws ConfigException {
        this.reinitialize();
        ConfigBean[] raConfigBeans = res.getResourceAdapterConfig();
        return raConfigBeans;
    }

    public ConfigBean[] getResourceAdapterConfigs(String rarName) throws ConfigException {
        this.reinitialize();
        ResourceAdapterConfig[] raConfigBeans = res.getResourceAdapterConfig();
        if (raConfigBeans == null) {
            return null;
        }
        Vector<ResourceAdapterConfig> tmpVector = new Vector<ResourceAdapterConfig>();
        for (int i = 0; raConfigBeans != null && i < raConfigBeans.length; ++i) {
            if (!raConfigBeans[i].getResourceAdapterName().equals(rarName)) continue;
            tmpVector.add(raConfigBeans[i]);
        }
        return this.convertToConfigBeans(tmpVector);
    }

    public ConfigBean[] getEmbeddedRarResourceAdapterConfigs(String appName) throws ConfigException {
        this.reinitialize();
        Applications apps = dom.getApplications();
        J2eeApplication j2eeApp = apps.getJ2eeApplicationByName(appName);
        if (j2eeApp == null || !j2eeApp.isEnabled()) {
            return null;
        }
        ResourceAdapterConfig[] raConfigBeans = res.getResourceAdapterConfig();
        if (raConfigBeans == null) {
            return null;
        }
        String appNameToken = null;
        Vector<ResourceAdapterConfig> tmpVector = new Vector<ResourceAdapterConfig>();
        for (int i = 0; i < raConfigBeans.length; ++i) {
            appNameToken = this.getAppNameToken(raConfigBeans[i].getResourceAdapterName());
            if (appNameToken == null || !appName.equals(appNameToken)) continue;
            tmpVector.add(raConfigBeans[i]);
        }
        return this.convertToConfigBeans(tmpVector);
    }

    private String getAppNameToken(String rarName) {
        if (rarName == null) {
            return null;
        }
        int index = rarName.indexOf("#");
        if (index != -1) {
            return rarName.substring(0, index);
        }
        return null;
    }

    public ConfigBean[][] getConnectorResources(String rarName) throws ConfigException {
        ConfigBean[][] configBeanArray = new ConfigBean[NO_OF_CONNECTOR_RESOURCE_TYPE][];
        configBeanArray[0] = this.getEnabledConnectorConnectionPools(rarName);
        configBeanArray[1] = this.getEnabledConnectorResources(rarName);
        configBeanArray[2] = this.getEnabledAdminObjectResources(rarName);
        return configBeanArray;
    }

    public ConfigBean[][] getAllConnectorResources(String rarName) throws ConfigException {
        ConfigBean[][] configBeanArray = new ConfigBean[NO_OF_ALL_CONNECTOR_RESOURCE_TYPE][];
        configBeanArray[0] = this.getEnabledConnectorConnectionPools(rarName);
        configBeanArray[1] = this.getEnabledConnectorResources(rarName);
        configBeanArray[2] = this.getEnabledAdminObjectResources(rarName);
        configBeanArray[3] = this.getResourceAdapterConfigs(rarName);
        return configBeanArray;
    }

    public void setConfigContext(ConfigContext ctx) {
        configContext_ = ctx;
    }

    public ConfigContext getConfigContext() {
        return configContext_;
    }

    public void setReinitConfigContext(boolean reinitConfigContext) {
        this.reinitConfigContext = reinitConfigContext;
    }

    public boolean isReinitConfigContext() {
        return this.reinitConfigContext;
    }

    public void reinitialize() {
        try {
            if (this.reinitConfigContext) {
                configContext_ = ApplicationServer.getServerContext().getConfigContext();
            }
            dom = ServerBeansFactory.getDomainBean(configContext_);
            res = dom.getResources();
            apps = dom.getApplications();
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public boolean poolBelongsToSystemRar(String poolName) {
        DeferredResourceConfig poolConfig = this.getDeferredConnectorPoolConfigs(poolName);
        if (poolConfig != null && this.belongToSystemRar(poolConfig.getRarName())) {
            return true;
        }
        poolConfig = this.getDeferredJdbcPoolConfigs(poolName);
        if (poolConfig != null) {
            return this.belongToSystemRar(poolConfig.getRarName());
        }
        return false;
    }

    public boolean resourceBelongsToSystemRar(String resourceName) {
        DeferredResourceConfig resourceConfig = this.getDeferredConnectorResourceConfigs(resourceName);
        if (resourceConfig != null && this.belongToSystemRar(resourceConfig.getRarName())) {
            return true;
        }
        resourceConfig = this.getDeferredJdbcResourceConfigs(resourceName);
        if (resourceConfig != null) {
            return this.belongToSystemRar(resourceConfig.getRarName());
        }
        return false;
    }

    public boolean adminObjectBelongsToSystemRar(String adminObject) {
        DeferredResourceConfig adminObjectConfig = this.getDeferredAdminObjectConfigs(adminObject);
        if (adminObjectConfig != null) {
            return this.belongToSystemRar(adminObjectConfig.getRarName());
        }
        return false;
    }

    protected DeferredResourceConfig getDeferredConnectorResourceConfigs(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ConfigBean[] resourcesToload = new ConfigBean[2];
        this.reinitialize();
        try {
            if (!this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, e.getMessage());
            _logger.log(Level.FINE, "Error while finding resource references ", e);
        }
        ConnectorResource connectorResource = res.getConnectorResourceByJndiName(resourceName);
        if (connectorResource == null || !connectorResource.isEnabled()) {
            return null;
        }
        String poolName = connectorResource.getPoolName();
        ConnectorConnectionPool ccPool = res.getConnectorConnectionPoolByName(poolName);
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = ccPool;
            resourcesToload[1] = connectorResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{res.getResourceAdapterConfigByResourceAdapterName(rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, connectorResource, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredConnectorPoolConfigs(String poolName) {
        ConfigBean[] resourcesToload = new ConfigBean[1];
        if (poolName == null) {
            return null;
        }
        this.reinitialize();
        ConnectorConnectionPool ccPool = res.getConnectorConnectionPoolByName(poolName);
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = ccPool;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{res.getResourceAdapterConfigByResourceAdapterName(rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredAdminObjectConfigs(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ConfigBean[] resourcesToload = new ConfigBean[1];
        this.reinitialize();
        try {
            if (!this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, e.getMessage());
            _logger.log(Level.FINE, "Error while finding resource references ", e);
        }
        AdminObjectResource adminObjectResource = res.getAdminObjectResourceByJndiName(resourceName);
        if (adminObjectResource == null || !adminObjectResource.isEnabled()) {
            return null;
        }
        String rarName = adminObjectResource.getResAdapter();
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = adminObjectResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{res.getResourceAdapterConfigByResourceAdapterName(rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, adminObjectResource, null, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredJdbcResourceConfigs(String resourceName) {
        String cmpResourceName;
        ConfigBean[] resourcesToload = new ConfigBean[2];
        if (resourceName == null) {
            return null;
        }
        this.reinitialize();
        try {
            if (!resourceName.endsWith("__pm") && !this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, e.getMessage());
            _logger.log(Level.FINE, "Error while finding resource references ", e);
        }
        JdbcResource jdbcResource = res.getJdbcResourceByJndiName(resourceName);
        if (!(jdbcResource != null && jdbcResource.isEnabled() || (jdbcResource = res.getJdbcResourceByJndiName(cmpResourceName = this.getCorrespondingCmpResourceName(resourceName))) != null)) {
            return null;
        }
        JdbcConnectionPool jdbcPool = res.getJdbcConnectionPoolByName(jdbcResource.getPoolName());
        if (jdbcPool == null) {
            return null;
        }
        String rarName = this.getRAForJdbcConnectionPool(jdbcPool);
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = jdbcPool;
            resourcesToload[1] = jdbcResource;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, jdbcResource, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredJdbcPoolConfigs(String poolName) {
        ConfigBean[] resourcesToload = new ConfigBean[1];
        if (poolName == null) {
            return null;
        }
        this.reinitialize();
        JdbcConnectionPool jdbcPool = res.getJdbcConnectionPoolByName(poolName);
        if (jdbcPool == null) {
            return null;
        }
        String rarName = this.getRAForJdbcConnectionPool(jdbcPool);
        if (rarName != null && this.belongToSystemRar(rarName)) {
            resourcesToload[0] = jdbcPool;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, null, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    public DeferredResourceConfig getDeferredResourceConfig(String resourceName) {
        DeferredResourceConfig resConfig = this.getDeferredConnectorResourceConfigs(resourceName);
        if (resConfig != null) {
            return resConfig;
        }
        resConfig = this.getDeferredJdbcResourceConfigs(resourceName);
        if (resConfig != null) {
            return resConfig;
        }
        resConfig = this.getDeferredAdminObjectConfigs(resourceName);
        if (resConfig != null) {
            return resConfig;
        }
        return null;
    }

    public DeferredResourceConfig getDeferredPoolConfig(String poolName) {
        DeferredResourceConfig resConfig = this.getDeferredConnectorPoolConfigs(poolName);
        if (resConfig != null) {
            return resConfig;
        }
        if (poolName == null) {
            return null;
        }
        resConfig = this.getDeferredJdbcPoolConfigs(poolName);
        if (resConfig != null) {
            return resConfig;
        }
        return null;
    }

    protected String getCorrespondingCmpResourceName(String resourceName) {
        int index = resourceName.lastIndexOf("__pm");
        if (index != -1) {
            return resourceName.substring(0, index);
        }
        return null;
    }

    private ConfigBean[] getEnabledConnectorConnectionPools(String rarName) throws ConfigException {
        this.reinitialize();
        ConnectorConnectionPool[] connectorConnectionPools = res.getConnectorConnectionPool();
        int size = connectorConnectionPools.length;
        if (size == 0) {
            return null;
        }
        Vector<ConnectorConnectionPool> tmpVector = new Vector<ConnectorConnectionPool>();
        for (int i = 0; connectorConnectionPools != null && i < connectorConnectionPools.length; ++i) {
            if (!connectorConnectionPools[i].getResourceAdapterName().equals(rarName) || !this.isEnabled(connectorConnectionPools[i])) continue;
            tmpVector.add(connectorConnectionPools[i]);
        }
        return this.convertToConfigBeans(tmpVector);
    }

    private ConfigBean[] getEnabledConnectorResources(String rarName) throws ConfigException {
        this.reinitialize();
        ConnectorResource[] connectorResources = res.getConnectorResource();
        int size = connectorResources.length;
        if (size == 0) {
            return null;
        }
        Vector<ConnectorResource> tmpVector = new Vector<ConnectorResource>();
        for (int i = 0; connectorResources != null && i < connectorResources.length; ++i) {
            if (!this.belongToRar(rarName, connectorResources[i]) || !this.isEnabled(connectorResources[i]) || !this.isReferenced(connectorResources[i].getJndiName())) continue;
            tmpVector.add(connectorResources[i]);
        }
        return this.convertToConfigBeans(tmpVector);
    }

    private ConfigBean[] getEnabledAdminObjectResources(String rarName) throws ConfigException {
        this.reinitialize();
        AdminObjectResource[] aor = res.getAdminObjectResource();
        int size = aor.length;
        if (size == 0) {
            return null;
        }
        Vector<AdminObjectResource> tmpVector = new Vector<AdminObjectResource>();
        for (int i = 0; aor != null && i < aor.length; ++i) {
            if (!this.belongToRar(rarName, aor[i]) || !this.isEnabled(aor[i]) || !this.isReferenced(aor[i].getJndiName())) continue;
            tmpVector.add(aor[i]);
        }
        return this.convertToConfigBeans(tmpVector);
    }

    private ConfigBean[] convertToConfigBeans(Vector vector) {
        int size = vector.size();
        if (size == 0) {
            return null;
        }
        ConfigBean[] retConfigBeans = new ConfigBean[size];
        for (int i = 0; i < size; ++i) {
            retConfigBeans[i] = (ConfigBean)vector.get(i);
        }
        return retConfigBeans;
    }

    private ConfigBean[] getFilteredAdminObjectResources(boolean onlystandAloneRars) throws ConfigException {
        int i;
        if (this.filteredAdminObjectResources) {
            if (onlystandAloneRars) {
                return this.standAloneRarAdminObjectResources;
            }
            return this.embeddedRarAdminObjectResources;
        }
        this.filteredAdminObjectResources = true;
        int noOfAdminObjectResources = res.sizeAdminObjectResource();
        if (noOfAdminObjectResources == 0) {
            return null;
        }
        Vector<AdminObjectResource> standAloneRarAdminObjectResourcesVector = new Vector<AdminObjectResource>();
        Vector<AdminObjectResource> embeddedRarAdminObjectResourcesVector = new Vector<AdminObjectResource>();
        for (i = 0; i < noOfAdminObjectResources; ++i) {
            AdminObjectResource adminObjectResource = res.getAdminObjectResource(i);
            if (adminObjectResource == null || !this.isEnabled(adminObjectResource) || !this.isReferenced(adminObjectResource.getJndiName())) continue;
            String resourceAdapterName = adminObjectResource.getResAdapter();
            if (this.belongToStandAloneRarAdminObjectResources(resourceAdapterName) || this.belongToSystemRar(resourceAdapterName)) {
                standAloneRarAdminObjectResourcesVector.add(adminObjectResource);
                continue;
            }
            if (this.belongToEmbeddedRarAdminObjectResources(resourceAdapterName)) {
                embeddedRarAdminObjectResourcesVector.add(adminObjectResource);
                continue;
            }
            _logger.log(Level.WARNING, "loading.wrong_adminobject_entry", resourceAdapterName);
        }
        if (standAloneRarAdminObjectResourcesVector.size() != 0) {
            this.standAloneRarAdminObjectResources = new AdminObjectResource[standAloneRarAdminObjectResourcesVector.size()];
            for (i = 0; i < standAloneRarAdminObjectResourcesVector.size(); ++i) {
                this.standAloneRarAdminObjectResources[i] = (AdminObjectResource)standAloneRarAdminObjectResourcesVector.elementAt(i);
            }
        }
        if (embeddedRarAdminObjectResourcesVector.size() != 0) {
            this.embeddedRarAdminObjectResources = new AdminObjectResource[embeddedRarAdminObjectResourcesVector.size()];
            for (i = 0; i < embeddedRarAdminObjectResourcesVector.size(); ++i) {
                this.embeddedRarAdminObjectResources[i] = (AdminObjectResource)embeddedRarAdminObjectResourcesVector.elementAt(i);
            }
        }
        if (onlystandAloneRars) {
            return this.standAloneRarAdminObjectResources;
        }
        return this.embeddedRarAdminObjectResources;
    }

    private ConfigBean[] getFilteredConnectorResources(boolean onlystandAloneRars) throws ConfigException {
        int i;
        if (this.filteredConnectorResources) {
            if (onlystandAloneRars) {
                return this.standAloneRarConnectorResources;
            }
            return this.embeddedRarConnectorResources;
        }
        this.filteredConnectorResources = true;
        int noOfConnectorResources = res.sizeConnectorResource();
        if (noOfConnectorResources == 0) {
            return null;
        }
        Vector<ConnectorResource> standAloneRarConnectorResourcesVector = new Vector<ConnectorResource>();
        Vector<ConnectorResource> embeddedRarConnectorResourcesVector = new Vector<ConnectorResource>();
        for (i = 0; i < noOfConnectorResources; ++i) {
            ConnectorResource ccResource = res.getConnectorResource(i);
            if (ccResource == null || !this.isEnabled(ccResource) || !this.isReferenced(ccResource.getJndiName())) continue;
            String poolName = ccResource.getPoolName();
            if (this.belongToStandAloneRarConnectorResources(poolName)) {
                standAloneRarConnectorResourcesVector.add(ccResource);
                continue;
            }
            if (this.belongToEmbeddedRarConnectorResources(poolName)) {
                embeddedRarConnectorResourcesVector.add(ccResource);
                continue;
            }
            _logger.log(Level.WARNING, "loading.wrong_resources_entry", poolName);
        }
        if (standAloneRarConnectorResourcesVector.size() != 0) {
            this.standAloneRarConnectorResources = new ConnectorResource[standAloneRarConnectorResourcesVector.size()];
            for (i = 0; i < standAloneRarConnectorResourcesVector.size(); ++i) {
                this.standAloneRarConnectorResources[i] = (ConnectorResource)standAloneRarConnectorResourcesVector.elementAt(i);
            }
        }
        if (embeddedRarConnectorResourcesVector.size() != 0) {
            this.embeddedRarConnectorResources = new ConnectorResource[embeddedRarConnectorResourcesVector.size()];
            for (i = 0; i < embeddedRarConnectorResourcesVector.size(); ++i) {
                this.embeddedRarConnectorResources[i] = (ConnectorResource)embeddedRarConnectorResourcesVector.elementAt(i);
            }
        }
        if (onlystandAloneRars) {
            return this.standAloneRarConnectorResources;
        }
        return this.embeddedRarConnectorResources;
    }

    private ConfigBean[] getFilteredConnectorConnectionPools(boolean onlystandAloneRars) throws ConfigException {
        int i;
        if (this.filteredConnectorConnectionPool) {
            if (onlystandAloneRars) {
                return this.standAloneRarConnectorConnectionPools;
            }
            return this.embeddedRarConnectorConnectionPools;
        }
        this.filteredConnectorConnectionPool = true;
        int noOfConnectorConnectionPools = res.sizeConnectorConnectionPool();
        if (noOfConnectorConnectionPools == 0) {
            return null;
        }
        Vector<ConnectorConnectionPool> standAloneRarPoolsVector = new Vector<ConnectorConnectionPool>();
        Vector<ConnectorConnectionPool> embeddedRarPoolsVector = new Vector<ConnectorConnectionPool>();
        for (i = 0; i < noOfConnectorConnectionPools; ++i) {
            ConnectorConnectionPool ccPool = res.getConnectorConnectionPool(i);
            if (ccPool == null || !this.isEnabled(ccPool)) continue;
            String resourceAdapterName = ccPool.getResourceAdapterName();
            if (this.belongToStandAloneRarConnectionPools(resourceAdapterName) || this.belongToSystemRar(resourceAdapterName)) {
                standAloneRarPoolsVector.add(ccPool);
                continue;
            }
            if (this.belongToEmbeddedRarConnectionPools(resourceAdapterName)) {
                embeddedRarPoolsVector.add(ccPool);
                continue;
            }
            _logger.log(Level.WARNING, "loading.wrong_connectorpool_entry", resourceAdapterName);
        }
        if (standAloneRarPoolsVector.size() != 0) {
            this.standAloneRarConnectorConnectionPools = new ConnectorConnectionPool[standAloneRarPoolsVector.size()];
            for (i = 0; i < standAloneRarPoolsVector.size(); ++i) {
                this.standAloneRarConnectorConnectionPools[i] = (ConnectorConnectionPool)standAloneRarPoolsVector.elementAt(i);
            }
        }
        if (embeddedRarPoolsVector.size() != 0) {
            this.embeddedRarConnectorConnectionPools = new ConnectorConnectionPool[embeddedRarPoolsVector.size()];
            for (i = 0; i < embeddedRarPoolsVector.size(); ++i) {
                this.embeddedRarConnectorConnectionPools[i] = (ConnectorConnectionPool)embeddedRarPoolsVector.elementAt(i);
            }
        }
        if (onlystandAloneRars) {
            return this.standAloneRarConnectorConnectionPools;
        }
        return this.embeddedRarConnectorConnectionPools;
    }

    private boolean belongToStandAloneRarAdminObjectResources(String resourceAdapterName) {
        if (connectorModules == null || connectorModules.length == 0) {
            return false;
        }
        for (int i = 0; i < connectorModules.length; ++i) {
            if (!resourceAdapterName.equals(connectorModules[i].getName())) continue;
            return true;
        }
        return false;
    }

    private boolean belongToEmbeddedRarAdminObjectResources(String resourceAdapterName) {
        if (j2eeApps == null || j2eeApps.length == 0) {
            return false;
        }
        for (int i = 0; i < j2eeApps.length; ++i) {
            String appName;
            int index = resourceAdapterName.indexOf("#");
            if (index == -1 || !(appName = resourceAdapterName.substring(0, index)).equals(j2eeApps[i].getName())) continue;
            return true;
        }
        return false;
    }

    private boolean belongToStandAloneRarConnectorResources(String poolName) {
        if (this.standAloneRarConnectorConnectionPools == null || this.standAloneRarConnectorConnectionPools.length == 0) {
            return false;
        }
        for (int i = 0; i < this.standAloneRarConnectorConnectionPools.length; ++i) {
            if (!poolName.equals(this.standAloneRarConnectorConnectionPools[i].getName())) continue;
            return true;
        }
        return false;
    }

    private boolean belongToEmbeddedRarConnectorResources(String poolName) {
        if (this.embeddedRarConnectorConnectionPools == null || this.embeddedRarConnectorConnectionPools.length == 0) {
            return false;
        }
        for (int i = 0; i < this.embeddedRarConnectorConnectionPools.length; ++i) {
            if (!poolName.equals(this.embeddedRarConnectorConnectionPools[i].getName())) continue;
            return true;
        }
        return false;
    }

    private boolean belongToStandAloneRarConnectionPools(String resourceAdapterName) {
        if (connectorModules == null || connectorModules.length == 0) {
            return false;
        }
        for (int i = 0; i < connectorModules.length; ++i) {
            if (!resourceAdapterName.equals(connectorModules[i].getName())) continue;
            return true;
        }
        return false;
    }

    public boolean belongToSystemRar(String resourceAdapterName) {
        for (int i = 0; i < ConnectorRuntime.systemRarNames.length; ++i) {
            if (!resourceAdapterName.equals(ConnectorRuntime.systemRarNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean belongToEmbeddedRarConnectionPools(String resourceAdapterName) {
        if (j2eeApps == null || j2eeApps.length == 0) {
            return false;
        }
        for (int i = 0; i < j2eeApps.length; ++i) {
            String appName;
            int index = resourceAdapterName.indexOf("#");
            if (index == -1 || !(appName = resourceAdapterName.substring(0, index)).equals(j2eeApps[i].getName())) continue;
            return true;
        }
        return false;
    }

    public Object[] getConnectorResourcesJndiNames(String poolName) {
        Vector<String> jndiNamesVector = new Vector<String>();
        this.reinitialize();
        ConnectorResource[] connectorResource = res.getConnectorResource();
        if (connectorResource == null || connectorResource.length == 0) {
            return null;
        }
        for (int i = 0; i < connectorResource.length; ++i) {
            if (!connectorResource[i].getPoolName().equals(poolName)) continue;
            jndiNamesVector.add(connectorResource[i].getJndiName());
        }
        return jndiNamesVector.toArray();
    }

    public Object[] getConnectorConnectionPoolNames(String moduleName) {
        this.reinitialize();
        Vector<String> poolNamesVector = new Vector<String>();
        ConnectorConnectionPool[] connectorConnectionPool = res.getConnectorConnectionPool();
        if (connectorConnectionPool == null || connectorConnectionPool.length == 0) {
            return null;
        }
        for (int i = 0; i < connectorConnectionPool.length; ++i) {
            if (!connectorConnectionPool[i].getResourceAdapterName().equals(moduleName)) continue;
            poolNamesVector.add(connectorConnectionPool[i].getName());
        }
        return poolNamesVector.toArray();
    }

    public ConnectorConnectionPool[] getConnectorConnectionPools() {
        this.reinitialize();
        ConnectorConnectionPool[] connectorConnectionPool = null;
        connectorConnectionPool = res.getConnectorConnectionPool();
        if (connectorConnectionPool.length == 0) {
            return null;
        }
        return connectorConnectionPool;
    }

    public JdbcConnectionPool[] getJdbcConnectionPools() {
        this.reinitialize();
        JdbcConnectionPool[] jdbcConnectionPool = res.getJdbcConnectionPool();
        if (jdbcConnectionPool == null) {
            return null;
        }
        if (jdbcConnectionPool.length == 0) {
            return null;
        }
        return jdbcConnectionPool;
    }

    public String[] getdbUserPasswordOfJdbcConnectionPool(JdbcConnectionPool jdbcConnectionPool) {
        String[] userPassword = new String[]{null, null};
        ElementProperty[] elementProperty = jdbcConnectionPool.getElementProperty();
        if (elementProperty == null || elementProperty.length == 0) {
            return userPassword;
        }
        for (int i = 0; i < elementProperty.length; ++i) {
            if (elementProperty[i].getName().equals("User")) {
                userPassword[0] = elementProperty[i].getValue();
            }
            if (!elementProperty[i].getName().equals("Password")) continue;
            userPassword[1] = elementProperty[i].getValue();
        }
        return userPassword;
    }

    public String[] getdbUserPasswordOfConnectorConnectionPool(ConnectorConnectionPool connectorConnectionPool) {
        String[] userPassword = new String[]{null, null};
        ElementProperty[] elementProperty = connectorConnectionPool.getElementProperty();
        if (elementProperty != null && elementProperty.length != 0) {
            boolean foundUserPassword = false;
            for (int i = 0; i < elementProperty.length; ++i) {
                String prop = elementProperty[i].getName().toUpperCase();
                if ("USERNAME".equals(prop) || "USER".equals(prop)) {
                    userPassword[0] = elementProperty[i].getValue();
                    foundUserPassword = true;
                    continue;
                }
                if (!"PASSWORD".equals(prop)) continue;
                userPassword[1] = elementProperty[i].getValue();
                foundUserPassword = true;
            }
            if (foundUserPassword) {
                return userPassword;
            }
        }
        String poolName = connectorConnectionPool.getName();
        String rarName = connectorConnectionPool.getResourceAdapterName();
        String connectionDefName = connectorConnectionPool.getConnectionDefinitionName();
        ConnectorRegistry connectorRegistry = ConnectorRegistry.getInstance();
        ConnectorDescriptor connectorDescriptor = connectorRegistry.getDescriptor(rarName);
        ConnectionDefDescriptor cdd = connectorDescriptor.getConnectionDefinitionByCFType(connectionDefName);
        Set configProps = cdd.getConfigProperties();
        Iterator iter = configProps.iterator();
        while (iter.hasNext()) {
            EnvironmentProperty envProp = (EnvironmentProperty)iter.next();
            String prop = envProp.getName().toUpperCase();
            if ("USER".equals(prop) || "USERNAME".equals(prop)) {
                userPassword[0] = envProp.getValue();
                continue;
            }
            if (!"PASSWORD".equals(prop)) continue;
            userPassword[1] = envProp.getValue();
        }
        if (userPassword[0] != null && !"".equals(userPassword[0].trim())) {
            return userPassword;
        }
        ManagedConnectionFactory mcf = connectorRegistry.getManagedConnectionFactory(poolName);
        userPassword[0] = ConnectionPoolObjectsUtils.getValueFromMCF("UserName", poolName, mcf);
        userPassword[1] = ConnectionPoolObjectsUtils.getValueFromMCF("Password", poolName, mcf);
        return userPassword;
    }

    public void deleteConnectorResources(String poolname) throws ConfigException {
        ConnectorResource[] connectorResource = res.getConnectorResource();
        if (connectorResource == null || connectorResource.length == 0) {
            return;
        }
        for (int i = 0; i < connectorResource.length; ++i) {
            if (!connectorResource[i].getPoolName().equals(poolname)) continue;
            res.removeConnectorResource(connectorResource[i]);
            configContext_.flush();
        }
    }

    public void deleteConnectorConnectionPool(String moduleName) throws ConfigException {
        ConnectorConnectionPool[] connectorConnectionPool = res.getConnectorConnectionPool();
        if (connectorConnectionPool == null || connectorConnectionPool.length == 0) {
            return;
        }
        for (int i = 0; i < connectorConnectionPool.length; ++i) {
            if (!connectorConnectionPool[i].getResourceAdapterName().equals(moduleName)) continue;
            res.removeConnectorConnectionPool(connectorConnectionPool[i]);
            configContext_.flush();
        }
    }

    public String getResourceType(ConfigBean cb) {
        if (cb instanceof ConnectorConnectionPool) {
            return "ccp";
        }
        if (cb instanceof ConnectorResource) {
            return "cr";
        }
        if (cb instanceof AdminObjectResource) {
            return "aor";
        }
        if (cb instanceof ResourceAdapterConfig) {
            return "rac";
        }
        if (cb instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (cb instanceof JdbcResource) {
            return "jdbc";
        }
        return null;
    }

    public ResourceDeployer getResourceDeployer(String type) throws Exception {
        ResourceDeployerFactory factory = new ResourceDeployerFactory();
        return factory.getResourceDeployer(type);
    }

    public void writeSunConnector(ConnectorDescriptor connectorDescriptor, String rarName, String poolName) throws ConfigException {
        configContext_ = sc_.getConfigContext();
        dom = ServerBeansFactory.getDomainBean(configContext_);
        res = dom.getResources();
        ConnectorConnectionPool connectorConnectionPool = this.getConnectionPoolObj(connectorDescriptor);
        connectorConnectionPool.setName(poolName);
        connectorConnectionPool.setResourceAdapterName(rarName);
        ConnectorConnectionPool existingPool = res.getConnectorConnectionPoolByName(poolName);
        if (existingPool != null) {
            res.removeConnectorConnectionPool(existingPool);
            configContext_.flush();
        }
        res.addConnectorConnectionPool(connectorConnectionPool);
        configContext_.flush();
        String jndiName = (String)connectorDescriptor.getSunDescriptor().getResourceAdapter().getValue("JndiName");
        ConnectorResource connectorResource = this.getConnectorResource(poolName, jndiName);
        ConnectorResource existingConnectorResource = res.getConnectorResourceByJndiName(jndiName);
        if (existingConnectorResource != null) {
            res.removeConnectorResource(existingConnectorResource);
            configContext_.flush();
        }
        res.addConnectorResource(connectorResource);
        configContext_.flush();
    }

    private ConnectorResource getConnectorResource(String poolName, String jndiName) {
        ConnectorResource connectorResource = new ConnectorResource();
        connectorResource.setJndiName(jndiName);
        connectorResource.setPoolName(poolName);
        return connectorResource;
    }

    private ConnectorConnectionPool getConnectionPoolObj(ConnectorDescriptor connectorDescriptor) {
        String connectiondefName = connectorDescriptor.getOutboundResourceAdapter().getConnectionFactoryIntf();
        SunConnector sunConnector = connectorDescriptor.getSunDescriptor();
        ResourceAdapter sunRAXML = sunConnector.getResourceAdapter();
        ConnectorConnectionPool connectorConnectionPool = new ConnectorConnectionPool();
        connectorConnectionPool.setConnectionDefinitionName(connectiondefName);
        connectorConnectionPool.setSteadyPoolSize((String)sunRAXML.getValue("SteadyPoolSize"));
        connectorConnectionPool.setMaxPoolSize((String)sunRAXML.getValue("MaxPoolSize"));
        connectorConnectionPool.setMaxWaitTimeInMillis((String)sunRAXML.getValue("MaxWaitTimeInMillis"));
        connectorConnectionPool.setPoolResizeQuantity("2");
        connectorConnectionPool.setIdleTimeoutInSeconds((String)sunRAXML.getValue("IdleTimeoutInSeconds"));
        connectorConnectionPool.setFailAllConnections(false);
        return connectorConnectionPool;
    }

    public String getLocation(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        this.reinitialize();
        String location = null;
        ConnectorModule connectorModule = dom.getApplications().getConnectorModuleByName(moduleName);
        if (connectorModule != null) {
            location = connectorModule.getLocation();
        }
        return location;
    }

    public ConfigBean[][] getJdbcResources() throws ConfigException {
        ConfigBean[][] configBeanArray = new ConfigBean[NO_OF_JDBC_RESOURCE_TYPE][];
        ConfigBean[] jcp = res.getJdbcConnectionPool();
        configBeanArray[0] = this.getReferencedBeans(jcp, NAME_METHOD);
        JdbcResource[] jr = res.getJdbcResource();
        configBeanArray[1] = this.getReferencedJdbcResourceBeans(jr, JNDI_METHOD);
        return configBeanArray;
    }

    protected boolean isReferenced(String resourceName) throws ConfigException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("isReferenced :: " + resourceName + " - " + ServerHelper.serverReferencesResource(configContext_, sc_.getInstanceName(), resourceName));
        }
        return ServerHelper.serverReferencesResource(configContext_, sc_.getInstanceName(), resourceName);
    }

    private ConfigBean[] getReferencedBeans(ConfigBean[] beans, String methodName) {
        ArrayList<ConfigBean> list = new ArrayList<ConfigBean>();
        for (int i = 0; i < beans.length; ++i) {
            try {
                String name = null;
                if (methodName != null) {
                    Class<?> c = beans[i].getClass();
                    Method m = c.getDeclaredMethod(methodName, null);
                    name = (String)m.invoke((Object)beans[i], null);
                }
                if (!this.isReferenced(name)) continue;
                list.add(beans[i]);
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "isReferenced.unexpectedException", e);
            }
        }
        ConfigBean[] refList = new ConfigBean[list.size()];
        return list.toArray(refList);
    }

    public boolean isEnabled(ConnectorResource cr) throws ConfigException {
        this.reinitialize();
        if (cr == null) {
            return false;
        }
        _logger.fine("ResourcesUtil ::  isEnabled " + cr);
        boolean resRef = this.isReferenced(cr.getJndiName());
        _logger.fine("ResourcesUtil :: is Referenced" + resRef);
        boolean isResRefEnabled = this.isResourceReferenceEnabled(cr.getJndiName());
        _logger.fine("isResRefEnabled " + isResRefEnabled);
        if (!(cr.isEnabled() && resRef && isResRefEnabled)) {
            return false;
        }
        String poolName = cr.getPoolName();
        ConnectorConnectionPool ccp = res.getConnectorConnectionPoolByName(poolName);
        if (ccp == null) {
            return false;
        }
        String raName = ccp.getResourceAdapterName();
        ConnectorModule module = dom.getApplications().getConnectorModuleByName(raName);
        if (module != null) {
            return module.isEnabled();
        }
        if (this.belongToSystemRar(raName)) {
            return true;
        }
        return this.belongToEmbeddedRarAndEnabled(raName);
    }

    public boolean isEnabled(AdminObjectResource aot) throws ConfigException {
        this.reinitialize();
        if (aot == null) {
            return false;
        }
        boolean resRef = this.isReferenced(aot.getJndiName());
        boolean isResRefEnabled = this.isResourceReferenceEnabled(aot.getJndiName());
        if (!(aot.isEnabled() && resRef && isResRefEnabled)) {
            return false;
        }
        String raName = aot.getResAdapter();
        ConnectorModule module = dom.getApplications().getConnectorModuleByName(raName);
        if (module != null) {
            return module.isEnabled();
        }
        if (this.belongToSystemRar(raName)) {
            return true;
        }
        return this.belongToEmbeddedRarAndEnabled(raName);
    }

    public boolean isEnabled(ConnectorConnectionPool ccp) {
        if (ccp == null) {
            return false;
        }
        this.reinitialize();
        String raName = ccp.getResourceAdapterName();
        ConnectorModule module = dom.getApplications().getConnectorModuleByName(raName);
        if (module != null) {
            return module.isEnabled();
        }
        if (this.belongToSystemRar(raName)) {
            return true;
        }
        return this.belongToEmbeddedRarAndEnabled(raName);
    }

    public boolean belongToRar(String rarName, ConnectorConnectionPool ccp) {
        if (ccp == null || rarName == null) {
            return false;
        }
        return ccp.getResourceAdapterName().equals(rarName);
    }

    public boolean belongToRar(String rarName, ConnectorResource cr) {
        if (cr == null || rarName == null) {
            return false;
        }
        this.reinitialize();
        String poolName = cr.getPoolName();
        ConnectorConnectionPool ccp = res.getConnectorConnectionPoolByName(poolName);
        if (ccp == null) {
            return false;
        }
        return ccp.getResourceAdapterName().equals(rarName);
    }

    public boolean belongToRar(String rarName, AdminObjectResource aor) {
        if (aor == null || rarName == null) {
            return false;
        }
        return aor.getResAdapter().equals(rarName);
    }

    private boolean belongToEmbeddedRarAndEnabled(String resourceAdapterName) {
        this.reinitialize();
        Applications apps = dom.getApplications();
        J2eeApplication[] j2eeApps = apps.getJ2eeApplication();
        if (j2eeApps == null || j2eeApps.length == 0) {
            return false;
        }
        for (int i = 0; i < j2eeApps.length; ++i) {
            String appName;
            int index = resourceAdapterName.indexOf("#");
            if (index == -1 || !(appName = resourceAdapterName.substring(0, index)).equals(j2eeApps[i].getName()) || !j2eeApps[i].isEnabled()) continue;
            return true;
        }
        return false;
    }

    public String[] listConnectorModuleNames() {
        this.reinitialize();
        Applications apps = dom.getApplications();
        ConnectorModule[] connectorModules = null;
        String[] connectorModuleNames = null;
        if (apps != null) {
            connectorModules = apps.getConnectorModule();
        }
        if (connectorModules != null) {
            connectorModuleNames = new String[connectorModules.length];
            for (int i = 0; connectorModules != null && i < connectorModules.length; ++i) {
                connectorModuleNames[i] = connectorModules[i].getName();
            }
        }
        return connectorModuleNames;
    }

    public boolean belongToEmbeddedRar(String resourceAdapterName) {
        this.reinitialize();
        J2eeApplication[] j2eeApps = null;
        j2eeApps = apps.getJ2eeApplication();
        if (j2eeApps == null || j2eeApps.length == 0) {
            return false;
        }
        for (int i = 0; i < j2eeApps.length; ++i) {
            String appName;
            int index = resourceAdapterName.indexOf("#");
            if (index == -1 || !(appName = resourceAdapterName.substring(0, index)).equals(j2eeApps[i].getName())) continue;
            return true;
        }
        return false;
    }

    public String getRAForJdbcConnectionPool(JdbcConnectionPool pool) {
        Class dsClass;
        String dsRAName = ConnectorConstants.JDBCDATASOURCE_RA_NAME;
        if (pool.getResType() == null) {
            return dsRAName;
        }
        if ("javax.sql.XADataSource".equals(pool.getResType())) {
            if (pool.getDatasourceClassname() == null) {
                return dsRAName;
            }
            try {
                dsClass = Utility.loadClass(pool.getDatasourceClassname());
                if (XADataSource.class.isAssignableFrom(dsClass)) {
                    return ConnectorConstants.JDBCXA_RA_NAME;
                }
            }
            catch (ClassNotFoundException cnfe) {
                return dsRAName;
            }
        }
        if ("javax.sql.ConnectionPoolDataSource".equals(pool.getResType())) {
            if (pool.getDatasourceClassname() == null) {
                return dsRAName;
            }
            try {
                dsClass = Utility.loadClass(pool.getDatasourceClassname());
                if (ConnectionPoolDataSource.class.isAssignableFrom(dsClass)) {
                    return ConnectorConstants.JDBCCONNECTIONPOOLDATASOURCE_RA_NAME;
                }
            }
            catch (ClassNotFoundException cnfe) {
                return dsRAName;
            }
        }
        return dsRAName;
    }

    public ConnectorResource[] getAllJmsResources() {
        this.reinitialize();
        ConnectorResource[] cr = res.getConnectorResource();
        Vector<ConnectorResource> vector = new Vector<ConnectorResource>();
        for (int i = 0; cr != null && i < cr.length; ++i) {
            if (!this.belongToRar(ConnectorConstants.DEFAULT_JMS_ADAPTER, cr[i])) continue;
            vector.add(cr[i]);
        }
        return (ConnectorResource[])vector.toArray();
    }

    public int getShutdownTimeout() throws ConnectorRuntimeException {
        try {
            ConnectorService connectorServiceElement = ServerBeansFactory.getConnectorServiceBean(ApplicationServer.getServerContext().getConfigContext());
            if (connectorServiceElement == null) {
                int shutdownTimeout = 30;
                _logger.log(Level.FINE, "Shutdown timeout set to " + shutdownTimeout + "through default");
                return shutdownTimeout;
            }
            int shutdownTimeout = new Integer(connectorServiceElement.getShutdownTimeoutInSeconds());
            _logger.log(Level.FINE, "Shutdown timeout set to " + shutdownTimeout + " from domain.xml");
            return shutdownTimeout;
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            crex.initCause(e);
            throw crex;
        }
    }

    private ConfigBean[] getReferencedJdbcResourceBeans(JdbcResource[] beans, String methodName) {
        ArrayList<JdbcResource> list = new ArrayList<JdbcResource>();
        for (int i = 0; i < beans.length; ++i) {
            try {
                String name = null;
                if (methodName != null) {
                    Class<?> c = beans[i].getClass();
                    Method m = c.getDeclaredMethod(methodName, null);
                    name = (String)m.invoke((Object)beans[i], null);
                }
                if (!this.isReferenced(name)) continue;
                list.add(beans[i]);
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "isReferenced.unexpectedException", e);
            }
        }
        JdbcResource[] refList = new JdbcResource[list.size()];
        return list.toArray(refList);
    }

    private ConfigBean[] getReferencedConnectorResourceBeans(ConnectorResource[] beans, String methodName) {
        ArrayList<ConnectorResource> list = new ArrayList<ConnectorResource>();
        for (int i = 0; i < beans.length; ++i) {
            try {
                String name = null;
                if (methodName != null) {
                    Class<?> c = beans[i].getClass();
                    Method m = c.getDeclaredMethod(methodName, null);
                    name = (String)m.invoke((Object)beans[i], null);
                }
                if (!this.isReferenced(name)) continue;
                list.add(beans[i]);
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "isReferenced.unexpectedException", e);
            }
        }
        ConnectorResource[] refList = new ConnectorResource[list.size()];
        return list.toArray(refList);
    }

    public static boolean isDAS() {
        try {
            return ServerHelper.isDAS(AdminService.getAdminService().getAdminContext().getAdminConfigContext(), sc_.getInstanceName());
        }
        catch (ConfigException ce) {
            return false;
        }
    }

    public boolean isPoolReferredInServerInstance(String poolName) throws ConfigException {
        this.reinitialize();
        ConnectorResource[] connRes = res.getConnectorResource();
        for (int i = 0; i < connRes.length; ++i) {
            _logger.fine("poolname " + connRes[i].getPoolName() + "resource " + connRes[i].getJndiName());
            if (!connRes[i].getPoolName().equalsIgnoreCase(poolName)) continue;
            _logger.fine("Connector resource " + connRes[i].getJndiName() + "refers " + poolName + "in this server instance");
            return true;
        }
        _logger.fine("No JDBC resource refers " + poolName + "in this server instance");
        return false;
    }

    public boolean isJdbcPoolReferredInServerInstance(String jdbcPoolName) throws ConfigException {
        this.reinitialize();
        JdbcResource[] jdbcRes = res.getJdbcResource();
        for (int i = 0; i < jdbcRes.length; ++i) {
            _logger.fine("poolname " + jdbcRes[i].getPoolName() + "resource " + jdbcRes[i].getJndiName() + " referred " + this.isReferenced(jdbcRes[i].getJndiName()));
            if (!jdbcRes[i].getPoolName().equalsIgnoreCase(jdbcPoolName) || !this.isReferenced(jdbcRes[i].getJndiName())) continue;
            _logger.fine("JDBC resource " + jdbcRes[i].getJndiName() + "refers " + jdbcPoolName + "in this server instance");
            return true;
        }
        _logger.fine("No JDBC resource refers " + jdbcPoolName + "in this server instance");
        return false;
    }

    public String getApplicationDeployLocation(String appName) {
        this.reinitialize();
        J2eeApplication app = dom.getApplications().getJ2eeApplicationByName(appName);
        return RelativePathResolver.resolvePath(app.getLocation());
    }

    protected Resources getResourcesServerBean() {
        return res;
    }

    private boolean isResourceReferenceEnabled(String resourceName) throws ConfigException {
        ResourceRef ref = ServerHelper.getServerByName(configContext_, sc_.getInstanceName()).getResourceRefByRef(resourceName);
        if (ref == null) {
            _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null ref");
            return true;
        }
        _logger.fine("ResourcesUtil :: isResourceReferenceEnabled ref enabled ?" + ref.isEnabled());
        return ref.isEnabled();
    }

    public boolean isEnabled(ConfigBean res) throws ConfigException {
        return this.isEnabled(ApplicationServer.getServerContext().getConfigContext(), res);
    }

    public boolean isEnabled(ConfigContext config, ConfigBean res) throws ConfigException {
        _logger.fine("ResourcesUtil :: isEnabled");
        if (res instanceof ResourceAdapterConfig || res instanceof ConnectorConnectionPool || res instanceof JdbcConnectionPool) {
            boolean enabled = res != null && res.isEnabled();
            _logger.fine("ResourcesUtil :: isEnabled " + res + " is pool/config - enabled :" + enabled);
            return enabled;
        }
        Server server = ServerBeansFactory.getServerBean(config);
        ResourceRef resRef = server.getResourceRefByRef(res.getAttributeValue(ServerTags.JNDI_NAME));
        boolean enabled = res != null && res.isEnabled() && resRef != null && resRef.isEnabled();
        _logger.fine("ResourcesUtil :: isEnabled " + res + " is resource - enabled :" + enabled);
        return enabled;
    }

    public JdbcConnectionPool getJdbcConnectionPoolByName(String poolName) {
        this.reinitialize();
        return res.getJdbcConnectionPoolByName(poolName);
    }

    public ConnectorConnectionPool getConnectorConnectionPoolByName(String poolName) {
        this.reinitialize();
        return res.getConnectorConnectionPoolByName(poolName);
    }
}

