/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanException;

public class ApplicationLoader
extends AbstractLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private boolean isForceDeploy = false;

    public ApplicationLoader(String appID, ClassLoader parentClassLoader, AppsManager appsManager) {
        super(appID, parentClassLoader, appsManager);
        String[] classPath = EJBClassPathUtils.getEjbClasspath(appID, appsManager);
        this.initializeLoader(classPath);
        try {
            this.application = appsManager.getAppDescriptor(appID, this.ejbClassLoader);
            EJBClassLoader loader = (EJBClassLoader)this.ejbClassLoader;
            String appRoot = appsManager.getLocation(appID);
            Iterator modules = this.application.getModules();
            while (modules.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)modules.next();
                if (!md.getModuleType().equals(ModuleType.WAR)) continue;
                List warClassPath = EJBClassPathUtils.getWarClassPath(appRoot, md);
                Iterator i = warClassPath.iterator();
                while (i.hasNext()) {
                    String next = (String)i.next();
                    loader.appendURL(new File(next).toURL());
                }
            }
        }
        catch (Exception confEx) {
            _logger.log(Level.SEVERE, "loader.error_while_loading_app_desc", confEx);
        }
    }

    boolean load(boolean jsr77) {
        this.notifyAppEvent(0);
        boolean allModulesDeployed = this.loadRars(jsr77);
        if (allModulesDeployed) {
            allModulesDeployed = this.loadEjbs(jsr77);
            this.notifyAppEvent(1);
        }
        return allModulesDeployed;
    }

    boolean unload(boolean jsr77) {
        this.notifyAppEvent(2);
        boolean ejbUnloaded = this.unloadEjbs(jsr77);
        boolean rarUnloaded = this.unloadRars(jsr77);
        this.configManager.unregisterDescriptor(this.id);
        this.notifyAppEvent(3);
        this.done();
        return ejbUnloaded && rarUnloaded;
    }

    void createRootMBean() throws MBeanException {
        try {
            Switch.getSwitch().getManagementObjectManager().createAppMBean(this.application, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
            Switch.getSwitch().getManagementObjectManager().createAppMBeanModules(this.application, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    void deleteRootMBean() throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().deleteAppMBean(this.application, this.configManager.getInstanceEnvironment().getName());
    }

    void createLeafMBeans() throws MBeanException {
        try {
            Switch.getSwitch().getManagementObjectManager().createAppMBeans(this.application, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    void createLeafMBean(Descriptor descriptor) throws MBeanException {
        if (descriptor instanceof EjbDescriptor) {
            EjbDescriptor ejbDescriptor = null;
            try {
                ejbDescriptor = (EjbDescriptor)descriptor;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
            Switch.getSwitch().getManagementObjectManager().createEJBMBean(ejbDescriptor, this.configManager.getInstanceEnvironment().getName());
        } else if (descriptor instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd = null;
            try {
                cd = (ConnectorDescriptor)descriptor;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
            Switch.getSwitch().getManagementObjectManager().createRARMBean(cd, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void deleteLeafMBean(Descriptor descriptor) throws MBeanException {
        if (descriptor instanceof EjbDescriptor) {
            EjbDescriptor ejbDescriptor = null;
            try {
                ejbDescriptor = (EjbDescriptor)descriptor;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
            Switch.getSwitch().getManagementObjectManager().deleteEJBMBean(ejbDescriptor, this.configManager.getInstanceEnvironment().getName());
        } else if (descriptor instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd = null;
            try {
                cd = (ConnectorDescriptor)descriptor;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
            Switch.getSwitch().getManagementObjectManager().deleteRARMBean(cd, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void deleteLeafMBeans() throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().deleteAppMBeans(this.application, this.configManager.getInstanceEnvironment().getName());
    }

    void deleteLeafAndRootMBeans() throws MBeanException {
        this.deleteLeafMBeans();
        this.deleteRootMBean();
    }

    void setState(int state) throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().setApplicationState(state, this.application, this.configManager.getInstanceEnvironment().getName());
    }

    public boolean isForceDeploy() {
        return this.isForceDeploy;
    }

    public void setForceDeploy(boolean isForceDeploy) {
        this.isForceDeploy = isForceDeploy;
    }
}

