/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.security.Audit;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.factory.FactoryForSecurityManagerFactory;
import com.sun.enterprise.security.factory.FactoryForSecurityManagerFactoryImpl;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.enterprise.server.ApplicationRegistry;
import com.sun.enterprise.server.event.ApplicationEvent;
import com.sun.enterprise.server.event.ApplicationLoaderEventNotifier;
import com.sun.enterprise.server.event.EjbContainerEvent;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.naming.NameAlreadyBoundException;

abstract class AbstractLoader {
    protected String id = null;
    ClassLoader parentClassLoader = null;
    ClassLoader ejbClassLoader = null;
    Application application = null;
    private URL[] classPathURLs = new URL[0];
    protected boolean robFlag = false;
    protected ApplicationRegistry registry = null;
    protected BaseManager configManager = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private FactoryForSecurityManagerFactory ffsmf = null;
    protected boolean cascade = false;
    private ApplicationLoaderEventNotifier loaderEventNotifier;
    private ConfigContext dynamicConfigContext;

    AbstractLoader(String id, ClassLoader parentClassLoader, BaseManager configMgr) {
        this.id = id;
        this.parentClassLoader = parentClassLoader;
        this.registry = ApplicationRegistry.getInstance();
        this.configManager = configMgr;
        this.loaderEventNotifier = ApplicationLoaderEventNotifier.getInstance();
    }

    private EJBClassLoader createEJBClassLoader(String[] classPaths) {
        if (classPaths != null) {
            int classPathSize = classPaths.length;
            this.classPathURLs = new URL[classPathSize];
            for (int i = 0; i < classPathSize; ++i) {
                try {
                    this.classPathURLs[i] = new File(classPaths[i]).toURL();
                    continue;
                }
                catch (MalformedURLException malEx) {
                    _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", classPaths[i]);
                    _logger.log(Level.WARNING, "loader.exception", malEx);
                }
            }
        }
        return this.createEJBClassLoader(this.classPathURLs);
    }

    private EJBClassLoader createEJBClassLoader(URL[] URLs) {
        EJBClassLoader loader = new EJBClassLoader(this.parentClassLoader);
        if (URLs != null) {
            for (int i = 0; i < URLs.length; ++i) {
                loader.appendURL(URLs[i]);
            }
        }
        return loader;
    }

    protected void initializeLoader(String[] classPaths) {
        this.ejbClassLoader = this.createEJBClassLoader(classPaths);
    }

    void setConfigContext(ConfigContext dynamicConfigContext) {
        this.dynamicConfigContext = dynamicConfigContext;
    }

    abstract boolean load(boolean var1);

    abstract boolean unload(boolean var1);

    abstract void createRootMBean() throws MBeanException;

    abstract void deleteRootMBean() throws MBeanException;

    abstract void createLeafMBeans() throws MBeanException;

    abstract void deleteLeafMBeans() throws MBeanException;

    abstract void createLeafMBean(Descriptor var1) throws MBeanException;

    abstract void deleteLeafMBean(Descriptor var1) throws MBeanException;

    abstract void deleteLeafAndRootMBeans() throws MBeanException;

    abstract void setState(int var1) throws MBeanException;

    ClassLoader getClassLoader() {
        return this.ejbClassLoader;
    }

    Application getApplication() {
        return this.application;
    }

    protected void done() {
        if (this.ejbClassLoader instanceof EJBClassLoader) {
            ((EJBClassLoader)this.ejbClassLoader).done();
        }
        this.id = null;
        this.parentClassLoader = null;
        this.application = null;
        this.ejbClassLoader = null;
        this.classPathURLs = null;
        this.registry = null;
        this.configManager = null;
    }

    protected boolean unloadEjbs(boolean jsr77) {
        boolean result = true;
        if (this.application == null) {
            result = false;
        } else {
            Vector beanDescriptors = this.application.getEjbDescriptors();
            Enumeration e = beanDescriptors.elements();
            while (e.hasMoreElements()) {
                EjbDescriptor nextDescriptor = (EjbDescriptor)e.nextElement();
                this.notifyEjbEvent(22, nextDescriptor);
                this.registry.removeUniqueId(nextDescriptor.getUniqueId());
                try {
                    Container container = this.registry.removeDescriptor2Container(nextDescriptor);
                    if (container != null) {
                        container.undeploy();
                    }
                }
                catch (Exception beanEx) {
                    result = false;
                    _logger.log(Level.WARNING, "loader.unexpected_error_while_unloading_ejb_container", beanEx);
                }
                this.notifyEjbEvent(23, nextDescriptor);
                if (!jsr77) continue;
                try {
                    this.deleteLeafMBean(nextDescriptor);
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "loader.delete_ejb_mbean_exception", mbe);
                }
            }
            if (!this.application.isVirtual()) {
                this.registry.removeAppId2ClassLoader(this.id);
            } else {
                this.registry.removeModuleId2ClassLoader(this.id);
            }
            this.registry.removeClassLoader2Application(this.ejbClassLoader);
        }
        _logger.log(Level.FINE, "[AbstractLoader] Unload EJB(s) Status: " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadEjbs(boolean jsr77) {
        ClassLoader loader = this.ejbClassLoader;
        if (this.application == null) {
            return false;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "[AbstractLoader] Id: " + this.id + " Setting thread context class loader to: " + loader);
        }
        ClassLoader savedContextClassLoader = Utility.setContextClassLoader(loader);
        try {
            if (!this.application.isVirtual()) {
                this.registry.addAppId2ClassLoader(this.id, this.ejbClassLoader);
            } else {
                this.registry.addModuleId2ClassLoader(this.id, this.ejbClassLoader);
            }
            this.registry.addClassLoader2Application(this.ejbClassLoader, this.application);
            HashSet<Container> myContainers = new HashSet<Container>();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[AbstractLoader] Id: " + this.id + " Unique Id: " + this.application.getUniqueId());
            }
            Vector beanDescriptors = this.application.getEjbDescriptors();
            Enumeration e = beanDescriptors.elements();
            ContainerFactory cf = Switch.getSwitch().getContainerFactory();
            while (e.hasMoreElements()) {
                EjbDescriptor nextDescriptor = (EjbDescriptor)e.nextElement();
                if (!this.registry.isUnique(nextDescriptor.getUniqueId())) {
                    _logger.log(Level.SEVERE, "loader.duplicate_unique_id", new Object[]{String.valueOf(nextDescriptor.getUniqueId()), nextDescriptor.getName()});
                    this.unloadEjbs(jsr77);
                    boolean bl = false;
                    return bl;
                }
                if (this.ffsmf == null) {
                    this.ffsmf = FactoryForSecurityManagerFactoryImpl.getInstance();
                }
                SecurityManagerFactory smf = this.ffsmf.getSecurityManagerFactory("ejb");
                SecurityManager sm = smf.createSecurityManager(nextDescriptor);
                Container container = null;
                try {
                    this.notifyEjbEvent(20, nextDescriptor);
                    container = cf.createContainer(nextDescriptor, loader, sm, this.dynamicConfigContext);
                    this.notifyEjbEvent(21, nextDescriptor);
                }
                catch (NameAlreadyBoundException jndiEx) {
                    _logger.log(Level.SEVERE, "loader.jndi_name_conflict", new Object[]{this.id, nextDescriptor.getJndiName(), nextDescriptor.getName()});
                    _logger.log(Level.SEVERE, "loader.naming_exception_in_createcontainer", jndiEx);
                    this.unloadEjbs(jsr77);
                    boolean bl = false;
                    Utility.setContextClassLoader(savedContextClassLoader);
                    return bl;
                }
                try {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Created container with uinque id: " + nextDescriptor.getUniqueId());
                    }
                    this.registry.addDescriptor2Container(nextDescriptor, container);
                    myContainers.add(container);
                }
                catch (Exception beanEx) {
                    _logger.log(Level.SEVERE, "loader.unexpected_error_while_creating_ejb_container", beanEx);
                    this.unloadEjbs(jsr77);
                    boolean bl = false;
                    return bl;
                }
                if (!jsr77) continue;
                try {
                    this.createLeafMBean(nextDescriptor);
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "loader.create_ejb_mbean_exception", mbe);
                }
            }
            try {
                Enumeration en = beanDescriptors.elements();
                if (en.hasMoreElements()) {
                    SecurityUtil.generatePolicyFile(this.id);
                }
            }
            catch (Exception ge) {
                _logger.log(Level.SEVERE, "code.could_not_generate/load_the_policy_files_for_system_app", ge);
                this.unloadEjbs(jsr77);
                boolean mbe = false;
                Utility.setContextClassLoader(savedContextClassLoader);
                return mbe;
            }
            Iterator iter = myContainers.iterator();
            while (iter.hasNext()) {
                Container c = (Container)iter.next();
                c.doAfterApplicationDeploy();
            }
            Audit.showACL(this.application);
            if (this.application.getEjbComponentCount() > 0) {
                _logger.log(Level.INFO, "loader.ejbs_loaded", this.id);
            }
            _logger.log(Level.FINE, "[AbstractLoader] loadEjbs completed");
            boolean bl = true;
            return bl;
        }
        finally {
            Utility.setContextClassLoader(savedContextClassLoader);
        }
    }

    protected boolean unloadRars(boolean jsr77) {
        boolean result = true;
        try {
            Set rarsDescriptors = this.application.getRarDescriptors();
            ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
            Iterator itr = rarsDescriptors.iterator();
            while (itr.hasNext()) {
                ConnectorDescriptor cd = (ConnectorDescriptor)itr.next();
                String rarName = cd.getDeployName();
                String jndiName = this.id + "#" + FileUtils.makeFriendlyFilenameNoExtension(rarName);
                connectorRuntime.destroyActiveResourceAdapter(jndiName, this.cascade);
                if (!jsr77) continue;
                this.deleteLeafMBean(cd);
            }
        }
        catch (Exception rarEx) {
            result = false;
            _logger.log(Level.WARNING, "loader.application_loader_exception", rarEx);
        }
        _logger.log(Level.FINE, "[AbstractLoader] Unload RAR(s) Status: " + result);
        return result;
    }

    protected boolean loadRars(boolean jsr77) {
        try {
            String appLocation = this.configManager.getLocation(this.id);
            Set rars = this.application.getRarDescriptors();
            ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
            Iterator itr = rars.iterator();
            while (itr.hasNext()) {
                ConnectorDescriptor cd = (ConnectorDescriptor)itr.next();
                String rarName = cd.getDeployName();
                String location = appLocation + File.separator + FileUtils.makeFriendlyFilename(rarName);
                String jndiName = this.id + "#" + FileUtils.makeFriendlyFilenameNoExtension(rarName);
                connectorRuntime.createActiveResourceAdapter(cd, jndiName, location, this.cascade);
                if (!jsr77) continue;
                this.createLeafMBean(cd);
            }
        }
        catch (Exception rarEx) {
            _logger.log(Level.WARNING, "loader.application_loader_exception", rarEx);
        }
        _logger.log(Level.FINE, "[AbstractLoader] loadRars completed");
        return true;
    }

    protected void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    protected boolean getCascade() {
        return this.cascade;
    }

    protected void notifyAppEvent(int eventType) {
        ApplicationEvent event = new ApplicationEvent(eventType, this.getApplication(), this.getClassLoader());
        this.loaderEventNotifier.notifyListeners(event);
    }

    protected void notifyEjbEvent(int eventType, EjbDescriptor desc) {
        EjbContainerEvent event = new EjbContainerEvent(eventType, desc, this.getClassLoader());
        this.loaderEventNotifier.notifyListeners(event);
    }
}

