/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class AsadminTruststore {
    private static final String ASADMIN_TRUSTSTORE = ".asadmintruststore";
    private KeyStore _keyStore = null;
    private File _keyFile = null;
    private char[] _password = null;

    public static File getAsadminTruststore() {
        String location = System.getProperty("javax.net.ssl.trustStore");
        if (location == null) {
            return new File(System.getProperty("user.home") + File.separator + ASADMIN_TRUSTSTORE);
        }
        return new File(location);
    }

    public static String getAsadminTruststorePassword() {
        return System.getProperty("javax.net.ssl.trustStorePassword", "changeit");
    }

    public AsadminTruststore() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this(AsadminTruststore.getAsadminTruststorePassword());
    }

    public AsadminTruststore(String password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this.init(AsadminTruststore.getAsadminTruststore(), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(File keyfile, String password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this._keyFile = keyfile;
        this._keyStore = KeyStore.getInstance("JKS");
        this._password = password.toCharArray();
        BufferedInputStream bInput = null;
        if (this._keyFile.exists()) {
            bInput = new BufferedInputStream(new FileInputStream(this._keyFile));
        }
        try {
            this._keyStore.load(bInput, this._password);
            if (bInput != null) {
                bInput.close();
                return;
            }
            Object var5_4 = null;
            if (bInput == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bInput == null) throw throwable;
            try {
                bInput.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bInput.close();
            return;
        }
        catch (Exception ex) {}
    }

    public boolean certificateExists(Certificate cert) throws KeyStoreException {
        return this._keyStore.getCertificateAlias(cert) != null;
    }

    public void addCertificate(String alias, Certificate cert) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this._keyStore.setCertificateEntry(alias, cert);
        this.writeStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        BufferedOutputStream boutput = null;
        try {
            boutput = new BufferedOutputStream(new FileOutputStream(this._keyFile));
            this._keyStore.store(boutput, this._password);
            boutput.close();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (boutput == null) throw throwable;
            try {
                boutput.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

