/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import sun.net.www.ParseUtil;
import sun.security.provider.PolicyFile;
import sun.security.provider.PolicyParser;

public class PolicyConfigurationImpl
implements PolicyConfiguration {
    private static Logger logger;
    private static LocalStringManagerImpl localStrings;
    private String CONTEXT_ID = null;
    private Permissions excludedPermissions = null;
    private Permissions uncheckedPermissions = null;
    private HashMap rolePermissionsTable = null;
    private static HashMap linkTable;
    private static SecurityRoleMapperFactory factory;
    private static final String REPOSITORY_HOME_PROP = "com.sun.enterprise.jaccprovider.property.repository";
    private static String policySuffix;
    private static String PROVIDER_URL;
    private static final Class[] permissionParams;
    public static final int OPEN_STATE = 0;
    public static final int INSERVICE_STATE = 2;
    public static final int DELETED_STATE = 3;
    protected int state = 0;
    private boolean writeOnCommit = true;
    private boolean wasRefreshed = false;
    private Policy policy = null;
    private String policyUrlValue = null;
    private static Object refreshLock;
    private static String repository;
    private static Permission setPolicyPermission;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected PolicyConfigurationImpl(String contextId) {
        this.CONTEXT_ID = contextId;
        this.initialize(true, true, false);
    }

    protected PolicyConfigurationImpl(File applicationPolicyDirectory, boolean open, boolean remove) {
        this.CONTEXT_ID = applicationPolicyDirectory.getName();
        String name = this.getPolicyFileName(true);
        File f = new File(name);
        if (!f.exists()) {
            logger.log(Level.SEVERE, "pc.file_not_found", new Object[]{name});
            throw new RuntimeException("Unable to open Policy file: " + name);
        }
        this.initialize(open, remove, true);
    }

    public String getContextID() throws PolicyContextException {
        PolicyConfigurationImpl.checkSetPolicyPermission();
        return this.CONTEXT_ID;
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        this.assertStateIsOpen();
        if (!$assertionsDisabled && roleName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && permissions == null) {
            throw new AssertionError();
        }
        if (roleName != null && permissions != null) {
            PolicyConfigurationImpl.checkSetPolicyPermission();
            Enumeration<Permission> enumeration = permissions.elements();
            while (enumeration.hasMoreElements()) {
                this.getRolePermissions(roleName).add(enumeration.nextElement());
                this.writeOnCommit = true;
            }
        }
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        this.assertStateIsOpen();
        if (!$assertionsDisabled && permission == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && roleName == null) {
            throw new AssertionError();
        }
        if (roleName != null && permission != null) {
            PolicyConfigurationImpl.checkSetPolicyPermission();
            this.getRolePermissions(roleName).add(permission);
            this.writeOnCommit = true;
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        this.assertStateIsOpen();
        if (!$assertionsDisabled && permissions == null) {
            throw new AssertionError();
        }
        if (permissions != null) {
            PolicyConfigurationImpl.checkSetPolicyPermission();
            Enumeration<Permission> enumeration = permissions.elements();
            while (enumeration.hasMoreElements()) {
                this.getUncheckedPermissions().add(enumeration.nextElement());
                this.writeOnCommit = true;
            }
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        this.assertStateIsOpen();
        if (!$assertionsDisabled && permission == null) {
            throw new AssertionError();
        }
        if (permission != null) {
            PolicyConfigurationImpl.checkSetPolicyPermission();
            this.getUncheckedPermissions().add(permission);
            this.writeOnCommit = true;
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        this.assertStateIsOpen();
        if (!$assertionsDisabled && permissions == null) {
            throw new AssertionError();
        }
        if (permissions != null) {
            PolicyConfigurationImpl.checkSetPolicyPermission();
            Enumeration<Permission> enumeration = permissions.elements();
            while (enumeration.hasMoreElements()) {
                this.getExcludedPermissions().add(enumeration.nextElement());
                this.writeOnCommit = true;
            }
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        this.assertStateIsOpen();
        if (!$assertionsDisabled && permission == null) {
            throw new AssertionError();
        }
        if (permission != null) {
            PolicyConfigurationImpl.checkSetPolicyPermission();
            this.getExcludedPermissions().add(permission);
            this.writeOnCommit = true;
        }
    }

    public void removeRole(String roleName) throws PolicyContextException {
        this.assertStateIsOpen();
        if (!$assertionsDisabled && roleName == null) {
            throw new AssertionError();
        }
        if (roleName != null && this.rolePermissionsTable != null) {
            PolicyConfigurationImpl.checkSetPolicyPermission();
            if (this.rolePermissionsTable.remove(roleName) != null) {
                this.writeOnCommit = true;
            }
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        this.assertStateIsOpen();
        PolicyConfigurationImpl.checkSetPolicyPermission();
        if (this.uncheckedPermissions != null) {
            this.uncheckedPermissions = null;
            this.writeOnCommit = true;
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        this.assertStateIsOpen();
        PolicyConfigurationImpl.checkSetPolicyPermission();
        if (this.excludedPermissions != null) {
            this.excludedPermissions = null;
            this.writeOnCommit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws PolicyContextException {
        Object object = refreshLock;
        synchronized (object) {
            if (this.state == 3) {
                logger.log(Level.WARNING, "pc.invalid_op_for_state_delete");
                throw new UnsupportedOperationException("Cannot perform Operation on a deleted PolicyConfiguration.");
            }
            try {
                PolicyConfigurationImpl.checkSetPolicyPermission();
                if (this.state == 0) {
                    this.generatePermissions();
                    this.state = 2;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "pc.commit_failure", new Object[]{this.CONTEXT_ID, e});
                throw new PolicyContextException((Throwable)e);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: PC.commit " + this.CONTEXT_ID);
            }
        }
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        this.assertStateIsOpen();
        String linkId = link.getContextID();
        if (this.CONTEXT_ID == linkId) {
            logger.log(Level.WARNING, "pc.unsupported_link_operation");
            throw new IllegalArgumentException("Operation attempted to link PolicyConfiguration to itself.");
        }
        PolicyConfigurationImpl.checkSetPolicyPermission();
        this.updateLinkTable(linkId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws PolicyContextException {
        PolicyConfigurationImpl.checkSetPolicyPermission();
        Object object = refreshLock;
        synchronized (object) {
            try {
                this.removePolicy();
            }
            finally {
                this.state = 3;
            }
        }
    }

    public boolean inService() throws PolicyContextException {
        PolicyConfigurationImpl.checkSetPolicyPermission();
        return this.state == 2;
    }

    protected static void checkSetPolicyPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (setPolicyPermission == null) {
                setPolicyPermission = new SecurityPermission("setPolicy");
            }
            sm.checkPermission(setPolicyPermission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Policy getPolicy() {
        Object object = refreshLock;
        synchronized (object) {
            if (this.state == 2) {
                return this.policy;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("JACC Policy Provider: getPolicy (" + this.CONTEXT_ID + ") is NOT in service");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Permissions getExcludedPolicy() {
        Object object = refreshLock;
        synchronized (object) {
            return this.state == 2 ? this.excludedPermissions : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(boolean force) {
        Object object = refreshLock;
        synchronized (object) {
            if (this.state == 2 && (!this.wasRefreshed || force)) {
                int i = 0;
                String value = null;
                String urlKey = null;
                while ((value = Security.getProperty(urlKey = PROVIDER_URL + ++i)) != null && !value.equals("")) {
                }
                try {
                    Security.setProperty(urlKey, this.policyUrlValue);
                    this.excludedPermissions = this.loadExcludedPolicy();
                    if (this.policy == null) {
                        this.policy = new PolicyFile();
                    } else {
                        this.policy.refresh();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("JACC Policy Provider: Called Policy.refresh on contextId: " + this.CONTEXT_ID + " policyUrlValue was " + this.policyUrlValue);
                        }
                    }
                    this.wasRefreshed = true;
                }
                finally {
                    Security.setProperty(urlKey, "");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(boolean open, boolean remove, boolean fromFile) {
        Object object = refreshLock;
        synchronized (object) {
            String name = this.getPolicyFileName(true);
            this.state = open || remove ? 0 : 2;
            try {
                if (remove) {
                    this.removePolicy();
                }
                this.policyUrlValue = ParseUtil.fileToEncodedURL(new File(name)).toString();
                if (fromFile && !remove) {
                    this.excludedPermissions = this.loadExcludedPolicy();
                    this.writeOnCommit = false;
                }
                this.wasRefreshed = false;
            }
            catch (MalformedURLException mue) {
                logger.log(Level.SEVERE, "pc.file_to_url", new Object[]{name, mue});
                throw new RuntimeException("Unable to convert Policy file Name to URL: " + name);
            }
        }
    }

    private String getPolicyFileName(boolean granted) {
        return granted ? this.getContextDirectoryName() + File.separator + "granted" + policySuffix : this.getContextDirectoryName() + File.separator + "excluded" + policySuffix;
    }

    private String getContextDirectoryName() {
        if (repository == null) {
            throw new RuntimeException("JACC Policy provider: repository not initialized");
        }
        return PolicyConfigurationImpl.getContextDirectoryName(this.CONTEXT_ID);
    }

    protected static String getContextDirectoryName(String contextId) {
        if (repository == null) {
            throw new RuntimeException("JACC Policy provider: repository not initialized");
        }
        return repository + File.separator + contextId;
    }

    private void removePolicyContextDirectory() {
        String directoryName = this.getContextDirectoryName();
        File f = new File(directoryName);
        if (f.exists()) {
            File[] files = f.listFiles();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
            }
            if (!f.delete()) {
                logger.log(Level.SEVERE, "pc.file_delete_error", directoryName);
                throw new RuntimeException("Failure removing policy context directory: " + directoryName);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: Policy context directory removed: " + directoryName);
            }
        }
    }

    private void removePolicyFile(boolean granted) {
        String fileName = this.getPolicyFileName(granted);
        File f = new File(fileName);
        if (f.exists()) {
            if (!f.delete()) {
                logger.log(Level.SEVERE, "pc.file_delete_error", fileName);
                throw new RuntimeException("Failure removing policy file: " + fileName);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: Policy file removed: " + fileName);
            }
        }
    }

    private void removePolicy() {
        this.excludedPermissions = null;
        this.uncheckedPermissions = null;
        this.rolePermissionsTable = null;
        this.removePolicyFile(true);
        this.removePolicyFile(false);
        this.removePolicyContextDirectory();
        this.initLinkTable();
        this.policy = null;
        this.writeOnCommit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLinkTable() {
        Object object = refreshLock;
        synchronized (object) {
            HashSet<String> linkSet = (HashSet<String>)linkTable.get(this.CONTEXT_ID);
            if (linkSet != null) {
                linkSet.remove(this.CONTEXT_ID);
                linkTable.remove(this.CONTEXT_ID);
            }
            linkSet = new HashSet<String>();
            linkSet.add(this.CONTEXT_ID);
            linkTable.put(this.CONTEXT_ID, linkSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkTable(String otherId) {
        Object object = refreshLock;
        synchronized (object) {
            Set linkSet = (Set)linkTable.get(this.CONTEXT_ID);
            Set otherLinkSet = (Set)linkTable.get(otherId);
            if (otherLinkSet == null) {
                logger.log(Level.SEVERE, "pc.invalid_link_target", otherId);
                throw new RuntimeException("Linked policy configuration (" + otherId + ") does not exist");
            }
            Iterator it = otherLinkSet.iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                linkSet.add(id);
                linkTable.put(id, linkSet);
            }
        }
    }

    private void assertStateIsOpen() {
        if (this.state != 0) {
            logger.log(Level.WARNING, "pcfactory.op_requires_state_open");
            throw new UnsupportedOperationException("Operation invoked on closed or deleted PolicyConfiguration.");
        }
    }

    private static String initializeRepository() {
        try {
            repository = System.getProperty(REPOSITORY_HOME_PROP);
            if (repository == null) {
                logger.log(Level.SEVERE, "pc.no_repository");
            } else {
                File rf;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("JACC policy provider: repository set to: " + repository);
                }
                if ((rf = new File(repository)).exists()) {
                    if (!rf.isDirectory()) {
                        logger.log(Level.SEVERE, "pc.unable_to_create_repository", repository);
                    } else {
                        File[] contextsInService = rf.listFiles();
                        if (contextsInService != null) {
                            for (int i = 0; i < contextsInService.length; ++i) {
                                try {
                                    PolicyConfigurationImpl pc = new PolicyConfigurationImpl(contextsInService[i], false, false);
                                    PolicyConfigurationFactoryImpl.putPolicyConfigurationImpl(pc.CONTEXT_ID, pc);
                                    continue;
                                }
                                catch (Exception ex) {
                                    logger.log(Level.WARNING, "pc.unable_to_read_repostory", contextsInService[i].toString());
                                }
                            }
                        }
                    }
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("JACC Policy Provider: creating new policy repository");
                    }
                    rf.mkdir();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "pc.unable_to_init_repository", e);
            repository = null;
        }
        return repository;
    }

    private Permissions getUncheckedPermissions() {
        if (this.uncheckedPermissions == null) {
            this.uncheckedPermissions = new Permissions();
        }
        return this.uncheckedPermissions;
    }

    private Permissions getExcludedPermissions() {
        if (this.excludedPermissions == null) {
            this.excludedPermissions = new Permissions();
        }
        return this.excludedPermissions;
    }

    private Permissions getRolePermissions(String roleName) {
        Permissions rolePermissions;
        if (this.rolePermissionsTable == null) {
            this.rolePermissionsTable = new HashMap();
        }
        if ((rolePermissions = (Permissions)this.rolePermissionsTable.get(roleName)) == null) {
            rolePermissions = new Permissions();
            this.rolePermissionsTable.put(roleName, rolePermissions);
        }
        return rolePermissions;
    }

    private String escapeName(String name) {
        return name != null && name.indexOf(34) > 0 ? name.replaceAll("\"", "\\\\\"") : name;
    }

    private void generatePermissions() throws FileNotFoundException, IOException {
        Enumeration<Permission> pEnum;
        if (!this.writeOnCommit) {
            return;
        }
        Map roleToSubjectMap = null;
        if (this.rolePermissionsTable != null && factory != null) {
            Set linkSet;
            SecurityRoleMapper srm = factory.getRoleMapper(this.CONTEXT_ID);
            if (srm != null) {
                roleToSubjectMap = srm.getRoleToSubjectMapping();
            }
            if (roleToSubjectMap != null && (linkSet = (Set)linkTable.get(this.CONTEXT_ID)) != null) {
                Iterator it = linkSet.iterator();
                while (it.hasNext()) {
                    String contextId = (String)it.next();
                    if (this.CONTEXT_ID.equals(contextId)) continue;
                    SecurityRoleMapper otherSrm = factory.getRoleMapper(contextId);
                    Map otherRoleToSubjectMap = null;
                    if (otherSrm != null) {
                        otherRoleToSubjectMap = otherSrm.getRoleToSubjectMapping();
                    }
                    if (otherRoleToSubjectMap == roleToSubjectMap) continue;
                    logger.log(Level.SEVERE, "pc.linked_with_different_role_maps", new Object[]{this.CONTEXT_ID, contextId});
                    throw new RuntimeException("Linked policy contexts have different roleToSubjectMaps (" + this.CONTEXT_ID + ")<->(" + contextId + ")");
                }
            }
        }
        if (roleToSubjectMap == null && this.rolePermissionsTable != null) {
            logger.log(Level.SEVERE, "pc.role_map_not_defined_at_commit", new Object[]{this.CONTEXT_ID});
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.deployment.norolemapperfactorydefine", "This application has no role mapper factory defined"));
        }
        PolicyParser parser = new PolicyParser(false);
        if (this.uncheckedPermissions != null && (pEnum = this.uncheckedPermissions.elements()).hasMoreElements()) {
            PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
            while (pEnum.hasMoreElements()) {
                Permission p = pEnum.nextElement();
                PolicyParser.PermissionEntry entry = new PolicyParser.PermissionEntry(p.getClass().getName(), p.getName(), p.getActions());
                grant.add(entry);
            }
            parser.add(grant);
        }
        if (this.rolePermissionsTable != null) {
            Iterator roleIt = this.rolePermissionsTable.keySet().iterator();
            while (roleIt.hasNext()) {
                boolean withPrincipals = false;
                String roleName = (String)roleIt.next();
                Permissions rolePerms = this.getRolePermissions(roleName);
                Subject rolePrincipals = (Subject)roleToSubjectMap.get(roleName);
                if (rolePrincipals != null) {
                    Iterator<Principal> pit = rolePrincipals.getPrincipals().iterator();
                    while (pit.hasNext()) {
                        Principal prin = pit.next();
                        if (!$assertionsDisabled && !(prin instanceof Principal)) {
                            throw new AssertionError();
                        }
                        if (prin instanceof Principal) {
                            withPrincipals = true;
                            PolicyParser.PrincipalEntry prinEntry = new PolicyParser.PrincipalEntry(prin.getClass().getName(), this.escapeName(prin.getName()));
                            PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
                            grant.principals.add(prinEntry);
                            Enumeration<Permission> pEnum2 = rolePerms.elements();
                            while (pEnum2.hasMoreElements()) {
                                Permission perm = pEnum2.nextElement();
                                PolicyParser.PermissionEntry permEntry = new PolicyParser.PermissionEntry(perm.getClass().getName(), perm.getName(), perm.getActions());
                                grant.add(permEntry);
                            }
                            parser.add(grant);
                            continue;
                        }
                        logger.log(Level.WARNING, "pc.non_principal_mapped_to_role", new Object[]{prin, roleName});
                    }
                }
                if (withPrincipals) continue;
                logger.log(Level.WARNING, "pc.no_principals_mapped_to_role", new Object[]{roleName});
            }
        }
        this.writeOnCommit = this.createPolicyFile(true, parser, this.writeOnCommit);
        if (this.excludedPermissions != null) {
            PolicyParser excludedParser = new PolicyParser(false);
            Enumeration<Permission> pEnum3 = this.excludedPermissions.elements();
            if (pEnum3.hasMoreElements()) {
                PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
                while (pEnum3.hasMoreElements()) {
                    Permission p = pEnum3.nextElement();
                    PolicyParser.PermissionEntry entry = new PolicyParser.PermissionEntry(p.getClass().getName(), p.getName(), p.getActions());
                    grant.add(entry);
                }
                excludedParser.add(grant);
            }
            this.writeOnCommit = this.createPolicyFile(false, excludedParser, this.writeOnCommit);
        }
        if (!this.writeOnCommit) {
            this.wasRefreshed = false;
        }
    }

    private void createPolicyContextDirectory() {
        String contextDirectoryName = this.getContextDirectoryName();
        File d = new File(contextDirectoryName);
        if (d.exists()) {
            if (!d.isDirectory()) {
                logger.log(Level.SEVERE, "pc.unable_to_create_context_directory", new Object[]{contextDirectoryName});
                throw new RuntimeException("unable to create policy context directory");
            }
        } else {
            d.mkdir();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createPolicyFile(boolean granted, PolicyParser parser, boolean woc) throws IOException {
        boolean result = woc;
        this.createPolicyContextDirectory();
        this.removePolicyFile(granted);
        String name = this.getPolicyFileName(granted);
        FileWriter writer = null;
        try {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("JACC Policy Provider: Writing grant statements to policy file: " + name);
                }
                writer = new FileWriter(name);
                parser.write(writer);
                result = false;
            }
            catch (FileNotFoundException fnfe) {
                logger.log(Level.SEVERE, "pc.file_error", new Object[]{name, fnfe});
                throw fnfe;
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "pc.file_write_error", new Object[]{name, ioe});
                throw ioe;
            }
            Object var9_7 = null;
            if (writer == null) return result;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "pc.file_close_error", new Object[]{name, e});
                throw new RuntimeException("Unable to close Policy file: " + name);
            }
        }
        try {}
        catch (Exception e) {
            logger.log(Level.SEVERE, "pc.file_close_error", new Object[]{name, e});
            throw new RuntimeException("Unable to close Policy file: " + name);
        }
        writer.close();
        return result;
    }

    private Permission loadPermission(String className, String name, String actions) {
        Class<?> clazz = null;
        Permission permission = null;
        try {
            clazz = Class.forName(className);
            Constructor<?> c = clazz.getConstructor(permissionParams);
            permission = (Permission)c.newInstance(name, actions);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "pc.permission_load_error", new Object[]{className, e});
            throw new RuntimeException("PolicyConfiguration error loading permission", e);
        }
        return permission;
    }

    /*
     * Unable to fully structure code
     */
    private Permissions loadExcludedPolicy() {
        block18: {
            result = null;
            name = this.getPolicyFileName(false);
            reader = null;
            parser = new PolicyParser(false);
            try {
                reader = new FileReader(name);
                parser.read(reader);
                var7_5 = null;
                ** if (reader == null) goto lbl-1000
            }
            catch (Throwable var6_15) {
                var7_6 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        PolicyConfigurationImpl.logger.log(Level.SEVERE, "pc.file_close_error", new Object[]{name, e});
                        throw new RuntimeException("Unable to close Policy file: " + name);
                    }
                }
                throw var6_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    PolicyConfigurationImpl.logger.log(Level.SEVERE, "pc.file_close_error", new Object[]{name, e});
                    throw new RuntimeException("Unable to close Policy file: " + name);
                }
            }
lbl-1000:
            // 1 sources

            {
                break block18;
                catch (FileNotFoundException fnf) {
                    parser = null;
                    var7_5 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            PolicyConfigurationImpl.logger.log(Level.SEVERE, "pc.file_close_error", new Object[]{name, e});
                            throw new RuntimeException("Unable to close Policy file: " + name);
                        }
                    }
                    break block18;
                }
                catch (IOException ioe) {
                    PolicyConfigurationImpl.logger.log(Level.SEVERE, "pc.file_read_error", new Object[]{name, ioe});
                    throw new RuntimeException("Error reading Policy file: " + name);
                }
                catch (PolicyParser.ParsingException pe) {
                    PolicyConfigurationImpl.logger.log(Level.SEVERE, "pc.policy_parsing_exception", new Object[]{name, pe});
                    throw new RuntimeException("Unable to parse Policy file: " + name);
                }
            }
        }
        if (parser != null) {
            grants = parser.grantElements();
            while (grants.hasMoreElements()) {
                grant = grants.nextElement();
                if (grant.codeBase != null || grant.signedBy != null || grant.principals.size() != 0) {
                    PolicyConfigurationImpl.logger.log(Level.WARNING, "pc.excluded_grant_context_ignored", new Object[]{grant});
                    continue;
                }
                perms = grant.permissionEntries.elements();
                while (perms.hasMoreElements()) {
                    entry = perms.nextElement();
                    p = this.loadPermission(entry.permission, entry.name, entry.action);
                    if (result == null) {
                        result = new Permissions();
                    }
                    result.add(p);
                }
            }
        }
        return result;
    }

    static {
        $assertionsDisabled = !PolicyConfigurationImpl.class.desiredAssertionStatus();
        logger = Logger.getLogger("javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(PolicyConfigurationImpl.class);
        linkTable = new HashMap();
        factory = SecurityRoleMapperFactoryMgr.getFactory();
        policySuffix = ".policy";
        PROVIDER_URL = "policy.url.";
        permissionParams = new Class[]{String.class, String.class};
        refreshLock = new Object();
        repository = PolicyConfigurationImpl.initializeRepository();
        setPolicyPermission = null;
    }
}

