/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jauth;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.clientbeans.ClientBeansResolver;
import com.sun.enterprise.config.clientbeans.ClientContainer;
import com.sun.enterprise.config.clientbeans.ProviderConfig;
import com.sun.enterprise.config.clientbeans.RequestPolicy;
import com.sun.enterprise.config.clientbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.ConfigFile;
import com.sun.enterprise.security.jauth.ConfigParser;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

class ConfigXMLParser
implements ConfigParser {
    private static Logger _logger = null;
    private HashMap configMap;
    private static final String SUNACC_XML_URL = "sun-acc.xml.url";
    private static final Debug debug;

    ConfigXMLParser() throws IOException {
        HashMap newConfig = new HashMap();
        if (Switch.getSwitch().getContainerType() == 2) {
            ConfigXMLParser.readDomainXML(newConfig);
        } else {
            ConfigXMLParser.readSunAccXML(newConfig);
        }
        this.configMap = newConfig;
    }

    private static void readDomainXML(HashMap newConfig) throws IOException {
        String intercept = null;
        try {
            ConfigContext configCtx = DeploymentServiceUtils.getConfigContext();
            if (configCtx == null) {
                return;
            }
            Config[] configs = ((Domain)configCtx.getRootConfigBean()).getConfigs().getConfig();
            for (int i = 0; i < configs.length; ++i) {
                SecurityService secService = configs[i].getSecurityService();
                MessageSecurityConfig[] msgConfigs = secService.getMessageSecurityConfig();
                for (int j = 0; msgConfigs != null && j < msgConfigs.length; ++j) {
                    intercept = ConfigXMLParser.parseInterceptEntry(msgConfigs[j], newConfig);
                    com.sun.enterprise.config.serverbeans.ProviderConfig[] pConfigs = msgConfigs[j].getProviderConfig();
                    for (int k = 0; pConfigs != null && k < pConfigs.length; ++k) {
                        ConfigXMLParser.parseIDEntry(pConfigs[k], newConfig, intercept);
                    }
                }
            }
        }
        catch (ConfigException ce) {
            IOException ioe = new IOException();
            ioe.initCause(ce);
            throw ioe;
        }
    }

    private static void readSunAccXML(HashMap newConfig) throws IOException {
        String intercept = null;
        try {
            ConfigContext configCtx = ConfigFactory.createConfigContext(System.getProperty(SUNACC_XML_URL), true, false, false, ClientContainer.class, new ClientBeansResolver());
            ClientContainer cc = (ClientContainer)configCtx.getRootConfigBean();
            com.sun.enterprise.config.clientbeans.MessageSecurityConfig[] msgConfigs = cc.getMessageSecurityConfig();
            for (int j = 0; msgConfigs != null && j < msgConfigs.length; ++j) {
                intercept = ConfigXMLParser.parseInterceptEntry(msgConfigs[j], newConfig);
                ProviderConfig[] pConfigs = msgConfigs[j].getProviderConfig();
                for (int k = 0; pConfigs != null && k < pConfigs.length; ++k) {
                    ConfigXMLParser.parseIDEntry(pConfigs[k], newConfig, intercept);
                }
            }
        }
        catch (ConfigException ce) {
            IOException ioe = new IOException();
            ioe.initCause(ce);
            throw ioe;
        }
    }

    public HashMap getConfigMap() {
        return this.configMap;
    }

    private static String parseInterceptEntry(MessageSecurityConfig msgConfig, HashMap newConfig) throws IOException {
        ConfigFile.InterceptEntry intEntry;
        String intercept = msgConfig.getAuthLayer();
        String defaultServerID = msgConfig.getDefaultProvider();
        String defaultClientID = msgConfig.getDefaultClientProvider();
        if (debug != null) {
            debug.println("Intercept Entry: \n    intercept: " + intercept + "\n    defaultServerID: " + defaultServerID + "\n    defaultClientID:  " + defaultClientID);
        }
        if ((intEntry = (ConfigFile.InterceptEntry)newConfig.get(intercept)) != null) {
            throw new IOException("found multiple MessageSecurityConfig entries with the same auth-layer");
        }
        intEntry = new ConfigFile.InterceptEntry(defaultClientID, defaultServerID, null);
        newConfig.put(intercept, intEntry);
        return intercept;
    }

    private static void parseIDEntry(com.sun.enterprise.config.serverbeans.ProviderConfig pConfig, HashMap newConfig, String intercept) throws IOException {
        String id = pConfig.getProviderId();
        String type = pConfig.getProviderType();
        String moduleClass = pConfig.getClassName();
        ArrayList<AppConfigurationEntry> modules = new ArrayList<AppConfigurationEntry>();
        AuthPolicy requestPolicy = ConfigXMLParser.parseRequestPolicy(pConfig.getRequestPolicy());
        AuthPolicy responsePolicy = ConfigXMLParser.parseResponsePolicy(pConfig.getResponsePolicy());
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < pConfig.sizeElementProperty(); ++i) {
            try {
                options.put(pConfig.getElementProperty(i).getName(), PropertyExpander.expand(pConfig.getElementProperty(i).getValue(), true));
                continue;
            }
            catch (PropertyExpander.ExpandException ee) {
                _logger.warning("Container-auth: unable to expand provider property value - unexpanded value passed to provider");
                options.put(pConfig.getElementProperty(i).getName(), pConfig.getElementProperty(i).getValue());
            }
        }
        if (debug != null) {
            debug.println("ID Entry: \n    id: " + id + "\n    type: " + type + "\n    request policy: " + requestPolicy + "\n    response policy: " + responsePolicy + "\n    module class: " + moduleClass + "\n        options: " + options);
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(pConfig.getClassName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        modules.add(entry);
        ConfigFile.IDEntry idEntry = new ConfigFile.IDEntry(type, requestPolicy, responsePolicy, modules);
        ConfigFile.InterceptEntry intEntry = (ConfigFile.InterceptEntry)newConfig.get(intercept);
        if (intEntry == null) {
            throw new IOException("intercept entry for " + intercept + " must be specified before ID entries");
        }
        if (intEntry.idMap == null) {
            intEntry.idMap = new HashMap();
        }
        intEntry.idMap.put(id, idEntry);
    }

    private static AuthPolicy parseRequestPolicy(com.sun.enterprise.config.serverbeans.RequestPolicy policy) {
        if (policy == null) {
            return null;
        }
        int sourceAuthType = 0;
        boolean foundSource = true;
        String authType = policy.getAuthSource();
        if ("sender".equals(authType)) {
            sourceAuthType = 1;
        } else if ("content".equals(authType)) {
            sourceAuthType = 2;
        } else {
            if (debug != null) {
                debug.println("invalid or null auth source: " + authType);
            }
            foundSource = false;
        }
        boolean recipientAuth = false;
        boolean beforeContent = false;
        boolean foundRecipient = true;
        String recipient = policy.getAuthRecipient();
        if ("before-content".equals(recipient)) {
            recipientAuth = true;
            beforeContent = true;
        } else if ("after-content".equals(recipient)) {
            recipientAuth = true;
            beforeContent = false;
        } else {
            if (debug != null) {
                debug.println("invalid or null auth recipient: " + recipient);
            }
            foundRecipient = false;
        }
        if (!foundSource && !foundRecipient) {
            return null;
        }
        return new AuthPolicy(sourceAuthType, recipientAuth, beforeContent);
    }

    private static AuthPolicy parseResponsePolicy(com.sun.enterprise.config.serverbeans.ResponsePolicy policy) {
        if (policy == null) {
            return null;
        }
        int sourceAuthType = 0;
        boolean foundSource = true;
        String authType = policy.getAuthSource();
        if ("sender".equals(authType)) {
            sourceAuthType = 1;
        } else if ("content".equals(authType)) {
            sourceAuthType = 2;
        } else {
            if (debug != null) {
                debug.println("invalid or null auth source: " + authType);
            }
            foundSource = false;
        }
        boolean recipientAuth = false;
        boolean beforeContent = false;
        boolean foundRecipient = true;
        String recipient = policy.getAuthRecipient();
        if ("before-content".equals(recipient)) {
            recipientAuth = true;
            beforeContent = true;
        } else if ("after-content".equals(recipient)) {
            recipientAuth = true;
            beforeContent = false;
        } else {
            if (debug != null) {
                debug.println("invalid or null auth recipient: " + recipient);
            }
            foundRecipient = false;
        }
        if (!foundSource && !foundRecipient) {
            return null;
        }
        return new AuthPolicy(sourceAuthType, recipientAuth, beforeContent);
    }

    private static String parseInterceptEntry(com.sun.enterprise.config.clientbeans.MessageSecurityConfig msgConfig, HashMap newConfig) throws IOException {
        ConfigFile.InterceptEntry intEntry;
        String intercept = msgConfig.getAuthLayer();
        String defaultServerID = msgConfig.getDefaultProvider();
        String defaultClientID = msgConfig.getDefaultClientProvider();
        if (debug != null) {
            debug.println("Intercept Entry: \n    intercept: " + intercept + "\n    defaultServerID: " + defaultServerID + "\n    defaultClientID:  " + defaultClientID);
        }
        if ((intEntry = (ConfigFile.InterceptEntry)newConfig.get(intercept)) != null) {
            throw new IOException("found multiple MessageSecurityConfig entries with the same auth-layer");
        }
        intEntry = new ConfigFile.InterceptEntry(defaultClientID, defaultServerID, null);
        newConfig.put(intercept, intEntry);
        return intercept;
    }

    private static void parseIDEntry(ProviderConfig pConfig, HashMap newConfig, String intercept) throws IOException {
        String id = pConfig.getProviderId();
        String type = pConfig.getProviderType();
        String moduleClass = pConfig.getClassName();
        ArrayList<AppConfigurationEntry> modules = new ArrayList<AppConfigurationEntry>();
        AuthPolicy requestPolicy = ConfigXMLParser.parseRequestPolicy(pConfig.getRequestPolicy());
        AuthPolicy responsePolicy = ConfigXMLParser.parseResponsePolicy(pConfig.getResponsePolicy());
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < pConfig.sizeElementProperty(); ++i) {
            try {
                options.put(pConfig.getElementProperty(i).getName(), PropertyExpander.expand(pConfig.getElementProperty(i).getValue(), true));
                continue;
            }
            catch (PropertyExpander.ExpandException ee) {
                _logger.warning("Container-auth: unable to expand provider property value - unexpanded value passed to provider");
                options.put(pConfig.getElementProperty(i).getName(), pConfig.getElementProperty(i).getValue());
            }
        }
        if (debug != null) {
            debug.println("ID Entry: \n    id: " + id + "\n    type: " + type + "\n    request policy: " + requestPolicy + "\n    response policy: " + responsePolicy + "\n    module class: " + moduleClass + "\n        options: " + options);
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(pConfig.getClassName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        modules.add(entry);
        ConfigFile.IDEntry idEntry = new ConfigFile.IDEntry(type, requestPolicy, responsePolicy, modules);
        ConfigFile.InterceptEntry intEntry = (ConfigFile.InterceptEntry)newConfig.get(intercept);
        if (intEntry == null) {
            throw new IOException("intercept entry for " + intercept + " must be specified before ID entries");
        }
        if (intEntry.idMap == null) {
            intEntry.idMap = new HashMap();
        }
        intEntry.idMap.put(id, idEntry);
    }

    private static AuthPolicy parseRequestPolicy(RequestPolicy policy) {
        if (policy == null) {
            return null;
        }
        int sourceAuthType = 0;
        boolean foundSource = true;
        String authType = policy.getAuthSource();
        if ("sender".equals(authType)) {
            sourceAuthType = 1;
        } else if ("content".equals(authType)) {
            sourceAuthType = 2;
        } else {
            if (debug != null) {
                debug.println("invalid or null auth source: " + authType);
            }
            foundSource = false;
        }
        boolean recipientAuth = false;
        boolean beforeContent = false;
        boolean foundRecipient = true;
        String recipient = policy.getAuthRecipient();
        if ("before-content".equals(recipient)) {
            recipientAuth = true;
            beforeContent = true;
        } else if ("after-content".equals(recipient)) {
            recipientAuth = true;
            beforeContent = false;
        } else {
            if (debug != null) {
                debug.println("invalid or null auth recipient: " + recipient);
            }
            foundRecipient = false;
        }
        if (!foundSource && !foundRecipient) {
            return null;
        }
        return new AuthPolicy(sourceAuthType, recipientAuth, beforeContent);
    }

    private static AuthPolicy parseResponsePolicy(ResponsePolicy policy) {
        if (policy == null) {
            return null;
        }
        int sourceAuthType = 0;
        boolean foundSource = true;
        String authType = policy.getAuthSource();
        if ("sender".equals(authType)) {
            sourceAuthType = 1;
        } else if ("content".equals(authType)) {
            sourceAuthType = 2;
        } else {
            if (debug != null) {
                debug.println("invalid or null auth source: " + authType);
            }
            foundSource = false;
        }
        boolean recipientAuth = false;
        boolean beforeContent = false;
        boolean foundRecipient = true;
        String recipient = policy.getAuthRecipient();
        if ("before-content".equals(recipient)) {
            recipientAuth = true;
            beforeContent = true;
        } else if ("after-content".equals(recipient)) {
            recipientAuth = true;
            beforeContent = false;
        } else {
            if (debug != null) {
                debug.println("invalid or null auth recipient: " + recipient);
            }
            foundRecipient = false;
        }
        if (!foundSource && !foundRecipient) {
            return null;
        }
        return new AuthPolicy(sourceAuthType, recipientAuth, beforeContent);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        debug = Debug.getInstance("configxmlparser", "[ConfigXMLParser]");
    }
}

