/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jauth;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import com.sun.enterprise.deployment.runtime.common.ProtectionDescriptor;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class BaseAuthConfig {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private Object defaultContext_;
    private MessageSecurityDescriptor superMSD_;
    private ArrayList contexts_;
    private ArrayList messageSecurityDescriptors_;
    private ArrayList contextsForOpcodes_;
    private HashMap contextsForOpNames_;
    private boolean onePolicy_;
    private Object contextLock = new Object();
    private ExplicitNull explicitNull = new ExplicitNull();
    private static QName[] mechanisms = new QName[]{new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse")};

    protected BaseAuthConfig(Object context) {
        this.defaultContext_ = context;
        this.superMSD_ = null;
        this.messageSecurityDescriptors_ = null;
        this.contexts_ = null;
        this.contextsForOpcodes_ = null;
        this.contextsForOpNames_ = null;
        this.onePolicy_ = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WSS: New BAC defaultContext: " + this.defaultContext_);
        }
    }

    protected BaseAuthConfig(ArrayList descriptors, ArrayList authContexts) {
        this.defaultContext_ = null;
        this.superMSD_ = null;
        this.messageSecurityDescriptors_ = descriptors;
        this.contexts_ = authContexts;
        this.contextsForOpcodes_ = null;
        this.contextsForOpNames_ = null;
        this.onePolicy_ = true;
        for (int i = 0; i < descriptors.size(); ++i) {
            MessageSecurityDescriptor msd = (MessageSecurityDescriptor)descriptors.get(i);
            for (int j = 0; j < descriptors.size(); ++j) {
                if (j == i || BaseAuthConfig.policiesAreEqual(msd, (MessageSecurityDescriptor)descriptors.get(j))) continue;
                this.onePolicy_ = false;
            }
        }
        int superIndex = -1;
        block2: for (int i = 0; this.defaultContext_ == null && i < descriptors.size(); ++i) {
            boolean noProtection;
            MessageSecurityDescriptor msd = (MessageSecurityDescriptor)descriptors.get(i);
            AuthPolicy requestPolicy = BaseAuthConfig.getAuthPolicy(msd.getRequestProtectionDescriptor());
            AuthPolicy responsePolicy = BaseAuthConfig.getAuthPolicy(msd.getResponseProtectionDescriptor());
            boolean bl = noProtection = !requestPolicy.authRequired() && !responsePolicy.authRequired();
            if (i == 0 && this.onePolicy_ && noProtection) {
                this.defaultContext_ = this.explicitNull;
                break;
            }
            ArrayList mDs = msd.getMessageDescriptors();
            for (int j = 0; mDs != null && j < mDs.size(); ++j) {
                MessageDescriptor mD = (MessageDescriptor)mDs.get(j);
                MethodDescriptor methD = mD.getMethodDescriptor();
                if (methD == null || methD.getStyle() != 1) continue;
                if (this.onePolicy_) {
                    this.defaultContext_ = this.contexts_.get(i);
                    if (this.defaultContext_ != null) continue block2;
                    this.defaultContext_ = this.explicitNull;
                    continue block2;
                }
                if (superIndex == -1) {
                    if (noProtection) {
                        this.defaultContext_ = this.explicitNull;
                        continue;
                    }
                    superIndex = i;
                    continue;
                }
                if (BaseAuthConfig.policiesAreEqual(msd, (MessageSecurityDescriptor)descriptors.get(superIndex))) continue;
                this.defaultContext_ = this.explicitNull;
                superIndex = -1;
                continue block2;
            }
        }
        if (superIndex >= 0) {
            this.superMSD_ = (MessageSecurityDescriptor)descriptors.get(superIndex);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WSS: new BAC defaultContext_: " + this.defaultContext_ + " superMSD index: " + superIndex + " onePolicy_: " + this.onePolicy_);
        }
    }

    protected static AuthPolicy getAuthPolicy(ProtectionDescriptor pd) {
        int sourceAuthType = 0;
        boolean recipientAuth = false;
        boolean beforeContent = false;
        if (pd != null) {
            String recipient;
            String source = pd.getAttributeValue("AuthSource");
            if (source != null) {
                if (source.equals("sender")) {
                    sourceAuthType = 1;
                } else if (source.equals("content")) {
                    sourceAuthType = 2;
                }
            }
            if ((recipient = pd.getAttributeValue("AuthRecipient")) != null) {
                recipientAuth = true;
                if (recipient.equals("before-content")) {
                    beforeContent = true;
                } else if (recipient.equals("after-content")) {
                    beforeContent = false;
                }
            }
        }
        return new AuthPolicy(sourceAuthType, recipientAuth, beforeContent);
    }

    private static boolean isMatchingMSD(MethodDescriptor targetMD, MessageSecurityDescriptor mSD) {
        ArrayList messageDescriptors = mSD.getMessageDescriptors();
        if (messageDescriptors.size() == 0) {
            return true;
        }
        for (int i = 0; i < messageDescriptors.size(); ++i) {
            MessageDescriptor nextMD = (MessageDescriptor)messageDescriptors.get(i);
            MethodDescriptor mD = nextMD.getMethodDescriptor();
            String opName = nextMD.getOperationName();
            if (opName != null || mD != null && !mD.implies(targetMD)) continue;
            return true;
        }
        return false;
    }

    private static boolean policiesAreEqual(MessageSecurityDescriptor reference, MessageSecurityDescriptor other) {
        return BaseAuthConfig.getAuthPolicy(reference.getRequestProtectionDescriptor()).equals(BaseAuthConfig.getAuthPolicy(other.getRequestProtectionDescriptor())) && BaseAuthConfig.getAuthPolicy(reference.getResponseProtectionDescriptor()).equals(BaseAuthConfig.getAuthPolicy(other.getResponseProtectionDescriptor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getContextForMethod(Method m) {
        Object rvalue = null;
        Object object = this.contextLock;
        synchronized (object) {
            if (this.defaultContext_ != null) {
                rvalue = this.defaultContext_;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WSS: ForMethod returning default_context: " + rvalue);
                }
                return rvalue;
            }
        }
        if (m != null) {
            int match = -1;
            MethodDescriptor targetMD = new MethodDescriptor(m);
            for (int i = 0; i < this.messageSecurityDescriptors_.size(); ++i) {
                if (!BaseAuthConfig.isMatchingMSD(targetMD, (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(i))) continue;
                if (match < 0) {
                    match = i;
                    continue;
                }
                if (BaseAuthConfig.policiesAreEqual((MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(match), (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(i))) continue;
                rvalue = this.explicitNull;
                match = -1;
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("WSS: ForMethod detected conflicting policies: " + match + "." + i);
                break;
            }
            if (match >= 0) {
                rvalue = this.contexts_.get(match);
                if (rvalue == null) {
                    rvalue = this.explicitNull;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WSS: ForMethod returning matched context: " + rvalue);
                }
            }
        } else if (this.onePolicy_ && this.contexts_.size() > 0) {
            rvalue = this.contexts_.get(0);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("WSS: ForMethod resorting to first context: " + rvalue);
            }
        } else {
            logger.fine("WSS: Unable to select policy for SOAP Message");
            throw new RuntimeException("Unable to select policy for Message");
        }
        return rvalue;
    }

    private boolean methodIsCovered(Method m) {
        boolean rvalue = true;
        if (this.messageSecurityDescriptors_ != null) {
            MethodDescriptor targetMD = new MethodDescriptor(m);
            for (int i = 0; i < this.messageSecurityDescriptors_.size(); ++i) {
                if (i == 0) {
                    rvalue = false;
                }
                if (!BaseAuthConfig.isMatchingMSD(targetMD, (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(i))) continue;
                rvalue = true;
                break;
            }
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getExplicitContextForOpCode(StreamingHandler handler, int opcode) throws ClassNotFoundException, NoSuchMethodException {
        Object rvalue = null;
        Object object = this.contextLock;
        synchronized (object) {
            if (this.contextsForOpcodes_ == null && this.defaultContext_ == null) {
                boolean onePolicyForAll = this.onePolicy_;
                Method m = null;
                for (int i = 0; i == 0 || m != null; ++i) {
                    if (i == 0) {
                        this.contextsForOpcodes_ = new ArrayList();
                    }
                    if (handler != null) {
                        m = handler.getMethodForOpcode(i);
                    }
                    if (m == null) continue;
                    Object o = this.getContextForMethod(m);
                    this.contextsForOpcodes_.add(o);
                    if (o != null) continue;
                    onePolicyForAll = false;
                }
                if (onePolicyForAll && this.contextsForOpcodes_.size() > 0) {
                    this.defaultContext_ = this.contextsForOpcodes_.get(0);
                }
            }
            if (this.defaultContext_ != null) {
                rvalue = this.defaultContext_;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WSS: ForOpCode returning default_context: " + rvalue);
                }
            }
        }
        if (rvalue == null) {
            if (opcode >= 0 && opcode < this.contextsForOpcodes_.size()) {
                rvalue = this.contextsForOpcodes_.get(opcode);
            } else if (opcode < 0) {
                rvalue = this.getContextForMethod(null);
            }
        }
        return rvalue;
    }

    protected Object getContextForOpCode(StreamingHandler handler, int opcode) throws ClassNotFoundException, NoSuchMethodException {
        Object rvalue = this.getExplicitContextForOpCode(handler, opcode);
        if (rvalue != null && rvalue instanceof ExplicitNull) {
            rvalue = null;
        }
        return rvalue;
    }

    private static String getOpNameForMessage(SOAPMessage message) {
        String rvalue;
        block6: {
            SOAPPart soap;
            String[] actions;
            rvalue = null;
            MimeHeaders headers = message.getMimeHeaders();
            if (headers != null && (actions = headers.getHeader("SOAPAction")) != null && actions.length > 0) {
                rvalue = actions[0];
            }
            if (rvalue == null && (soap = message.getSOAPPart()) != null) {
                try {
                    SOAPBody body;
                    SOAPEnvelope envelope = soap.getEnvelope();
                    if (envelope == null || (body = envelope.getBody()) == null) break block6;
                    Iterator it = body.getChildElements();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof SOAPElement)) continue;
                        Name name = ((SOAPElement)o).getElementName();
                        if (name != null) {
                            rvalue = name.getLocalName();
                        }
                        break;
                    }
                }
                catch (SOAPException se) {
                    if (!logger.isLoggable(Level.FINE)) break block6;
                    logger.log(Level.FINE, "WSS: Unable to get SOAP envelope", se);
                }
            }
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getContextForMessage(SOAPMessage message) {
        Object object = this.contextLock;
        synchronized (object) {
            if (this.contextsForOpNames_ == null) {
                this.contextsForOpNames_ = new HashMap();
                for (int i = 0; this.messageSecurityDescriptors_ != null && i < this.messageSecurityDescriptors_.size(); ++i) {
                    MessageSecurityDescriptor mSD = (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(i);
                    ArrayList mDs = mSD.getMessageDescriptors();
                    for (int j = 0; mDs != null && j < mDs.size(); ++j) {
                        MessageDescriptor mD = (MessageDescriptor)mDs.get(j);
                        String opName = mD.getOperationName();
                        if (opName == null) continue;
                        if (this.contextsForOpNames_.containsKey(opName)) {
                            MessageSecurityDescriptor other;
                            Integer k = (Integer)this.contextsForOpNames_.get(opName);
                            if (k == null || BaseAuthConfig.policiesAreEqual(mSD, other = (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(k))) continue;
                            this.contextsForOpNames_.put(opName, null);
                            continue;
                        }
                        if (this.superMSD_ != null && !BaseAuthConfig.policiesAreEqual(mSD, this.superMSD_)) {
                            this.contextsForOpNames_.put(opName, null);
                            continue;
                        }
                        this.contextsForOpNames_.put(opName, new Integer(i));
                    }
                }
            }
        }
        Object rvalue = null;
        String opName = BaseAuthConfig.getOpNameForMessage(message);
        if (opName != null && this.contextsForOpNames_.containsKey(opName)) {
            Integer k = (Integer)this.contextsForOpNames_.get(opName);
            rvalue = k != null ? this.contexts_.get(k) : this.explicitNull;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("WSS: ForMessage: Opname=" + opName + " context: " + rvalue);
            }
        } else {
            rvalue = this.getContextForMethod(null);
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getContext(StreamingHandler handler, SOAPMessage message) {
        Object rvalue = null;
        Object object = this.contextLock;
        synchronized (object) {
            if (this.defaultContext_ != null) {
                rvalue = this.defaultContext_;
            }
        }
        if (rvalue == null) {
            if (handler == null) {
                rvalue = this.getContextForMessage(message);
            } else {
                int opCode = handler.getOpcodeForRequestMessage(message);
                if (opCode == -1) {
                    rvalue = this.getContextForMethod(null);
                } else {
                    try {
                        rvalue = this.getExplicitContextForOpCode(handler, opCode);
                        if (rvalue == null) {
                            rvalue = this.getContextForMessage(message);
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new RuntimeException(cnfe);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new RuntimeException(nsme);
                    }
                }
            }
        }
        if (rvalue != null && rvalue instanceof ExplicitNull) {
            rvalue = null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WSS: getContext returning: " + rvalue);
        }
        return rvalue;
    }

    public QName[] getMechanisms() {
        return mechanisms;
    }

    class ExplicitNull {
        ExplicitNull() {
        }

        public boolean equals(Object other) {
            return other != null && other instanceof ExplicitNull;
        }

        public String toString() {
            return "ExplicitNull";
        }
    }
}

