/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.realm.ldap.LDAPRealm;
import com.sun.jndi.ldap.obj.GroupOfURLs;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.CompositeName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;

public class LDAPLoginModule
extends PasswordLoginModule {
    private String _userDNbase;
    private String _searchFilter;
    private String _grpDNbase;
    private String _grpSearchFilter;
    private String _grpTarget;
    private LDAPRealm _ldapRealm;
    private String[] _dnOnly = new String[]{"dn"};

    protected void authenticate() throws LoginException {
        if (!(this._currentRealm instanceof LDAPRealm)) {
            String msg = sm.getString("ldaplm.badrealm");
            throw new LoginException(msg);
        }
        this._ldapRealm = (LDAPRealm)this._currentRealm;
        if (this._password == null || this._password.length() == 0) {
            String msg = sm.getString("ldaplm.emptypassword", this._username);
            throw new LoginException(msg);
        }
        this._userDNbase = this._currentRealm.getProperty("base-dn");
        this._searchFilter = this._currentRealm.getProperty("search-filter");
        this._grpDNbase = this._currentRealm.getProperty("group-base-dn");
        this._grpSearchFilter = this._currentRealm.getProperty("group-search-filter");
        this._grpTarget = this._currentRealm.getProperty("group-target");
        String mode = this._currentRealm.getProperty("mode");
        if (!"find-bind".equals(mode)) {
            String msg = sm.getString("ldaplm.badmode", mode);
            throw new LoginException(msg);
        }
        this.findAndBind();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findAndBind() throws LoginException {
        String[] grpList;
        String srcFilter;
        block14: {
            StringBuffer sb = new StringBuffer(this._searchFilter);
            LDAPLoginModule.substitute(sb, "%s", this._username);
            String userid = sb.toString();
            InitialDirContext ctx = null;
            srcFilter = null;
            grpList = null;
            try {
                try {
                    ctx = new InitialDirContext(this._ldapRealm.getLdapBindProps());
                    String realUserDN = this.userSearch(ctx, this._userDNbase, userid);
                    if (realUserDN == null) {
                        String msg = sm.getString("ldaplm.usernotfound", this._username);
                        throw new LoginException(msg);
                    }
                    boolean bindSuccessful = this.bindAsUser(realUserDN, this._password);
                    if (!bindSuccessful) {
                        String msg = sm.getString("ldaplm.bindfailed", realUserDN);
                        throw new LoginException(msg);
                    }
                    sb = new StringBuffer(this._grpSearchFilter);
                    LDAPLoginModule.substitute(sb, "%s", this._username);
                    LDAPLoginModule.substitute(sb, "%d", realUserDN);
                    srcFilter = sb.toString();
                    ArrayList groupsList = new ArrayList();
                    groupsList.addAll(this.groupSearch(ctx, this._grpDNbase, srcFilter, this._grpTarget));
                    groupsList.addAll(this.dynamicGroupSearch(ctx, this._grpDNbase, this._grpTarget, realUserDN));
                    grpList = new String[groupsList.size()];
                    groupsList.toArray(grpList);
                }
                catch (Exception e) {
                    throw new LoginException(e.toString());
                }
                Object var10_12 = null;
                if (ctx == null) break block14;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (ctx == null) throw throwable;
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (NamingException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (NamingException e) {}
            ctx.close();
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "LDAP:Group search filter: " + srcFilter);
            StringBuffer gb = new StringBuffer();
            gb.append("Group memberships found: ");
            if (grpList != null) {
                for (int i = 0; i < grpList.length; ++i) {
                    gb.append(" " + grpList[i]);
                }
            } else {
                gb.append("(null)");
            }
            this._logger.log(Level.FINE, "LDAP: " + gb.toString());
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "LDAP: login succeeded for: " + this._username);
        }
        this.commitAuthentication(this._username, this._password, this._currentRealm, grpList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String userSearch(DirContext ctx, String baseDN, String filter) {
        NamingEnumeration<SearchResult> namingEnum;
        String foundDN;
        block10: {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.log(Level.FINE, "search: baseDN: " + baseDN + "  filter: " + filter);
            }
            foundDN = null;
            namingEnum = null;
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(this._dnOnly);
            ctls.setSearchScope(2);
            ctls.setCountLimit(1L);
            namingEnum = ctx.search(baseDN, filter, ctls);
            if (!namingEnum.hasMore()) break block10;
            SearchResult res = namingEnum.next();
            StringBuffer sb = new StringBuffer();
            CompositeName compDN = new CompositeName(res.getName());
            String ldapDN = compDN.get(0);
            sb.append(ldapDN);
            if (res.isRelative()) {
                sb.append(",");
                sb.append(baseDN);
            }
            foundDN = sb.toString();
            if (!this._logger.isLoggable(Level.FINEST)) break block10;
            this._logger.log(Level.FINE, "Found user DN: " + foundDN);
        }
        Object var12_12 = null;
        if (namingEnum == null) return foundDN;
        try {
            namingEnum.close();
            return foundDN;
        }
        catch (Exception ex) {}
        return foundDN;
        {
            catch (Exception e) {
                this._logger.log(Level.WARNING, "ldaplm.searcherror", filter);
                this._logger.log(Level.WARNING, "security.exception", e);
                Object var12_13 = null;
                if (namingEnum == null) return foundDN;
                try {
                    namingEnum.close();
                    return foundDN;
                }
                catch (Exception ex) {}
                return foundDN;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (namingEnum == null) throw throwable;
            try {
                namingEnum.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean bindAsUser(String bindDN, String password) {
        boolean bindSuccessful = false;
        Properties p = this._ldapRealm.getLdapBindProps();
        p.put("java.naming.security.principal", bindDN);
        p.put("java.naming.security.credentials", password);
        InitialDirContext ctx = null;
        ctx = new InitialDirContext(p);
        bindSuccessful = true;
        Object var8_6 = null;
        if (ctx == null) return bindSuccessful;
        try {
            ctx.close();
            return bindSuccessful;
        }
        catch (NamingException e2) {}
        return bindSuccessful;
        {
            catch (Exception e) {
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.finest("Error binding to directory as: " + bindDN);
                    this._logger.finest("Exception from JNDI: " + e.toString());
                }
                Object var8_7 = null;
                if (ctx == null) return bindSuccessful;
                try {
                    ctx.close();
                    return bindSuccessful;
                }
                catch (NamingException e2) {}
                return bindSuccessful;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private List dynamicGroupSearch(DirContext ctx, String baseDN, String target, String userDN) {
        ArrayList<String> groupList = new ArrayList<String>();
        String filter = "(&(objectclass=groupofuniquenames)(objectclass=*groupofurls*))";
        String[] targets = new String[]{target, "memberUrl"};
        try {
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(targets);
            ctls.setSearchScope(2);
            ctls.setReturningObjFlag(true);
            NamingEnumeration<SearchResult> e = ctx.search(baseDN, filter, ctls);
            while (e.hasMore()) {
                X500Principal x500principal;
                GroupOfURLs gurls;
                SearchResult res = e.next();
                Object searchedObject = res.getObject();
                if (!(searchedObject instanceof GroupOfURLs) || !(gurls = (GroupOfURLs)searchedObject).isMember(x500principal = new X500Principal(userDN))) continue;
                Attribute grpAttr = res.getAttributes().get(target);
                int sz = grpAttr.size();
                for (int i = 0; i < sz; ++i) {
                    String s = (String)grpAttr.get(i);
                    groupList.add(s);
                }
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "ldaplm.searcherror", filter);
            this._logger.log(Level.WARNING, "security.exception", e);
        }
        return groupList;
    }

    private List groupSearch(DirContext ctx, String baseDN, String filter, String target) {
        ArrayList<String> groupList = new ArrayList<String>();
        try {
            String[] targets = new String[]{target};
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(targets);
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> e = ctx.search(baseDN, filter, ctls);
            while (e.hasMore()) {
                SearchResult res = e.next();
                Attribute grpAttr = res.getAttributes().get(target);
                int sz = grpAttr.size();
                for (int i = 0; i < sz; ++i) {
                    String s = (String)grpAttr.get(i);
                    groupList.add(s);
                }
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "ldaplm.searcherror", filter);
            this._logger.log(Level.WARNING, "security.exception", e);
        }
        return groupList;
    }

    private static void substitute(StringBuffer sb, String target, String value) {
        int i = sb.indexOf(target);
        while (i >= 0) {
            sb.replace(i, i + target.length(), value);
            i = sb.indexOf(target);
        }
    }
}

