/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.audit.bsm;

import com.sun.audit.AuditEvent_admin_authenticate;
import com.sun.audit.AuditEvent_logout;
import com.sun.audit.AuditEvent_network_modify;
import com.sun.audit.AuditSession;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class BSMAuditManager {
    private static final int ADT_NO_ATTRIB = -1;
    private static final int SUCCESS = 0;
    private static final int FAILURE = -1;
    private static InheritableThreadLocal currentAuditSession;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    private BSMAuditManager() {
    }

    public static void authentication(String user, String remoteHost, String realm, boolean success) {
        block3: {
            AuditSession auditSession = null;
            try {
                int status;
                auditSession = BSMAuditManager.getAuditSession(user, remoteHost, true);
                AuditEvent_admin_authenticate authenticateEvent = new AuditEvent_admin_authenticate(auditSession);
                authenticateEvent.message(0);
                int n = status = success ? 0 : -1;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("authentication putEvent(" + status + ", 0)");
                }
                authenticateEvent.putEvent(status, 0);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "java_security.bsm_audit_failure", new Object[]{"authentication", t.toString()});
            }
        }
    }

    public static void webInvocation(String user, HttpServletRequest req, String type, boolean success) {
        block5: {
            AuditSession auditSession = null;
            try {
                int status;
                if (!$assertionsDisabled && req == null) {
                    throw new AssertionError();
                }
                auditSession = BSMAuditManager.getAuditSession(user, req.getRemoteHost(), false);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Creating AuditEvent_network_modify");
                }
                AuditEvent_network_modify networkEvent = new AuditEvent_network_modify(auditSession);
                networkEvent.object_name("ServletName=" + req.getRequestURI());
                networkEvent.name_service("Method=" + req.getMethod());
                networkEvent.auth_used("Mode=webInv");
                networkEvent.changed_values("Type=" + type);
                int n = status = success ? 0 : -1;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("webInvocation putEvent(" + status + ", 0)");
                }
                networkEvent.putEvent(status, 0);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "java_security.bsm_audit_failure", new Object[]{"webInvocation", t.toString()});
            }
        }
    }

    public static void ejbInvocation(String user, String remoteHost, String ejb, String method, boolean success) {
        block4: {
            AuditSession auditSession = null;
            try {
                int status;
                auditSession = BSMAuditManager.getAuditSession(user, remoteHost, false);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Creating AuditEvent_network_modify");
                }
                AuditEvent_network_modify networkEvent = new AuditEvent_network_modify(auditSession);
                networkEvent.object_name("EjbName=" + ejb);
                networkEvent.name_service("Method=" + method);
                networkEvent.auth_used("Mode=ejbInv");
                int n = status = success ? 0 : -1;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("ejbInvocation putEvent(" + status + ", 0)");
                }
                networkEvent.putEvent(status, 0);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, "java_security.bsm_audit_failure", new Object[]{"ejbInvocation", t.toString()});
            }
        }
    }

    public static void adminInvocation(String user, String remoteHost, String objectName, String operationName, String mode, String value, boolean success) {
        block4: {
            AuditSession auditSession = null;
            try {
                int status;
                auditSession = BSMAuditManager.getAuditSession(user, remoteHost, false);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Creating AuditEvent_network_modify");
                }
                AuditEvent_network_modify networkEvent = new AuditEvent_network_modify(auditSession);
                networkEvent.object_name("ObjectName=" + objectName);
                networkEvent.name_service("OperationName=" + operationName);
                networkEvent.auth_used("Mode=" + mode);
                networkEvent.changed_values("Value=" + value);
                int n = status = success ? 0 : -1;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("adminInvocation putEvent(" + status + ", 0)");
                }
                networkEvent.putEvent(status, 0);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, "java_security.bsm_audit_failure", new Object[]{"adminInvocation", t.toString()});
            }
        }
    }

    public static void logout(String user, String remoteHost, boolean success) {
        block4: {
            AuditSession auditSession = null;
            try {
                int status;
                auditSession = BSMAuditManager.getAuditSession(user, remoteHost, false);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Creating AuditEvent_logout");
                }
                AuditEvent_logout logoutEvent = new AuditEvent_logout(auditSession);
                logoutEvent.user_name(user);
                int n = status = success ? 0 : -1;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("logout putEvent(" + status + ",0)");
                }
                logoutEvent.putEvent(status, 0);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, "java_security.bsm_audit_failure", new Object[]{"logout", t.toString()});
            }
        }
    }

    private static AuditSession getAuditSession(String user, String remoteHost, boolean isAuth) throws Exception {
        AuditSession auditSession = null;
        if (!isAuth) {
            auditSession = (AuditSession)currentAuditSession.get();
        }
        if (auditSession == null) {
            int[] nids;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Creating AuditSession");
            }
            auditSession = new AuditSession(null);
            int[] ids = new int[]{-1, -1};
            if (user != null && user.length() > 0 && (nids = BSMAuditManager.nativeGetUidGid(user)) != null && nids.length == 2) {
                ids = nids;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Getting uid = " + ids[0] + ", gid = " + ids[1]);
            }
            int context = 0;
            if (ids[0] == -1 || ids[1] == -1) {
                ids[0] = -1;
                ids[1] = -1;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Invoking AuditSession.setUser");
            }
            if (remoteHost == null || "127.0.0.1".equals(remoteHost)) {
                remoteHost = "localhost";
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Invoking AuditSession.setUser");
            }
            auditSession.setUser(ids[0], ids[1], ids[0], ids[1], remoteHost, context);
            currentAuditSession.set(auditSession);
        }
        return auditSession;
    }

    private static native int[] nativeGetUidGid(String var0);

    static {
        $assertionsDisabled = !BSMAuditManager.class.desiredAssertionStatus();
        currentAuditSession = new InheritableThreadLocal();
        logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        System.loadLibrary("solarisauth");
    }
}

