/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.security.AbstractSecurityContext;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import com.sun.web.security.PrincipalGroupFactory;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public class SecurityContext
extends AbstractSecurityContext {
    private static Logger _logger = null;
    private static InheritableThreadLocal currentSecCtx;
    private static SecurityContext defaultSecurityContext;
    private static AuthPermission doAsPrivilegedPerm;
    private boolean SERVER_GENERATED_SECURITY_CONTEXT = false;

    public SecurityContext(String userName, Subject subject) {
        Subject s = subject;
        if (s == null) {
            s = new Subject();
            _logger.warning("java_security.null_subject");
        }
        this.initiator = new PrincipalImpl(userName);
        final Subject sub = s;
        this.subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sub.getPrincipals().add(SecurityContext.this.initiator);
                return sub;
            }
        });
    }

    public SecurityContext(String userName, Subject subject, String realm) {
        Subject s = subject;
        if (s == null) {
            s = new Subject();
            _logger.warning("java_security.null_subject");
        }
        this.initiator = PrincipalGroupFactory.getPrincipalInstance(userName, realm);
        final Subject sub = s;
        this.subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sub.getPrincipals().add(SecurityContext.this.initiator);
                return sub;
            }
        });
    }

    private SecurityContext() {
        this.subject = new Subject();
        this.initiator = null;
        this.setServerGeneratedCredentials();
        this.subject.setReadOnly();
    }

    public static SecurityContext init() {
        SecurityContext sc = (SecurityContext)currentSecCtx.get();
        if (sc == null) {
            sc = defaultSecurityContext;
        }
        return sc;
    }

    public static SecurityContext getDefaultSecurityContext() {
        return defaultSecurityContext;
    }

    public static Subject getDefaultSubject() {
        return SecurityContext.defaultSecurityContext.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal getDefaultCallerPrincipal() {
        Class clazz = SecurityContext.class;
        synchronized (clazz) {
            if (SecurityContext.defaultSecurityContext.initiator == null) {
                String guestUser = null;
                try {
                    guestUser = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                        static final /* synthetic */ boolean $assertionsDisabled;

                        public Object run() throws Exception {
                            ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
                            if (!$assertionsDisabled && configContext == null) {
                                throw new AssertionError();
                            }
                            SecurityService securityBean = ServerBeansFactory.getSecurityServiceBean(configContext);
                            if (!$assertionsDisabled && securityBean == null) {
                                throw new AssertionError();
                            }
                            return securityBean.getDefaultPrincipal();
                        }

                        static {
                            $assertionsDisabled = !(class$com$sun$enterprise$security$SecurityContext == null ? (class$com$sun$enterprise$security$SecurityContext = SecurityContext.class$("com.sun.enterprise.security.SecurityContext")) : class$com$sun$enterprise$security$SecurityContext).desiredAssertionStatus();
                        }
                    });
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "java_security.default_user_login_Exception", e);
                }
                finally {
                    if (guestUser == null) {
                        guestUser = "ANONYMOUS";
                    }
                }
                SecurityContext.defaultSecurityContext.initiator = new PrincipalImpl(guestUser);
            }
        }
        return SecurityContext.defaultSecurityContext.initiator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurityContext generateDefaultSecurityContext() {
        Class clazz = SecurityContext.class;
        synchronized (clazz) {
            try {
                return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new SecurityContext();
                    }
                });
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "java_security.security_context_exception", e);
            }
        }
        return null;
    }

    public static void reset(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    public static SecurityContext getCurrent() {
        SecurityContext sc = (SecurityContext)currentSecCtx.get();
        if (sc == null) {
            sc = defaultSecurityContext;
        }
        return sc;
    }

    public static void setCurrent(SecurityContext sc) {
        if (sc != null && sc != defaultSecurityContext) {
            SecurityContext current = (SecurityContext)currentSecCtx.get();
            if (sc != current) {
                boolean permitted = false;
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("permission check done to set SecurityContext");
                        }
                        sm.checkPermission(doAsPrivilegedPerm);
                    }
                    permitted = true;
                }
                catch (SecurityException se) {
                    _logger.log(Level.SEVERE, "java_security.security_context_permission_exception", se);
                }
                catch (Throwable t) {
                    _logger.log(Level.SEVERE, "java_security.security_context_unexpected_exception", t);
                }
                if (permitted) {
                    currentSecCtx.set(sc);
                } else {
                    _logger.severe("java_security.security_context_nochange");
                }
            }
        } else {
            currentSecCtx.set(sc);
        }
    }

    public static void setUnauthenticatedContext() {
        currentSecCtx.set(defaultSecurityContext);
    }

    public boolean didServerGenerateCredentials() {
        return this.SERVER_GENERATED_SECURITY_CONTEXT;
    }

    private void setServerGeneratedCredentials() {
        this.SERVER_GENERATED_SECURITY_CONTEXT = true;
    }

    public Principal getCallerPrincipal() {
        return this == defaultSecurityContext ? SecurityContext.getDefaultCallerPrincipal() : this.initiator;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "SecurityContext[ Initiator: " + this.initiator + "Subject " + this.subject + " ]";
    }

    public Set getPrincipalSet() {
        return this.subject.getPrincipals();
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        currentSecCtx = new InheritableThreadLocal();
        defaultSecurityContext = SecurityContext.generateDefaultSecurityContext();
        doAsPrivilegedPerm = new AuthPermission("doAsPrivileged");
    }
}

