/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RealmConfig {
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void createRealms(String defaultRealm, AuthRealm[] realms) {
        if (!$assertionsDisabled && realms == null) {
            throw new AssertionError();
        }
        String goodRealm = null;
        for (int i = 0; i < realms.length; ++i) {
            AuthRealm aRealm = realms[i];
            String realmName = aRealm.getName();
            String realmClass = aRealm.getClassname();
            if (!$assertionsDisabled && realmName == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && realmClass == null) {
                throw new AssertionError();
            }
            try {
                ElementProperty[] realmProps = aRealm.getElementProperty();
                Properties props = new Properties();
                for (int j = 0; j < realmProps.length; ++j) {
                    ElementProperty p = realmProps[j];
                    String name = p.getName();
                    String value = p.getValue();
                    props.setProperty(name, value);
                }
                Realm.instantiate(realmName, realmClass, props);
                logger.fine("Configured realm: " + realmName);
                if (goodRealm != null) continue;
                goodRealm = realmName;
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "realmconfig.disable", realmName);
                logger.log(Level.WARNING, "security.exception", e);
            }
        }
        if (goodRealm == null) {
            logger.severe("realmconfig.nogood");
        } else {
            try {
                Realm def = Realm.getInstance(defaultRealm);
                if (def == null) {
                    defaultRealm = goodRealm;
                }
            }
            catch (Exception e) {
                defaultRealm = goodRealm;
            }
            Realm.setDefaultRealm(defaultRealm);
            logger.fine("Default realm is set to: " + defaultRealm);
        }
    }

    public static void createRealms() {
        try {
            logger.fine("Initializing configured realms.");
            ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
            if (!$assertionsDisabled && configContext == null) {
                throw new AssertionError();
            }
            Server configBean = ServerBeansFactory.getServerBean(configContext);
            if (!$assertionsDisabled && configBean == null) {
                throw new AssertionError();
            }
            SecurityService securityBean = ServerBeansFactory.getSecurityServiceBean(configContext);
            if (!$assertionsDisabled && securityBean == null) {
                throw new AssertionError();
            }
            String defaultRealm = securityBean.getDefaultRealm();
            AuthRealm[] realms = securityBean.getAuthRealm();
            if (!$assertionsDisabled && realms == null) {
                throw new AssertionError();
            }
            RealmConfig.createRealms(defaultRealm, realms);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "realmconfig.nogood", e);
        }
    }

    static {
        $assertionsDisabled = !RealmConfig.class.desiredAssertionStatus();
        logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

