/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.security.PermissionCache;
import java.net.SocketPermission;
import java.security.CodeSource;
import java.security.Policy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.PropertyPermission;

public class PermissionCacheFactory {
    private static HashMap cacheMap = new HashMap();
    private static int factoryKey = 0;
    private static boolean supportsReuse = false;
    private static PermissionCache securityManagerCache = PermissionCacheFactory.createSecurityManagerCache();

    private static synchronized PermissionCache createSecurityManagerCache() {
        int k = factoryKey++;
        PermissionCache cache = new PermissionCache(k, null, null, new Class[]{SocketPermission.class, PropertyPermission.class}, null);
        cacheMap.put(cache.getFactoryKey(), cache);
        return cache;
    }

    public static synchronized PermissionCache createPermissionCache(String pcID, CodeSource codesource, Class[] classes, String name) {
        if (!supportsReuse) {
            return null;
        }
        int k = factoryKey++;
        PermissionCache cache = new PermissionCache(k, pcID, codesource, classes, name);
        cacheMap.put(cache.getFactoryKey(), cache);
        return cache;
    }

    public static synchronized PermissionCache removePermissionCache(PermissionCache cache) {
        PermissionCache rvalue = null;
        if (cache != null && (rvalue = (PermissionCache)cacheMap.remove(cache.getFactoryKey())) != null) {
            rvalue.reset();
        }
        return rvalue;
    }

    public static synchronized void resetCaches() {
        supportsReuse = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && sm instanceof J2EESecurityManager && !((J2EESecurityManager)sm).cacheEnabled()) {
            ((J2EESecurityManager)sm).enablePermissionCache(securityManagerCache);
        }
        Iterator iter = cacheMap.values().iterator();
        while (iter.hasNext()) {
            PermissionCache cache = (PermissionCache)iter.next();
            cache.reset();
        }
    }

    static {
        try {
            Policy policy = Policy.getPolicy();
            if (policy != null) {
                policy.refresh();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

