/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.CachedPermissionImpl;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;

public class PermissionCache {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static Policy policy = Policy.getPolicy();
    private static AllPermission allPermission = new AllPermission();
    private Permissions cache;
    private CodeSource codesource;
    private Class[] classes;
    private String name;
    private String pcID;
    private final Integer factoryKey;
    private volatile int epoch = 1;

    PermissionCache(int key, String pcID, CodeSource codesource, Class[] classes, String name) {
        this.codesource = codesource == null ? new CodeSource(null, null) : codesource;
        this.factoryKey = new Integer(key);
        this.cache = null;
        this.pcID = pcID;
        this.classes = classes;
        this.name = name;
    }

    public Integer getFactoryKey() {
        return this.factoryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadCache(Permission p) {
        PermissionCollection pc;
        block17: {
            if (this.cache != null) return true;
            this.cache = new Permissions();
            boolean setPc = false;
            String oldpcID = null;
            try {
                oldpcID = PolicyContext.getContextID();
                if (!(this.pcID == oldpcID || this.pcID != null && this.pcID.equals(oldpcID))) {
                    setPc = true;
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "JACC: Unexpected security exception on access decision", ex);
                return false;
            }
            pc = null;
            try {
                try {
                    if (setPc) {
                        this.setPolicyContextID(this.pcID);
                    }
                    pc = policy.getPermissions(this.codesource);
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "JACC: Unexpected security exception on access decision", ex);
                    boolean bl = false;
                    Object var8_7 = null;
                    if (!setPc) return bl;
                    try {
                        this.setPolicyContextID(oldpcID);
                        return bl;
                    }
                    catch (Exception ex2) {
                        _logger.log(Level.SEVERE, "JACC: Unexpected security exception on access decision", ex2);
                        return false;
                    }
                }
                Object var8_6 = null;
                if (!setPc) break block17;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (!setPc) throw throwable;
                try {}
                catch (Exception ex2) {
                    _logger.log(Level.SEVERE, "JACC: Unexpected security exception on access decision", ex2);
                    return false;
                }
                this.setPolicyContextID(oldpcID);
                throw throwable;
            }
            try {}
            catch (Exception ex2) {
                _logger.log(Level.SEVERE, "JACC: Unexpected security exception on access decision", ex2);
                return false;
            }
            this.setPolicyContextID(oldpcID);
        }
        pc.implies(p);
        Enumeration<Permission> granted = pc.elements();
        while (granted.hasMoreElements()) {
            Permission i = granted.nextElement();
            if (i.equals(allPermission)) {
                this.cache.add(i);
                continue;
            }
            boolean classMatch = true;
            if (this.classes != null) {
                classMatch = false;
                Class<?> iClazz = i.getClass();
                for (int j = 0; j < this.classes.length; ++j) {
                    if (!this.classes[j].equals(iClazz)) continue;
                    classMatch = true;
                    break;
                }
            }
            if (!classMatch) continue;
            if (this.name != null) {
                String name = i.getName();
                if (name == null || !this.name.equals(name)) continue;
                this.cache.add(i);
                continue;
            }
            this.cache.add(i);
        }
        return true;
    }

    public synchronized boolean checkPermission(Permission p, CachedPermissionImpl.Epoch epoch) {
        boolean rvalue = this.loadCache(p);
        if (rvalue) {
            if (epoch.epoch != this.epoch) {
                epoch.granted = this.cache.implies(p);
                epoch.epoch = this.epoch;
            }
            rvalue = epoch.granted;
        }
        return rvalue;
    }

    public synchronized boolean checkPermission(Permission p) {
        return this.loadCache(p) ? this.cache.implies(p) : false;
    }

    public synchronized void reset() {
        this.cache = null;
        this.epoch = this.epoch + 1 == 0 ? 1 : this.epoch + 1;
    }

    private void setPolicyContextID(final String newID) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                PolicyContext.setContextID((String)newID);
                return null;
            }
        });
    }
}

