/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import java.util.HashMap;

public class CipherInfo {
    private static final short SSL2 = 1;
    private static final short SSL3 = 2;
    private static final short TLS = 4;
    private static HashMap ciphers = new HashMap();
    private String configName;
    private String cipherName;
    private short protocolVersion;

    private CipherInfo(String configName, String cipherName, short protocolVersion) {
        this.configName = configName;
        this.cipherName = cipherName;
        this.protocolVersion = protocolVersion;
    }

    public static CipherInfo getCipherInfo(String configName) {
        return (CipherInfo)ciphers.get(configName);
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getCipherName() {
        return this.cipherName;
    }

    public boolean isSSL2() {
        return (this.protocolVersion & 1) == 1;
    }

    public boolean isSSL3() {
        return (this.protocolVersion & 2) == 2;
    }

    public boolean isTLS() {
        return (this.protocolVersion & 4) == 4;
    }

    static {
        ciphers.put("rsa_rc4_128_md5", new CipherInfo("rsa_rc4_128_md5", "SSL_RSA_WITH_RC4_128_MD5", 6));
        ciphers.put("rsa_rc4_128_sha", new CipherInfo("rsa_rc4_128_sha", "SSL_RSA_WITH_RC4_128_SHA", 6));
        ciphers.put("rsa_3des_sha", new CipherInfo("rsa_3des_sha", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", 6));
        ciphers.put("fips_des_sha", new CipherInfo("fips_des_sha", "SSL_RSA_WITH_DES_CBC_SHA", 6));
        ciphers.put("rsa_rc4_40_md5", new CipherInfo("rsa_rc4_40_md5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", 6));
        ciphers.put("rsa_null_md5", new CipherInfo("rsa_null_md5", "SSL_RSA_WITH_NULL_MD5", 6));
        ciphers.put("rsa_null_sha", new CipherInfo("rsa_null_sha", "SSL_RSA_WITH_NULL_SHA", 6));
    }
}

