/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.monitor;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.JDBCConnectionPoolStats;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.resource.IASNonSharedResourcePool;
import com.sun.enterprise.resource.monitor.JDBCConnectionPoolStatsImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;

public class JDBCPoolMonitoringLevelListener
implements MonitoringLevelListener {
    private PoolManager poolManager_;
    private MonitoringRegistry registry_;
    private static final MonitoringLevel OFF = MonitoringLevel.OFF;
    private static final MonitoringLevel HIGH = MonitoringLevel.HIGH;
    private static final MonitoringLevel LOW = MonitoringLevel.LOW;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (from == to) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerContext ctxt = ApplicationServer.getServerContext();
                if (ctxt != null) {
                    JDBCPoolMonitoringLevelListener.this.registry_ = ctxt.getMonitoringRegistry();
                }
                return null;
            }
        });
        if (from == OFF && (to == HIGH || to == LOW)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Changing level from OFF to ON");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IASNonSharedResourcePool[] pools = JDBCPoolMonitoringLevelListener.this.getPoolList();
                    if (pools == null) {
                        return null;
                    }
                    for (int i = 0; i < pools.length; ++i) {
                        if (pools[i] == null) continue;
                        try {
                            JDBCConnectionPoolStatsImpl stats = new JDBCConnectionPoolStatsImpl(pools[i]);
                            JDBCPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabled(pools[i].getPoolName(), true);
                            JDBCPoolMonitoringLevelListener.this.registry_.registerJDBCConnectionPoolStats((JDBCConnectionPoolStats)stats, pools[i].getPoolName(), null);
                            continue;
                        }
                        catch (Exception mre) {
                            try {
                                _logger.log(Level.INFO, "poolmon.cannot_reg: " + pools[i].getPoolName(), mre.getMessage());
                                JDBCPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabled(pools[i].getPoolName(), false);
                                continue;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                    return null;
                }
            });
        }
        if ((from == HIGH || from == LOW) && to == OFF) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Changing level from ON to OFF");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IASNonSharedResourcePool[] pools = JDBCPoolMonitoringLevelListener.this.getPoolList();
                    if (pools == null) {
                        return null;
                    }
                    for (int i = 0; i < pools.length; ++i) {
                        if (pools[i] == null) continue;
                        try {
                            JDBCPoolMonitoringLevelListener.this.registry_.unregisterJDBCConnectionPoolStats(pools[i].getPoolName());
                            JDBCPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabled(pools[i].getPoolName(), false);
                            continue;
                        }
                        catch (Exception mre) {
                            _logger.log(Level.WARNING, "poolmon.cannot_unreg: " + pools[i].getPoolName(), mre.getMessage());
                        }
                    }
                    return null;
                }
            });
        }
    }

    private IASNonSharedResourcePool[] getPoolList() {
        ResourcesUtil resUtil = ResourcesUtil.getInstance();
        JdbcConnectionPool[] jp = resUtil.getJdbcConnectionPools();
        if (jp == null) {
            return null;
        }
        IASNonSharedResourcePool[] pools = new IASNonSharedResourcePool[jp.length];
        Hashtable poolTable = (Hashtable)Switch.getSwitch().getPoolManager().getPoolTable().clone();
        for (int i = 0; i < jp.length; ++i) {
            pools[i] = (IASNonSharedResourcePool)poolTable.get(jp[i].getName());
        }
        return pools;
    }

    private PoolManager getPoolManager() {
        if (this.poolManager_ == null) {
            this.poolManager_ = Switch.getSwitch().getPoolManager();
        }
        return this.poolManager_;
    }
}

