/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.monitor;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.ConnectionFactoryStats;
import com.sun.enterprise.admin.monitor.stats.ConnectorConnectionPoolStats;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.resource.IASNonSharedResourcePool;
import com.sun.enterprise.resource.monitor.ConnectorConnectionPoolStatsImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;

public class ConnectorPoolMonitoringLevelListener
implements MonitoringLevelListener {
    private ResourcesUtil resUtil_;
    private PoolManager poolManager_;
    private MonitoringRegistry registry_;
    private static final MonitoringLevel OFF = MonitoringLevel.OFF;
    private static final MonitoringLevel HIGH = MonitoringLevel.HIGH;
    private static final MonitoringLevel LOW = MonitoringLevel.LOW;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (from == to) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerContext ctxt = ApplicationServer.getServerContext();
                if (ctxt != null) {
                    ConnectorPoolMonitoringLevelListener.this.registry_ = ctxt.getMonitoringRegistry();
                }
                return null;
            }
        });
        if (from == OFF && (to == HIGH || to == LOW)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Switching level form OFF to ON");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ConnectorConnectionPoolStatsImpl stats;
                    IASNonSharedResourcePool pool;
                    Map poolMap = ConnectorPoolMonitoringLevelListener.this.getPoolMap();
                    if (poolMap == null) {
                        return null;
                    }
                    Iterator iter = poolMap.keySet().iterator();
                    while (iter.hasNext()) {
                        ConnectorConnectionPool ccp = (ConnectorConnectionPool)iter.next();
                        pool = (IASNonSharedResourcePool)poolMap.get(ccp);
                        if (pool == null) continue;
                        try {
                            stats = new ConnectorConnectionPoolStatsImpl(pool);
                            ConnectorPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabled(pool.getPoolName(), true);
                            ConnectorPoolMonitoringLevelListener.this.registry_.registerConnectorConnectionPoolStats((ConnectorConnectionPoolStats)stats, pool.getPoolName(), ConnectorPoolMonitoringLevelListener.this.getAppName(ccp.getResourceAdapterName()), ConnectorPoolMonitoringLevelListener.this.getRAName(ccp.getResourceAdapterName()), null);
                        }
                        catch (Exception mre) {
                            try {
                                _logger.log(Level.WARNING, "poolmon.cannot_reg", mre.getMessage());
                                ConnectorPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabled(pool.getPoolName(), false);
                            }
                            catch (Exception ex) {}
                        }
                    }
                    IASNonSharedResourcePool[] cfList = ConnectorPoolMonitoringLevelListener.this.getConnectionFactories();
                    if (cfList == null) {
                        return null;
                    }
                    for (int i = 0; i < cfList.length; ++i) {
                        pool = cfList[i];
                        if (pool == null) continue;
                        try {
                            stats = (ConnectionFactoryStats)new ConnectorConnectionPoolStatsImpl(pool);
                            ConnectorPoolMonitoringLevelListener.this.registry_.registerConnectionFactoryStats((ConnectionFactoryStats)stats, pool.getPoolName(), null);
                            ConnectorPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabled(pool.getPoolName(), true);
                            continue;
                        }
                        catch (Exception mre) {
                            _logger.log(Level.WARNING, "poolmon.cannot_reg", mre.getMessage());
                        }
                    }
                    return null;
                }
            });
        }
        if ((from == HIGH || from == LOW) && to == OFF) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Switching level form ON to OFF");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Map pools = ConnectorPoolMonitoringLevelListener.this.getPoolMap();
                    if (pools == null) {
                        return null;
                    }
                    Iterator iter = pools.keySet().iterator();
                    while (iter.hasNext()) {
                        ConnectorConnectionPool ccp = (ConnectorConnectionPool)iter.next();
                        IASNonSharedResourcePool pool = (IASNonSharedResourcePool)pools.get(ccp);
                        if (pool == null) continue;
                        try {
                            ConnectorPoolMonitoringLevelListener.this.registry_.unregisterConnectorConnectionPoolStats(pool.getPoolName(), ConnectorPoolMonitoringLevelListener.this.getAppName(ccp.getResourceAdapterName()), ConnectorPoolMonitoringLevelListener.this.getRAName(ccp.getResourceAdapterName()));
                            ConnectorPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabled(pool.getPoolName(), false);
                        }
                        catch (Exception mre) {
                            _logger.log(Level.INFO, "poolmon.cannot_unreg");
                        }
                    }
                    IASNonSharedResourcePool[] cfArr = ConnectorPoolMonitoringLevelListener.this.getConnectionFactories();
                    for (int i = 0; i < cfArr.length; ++i) {
                        if (cfArr[i] == null) continue;
                        try {
                            ConnectorPoolMonitoringLevelListener.this.registry_.unregisterConnectionFactoryStats(cfArr[i].getPoolName());
                            ConnectorPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabled(cfArr[i].getPoolName(), false);
                            continue;
                        }
                        catch (Exception mre) {
                            _logger.log(Level.INFO, "poolmon.cannot_unreg");
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected String getRAName(String resourceAdapterName) {
        int delimIdx = resourceAdapterName.indexOf("#");
        if (delimIdx == -1) {
            return resourceAdapterName;
        }
        return resourceAdapterName.substring(delimIdx + 1);
    }

    protected String getAppName(String resourceAdapterName) {
        int delimIdx = resourceAdapterName.indexOf("#");
        if (delimIdx == -1) {
            return null;
        }
        return resourceAdapterName.substring(0, delimIdx);
    }

    private Map getPoolMap() {
        ResourcesUtil resUtil = ResourcesUtil.getInstance();
        ConnectorConnectionPool[] cp = resUtil.getConnectorConnectionPools();
        if (cp == null) {
            return null;
        }
        ArrayList al = new ArrayList();
        HashMap<ConnectorConnectionPool, IASNonSharedResourcePool> poolMap = new HashMap<ConnectorConnectionPool, IASNonSharedResourcePool>();
        Hashtable poolTable = (Hashtable)Switch.getSwitch().getPoolManager().getPoolTable().clone();
        for (int i = 0; i < cp.length; ++i) {
            if (cp[i].getName().equalsIgnoreCase(ConnectorConstants.DEFAULT_JMS_ADAPTER)) continue;
            IASNonSharedResourcePool p = (IASNonSharedResourcePool)poolTable.get(cp[i].getName());
            poolMap.put(cp[i], p);
        }
        return poolMap;
    }

    private IASNonSharedResourcePool[] getConnectionFactories() {
        ResourcesUtil resUtil = ResourcesUtil.getInstance();
        ConnectorConnectionPool[] cp = resUtil.getConnectorConnectionPools();
        if (cp == null) {
            return null;
        }
        ArrayList<IASNonSharedResourcePool> al = new ArrayList<IASNonSharedResourcePool>();
        Hashtable poolTable = (Hashtable)Switch.getSwitch().getPoolManager().getPoolTable().clone();
        for (int i = 0; i < cp.length; ++i) {
            if (!cp[i].getName().equalsIgnoreCase(ConnectorConstants.DEFAULT_JMS_ADAPTER)) continue;
            IASNonSharedResourcePool p = (IASNonSharedResourcePool)poolTable.get(cp[i].getName());
            al.add(p);
        }
        return al.toArray(new IASNonSharedResourcePool[0]);
    }

    private PoolManager getPoolManager() {
        if (this.poolManager_ == null) {
            this.poolManager_ = Switch.getSwitch().getPoolManager();
        }
        return this.poolManager_;
    }
}

