/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.security.SecurityContext;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class ResourcePrincipalMapper
implements Serializable {
    private Hashtable mapTable = new Hashtable();
    private ResourcePrincipal defaultRP = null;
    static Logger _logger = null;

    public void setDefaultResourcePrincipal(ResourcePrincipal rprinc) {
        this.defaultRP = rprinc;
    }

    public ResourcePrincipal getDefaultResourcePrincipal() {
        return this.defaultRP;
    }

    public void assignResourcePrincipal(Principal p, ResourcePrincipal rp) {
        this.mapTable.put(p, rp);
    }

    public Enumeration getPrincipals() {
        return this.mapTable.keys();
    }

    public Enumeration getResourcePrincipals() {
        Vector<ResourcePrincipal> resourcePrincipals = new Vector<ResourcePrincipal>();
        Enumeration e = this.mapTable.elements();
        while (e.hasMoreElements()) {
            ResourcePrincipal nextResourcePrincipal = (ResourcePrincipal)e.nextElement();
            if (resourcePrincipals.contains(nextResourcePrincipal)) continue;
            resourcePrincipals.addElement(nextResourcePrincipal);
        }
        return resourcePrincipals.elements();
    }

    public Enumeration getPrincipalsFor(ResourcePrincipal resourcePrincipal) {
        Vector<Principal> principals = new Vector<Principal>();
        Enumeration e = this.getPrincipals();
        while (e.hasMoreElements()) {
            Principal nextPrincipal = (Principal)e.nextElement();
            ResourcePrincipal nextResourcePrincipal = (ResourcePrincipal)this.mapTable.get(nextPrincipal);
            if (!nextResourcePrincipal.equals(resourcePrincipal) || principals.contains(nextPrincipal)) continue;
            principals.addElement(nextPrincipal);
        }
        return principals.elements();
    }

    public ResourcePrincipal getResourcePrincipalFor(Principal principal) {
        return (ResourcePrincipal)this.mapTable.get(principal);
    }

    public void removePrincipal(Principal p) {
        this.mapTable.remove(p);
    }

    public ResourcePrincipal getResourcePrincipal() {
        ResourcePrincipal rp;
        Principal p;
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc != null && (p = sc.getCallerPrincipal()) != null && (rp = (ResourcePrincipal)this.mapTable.get(p)) != null) {
            return rp;
        }
        return this.defaultRP;
    }

    public String toString() {
        String s = "ResourcePrincipaMapper: ";
        if (this.defaultRP != null) {
            s = s + "dflt:" + this.defaultRP.getName();
        }
        Enumeration e = this.getPrincipals();
        while (e.hasMoreElements()) {
            Principal nextPrincipal = (Principal)e.nextElement();
            ResourcePrincipal resourcePrincipal = this.getResourcePrincipalFor(nextPrincipal);
            s = s + "," + nextPrincipal.getName() + "->" + resourcePrincipal.getName();
        }
        return s;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

