/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.repository.CustomResource;
import com.sun.enterprise.repository.ExternalJndiResource;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.MailResource;
import com.sun.enterprise.repository.PMFResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.JndiProxyObjectFactory;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ProxyRefAddr;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.transaction.XAResourceWrapper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jms.spi.xa.JMSXAConnection;
import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.jms.spi.xa.JMSXAQueueConnection;
import com.sun.jms.spi.xa.JMSXAQueueConnectionFactory;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicConnectionFactory;
import com.sun.jts.CosTransactions.DelegatedRecoveryManager;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.transaction.xa.XAResource;

public class ResourceInstaller {
    public static final String CONNECTOR_ADAPTER_DIR = "connector" + File.separator + "adapters";
    public static final String CONNECTOR_PROPS = "connector" + File.separator + "connector.properties";
    private static final String PM_JNDI_EXTENSION = "__pm";
    private static final String OBSOLETE_JDBC_DRIVER_PROP = "jdbc.drivers";
    private static final String OBSOLETE_JDBC10_PROP = "jdbc.datasources";
    private static final String OBSOLETE_JDBC20_PROP = "jdbc20.datasources";
    private static final String SET_ = "set";
    private static final String SET_CONNECTION_FACTORY = "setConnectionFactory";
    private static final String SET_CONNECTION_FACTORY_NAME = "setConnectionFactoryName";
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceInstaller.class);
    private Hashtable connectorDescriptors = new Hashtable();
    private J2EEResourceFactory resFactory;
    private J2EEResourceCollection resourceInfo;
    private ManagementObjectManager mgmtObjectMgr = Switch.getSwitch().getManagementObjectManager();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public ResourceInstaller() {
        try {
            this.resFactory = ServerConfiguration.getJ2EEResourceFactory();
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
        }
        catch (J2EEResourceException re) {
            _logger.log(Level.SEVERE, "J2EE.cannot_load_resources", re);
        }
    }

    private void loadAllJdbcResources() {
        block5: {
            ResourcesUtil resutil = ResourcesUtil.getInstance();
            try {
                ConfigBean[][] configBeans = resutil.getJdbcResources();
                JdbcResource[] jdbcResources = (JdbcResource[])configBeans[1];
                InitialContext ic = new InitialContext();
                for (int i = 0; jdbcResources != null && i < jdbcResources.length; ++i) {
                    if (!jdbcResources[i].isEnabled()) continue;
                    ic.lookup(jdbcResources[i].getJndiName());
                }
            }
            catch (ConfigException ce) {
                _logger.log(Level.SEVERE, "", ce.getMessage());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(ce.toString());
                }
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "", ne.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.fine(ne.toString());
            }
        }
    }

    private void loadAllConnectorResources() {
        block5: {
            ResourcesUtil resutil = ResourcesUtil.getInstance();
            try {
                ConfigBean[][] configBeans = resutil.getConnectorResources();
                ConnectorResource[] connResources = (ConnectorResource[])configBeans[1];
                InitialContext ic = new InitialContext();
                for (int i = 0; connResources != null && i < connResources.length; ++i) {
                    if (!connResources[i].isEnabled()) continue;
                    ic.lookup(connResources[i].getJndiName());
                }
            }
            catch (ConfigException ce) {
                _logger.log(Level.SEVERE, "", ce.getMessage());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(ce.toString());
                }
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "", ne.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.fine(ne.toString());
            }
        }
    }

    private void loadAllJmsResources() {
        try {
            ResourcesUtil resutil = ResourcesUtil.getInstance();
            ConnectorResource[] jmsResources = resutil.getAllJmsResources();
            InitialContext ic = new InitialContext();
            for (int i = 0; jmsResources != null && i < jmsResources.length; ++i) {
                ic.lookup(jmsResources[i].getJndiName());
            }
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "", ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverIncompleteTx(boolean delegated, String logPath) throws Exception {
        boolean bl;
        boolean result = false;
        Vector jdbcConnList = new Vector();
        Vector jmsConnList = new Vector();
        Vector connectorConnList = new Vector();
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Performing recovery of incomplete Tx...");
            }
            Vector xaresList = new Vector();
            Context ic = Switch.getSwitch().getNamingManager().getInitialContext();
            this.recoverJdbcXAResources(xaresList, jdbcConnList);
            this.recoverExternalJndiResourceJMSXAResources(ic, xaresList, jmsConnList);
            this.recoverConnectorXAResources(xaresList, connectorConnList);
            int size = xaresList.size();
            XAResource[] xaresArray = new XAResource[size];
            for (int i = 0; i < size; ++i) {
                xaresArray[i] = (XAResource)xaresList.elementAt(i);
            }
            String msg = localStrings.getLocalString("xaresource.recovering", "Recovering {0} XA resources...", new Object[]{String.valueOf(size)});
            _logger.log(Level.FINE, msg);
            if (!delegated) {
                RecoveryManager.recoverIncompleteTx(xaresArray);
                result = true;
            } else {
                result = DelegatedRecoveryManager.delegated_recover(logPath, xaresArray);
            }
            bl = result;
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                this.closeJdbcXAResources(jdbcConnList);
                this.closeConnectorXAResources(connectorConnList);
                this.closeJMSXAResources(jmsConnList);
            }
            catch (Exception ex1) {
                _logger.log(Level.WARNING, "xaresource.recover_error", ex1);
            }
            throw throwable;
        }
        try {
            this.closeJdbcXAResources(jdbcConnList);
            this.closeConnectorXAResources(connectorConnList);
            this.closeJMSXAResources(jmsConnList);
        }
        catch (Exception ex1) {
            _logger.log(Level.WARNING, "xaresource.recover_error", ex1);
        }
        return bl;
    }

    public void recoverXAResources() {
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            TransactionService txnService = null;
            txnService = ServerBeansFactory.getTransactionServiceBean(ctx);
            if (!txnService.isAutomaticRecovery()) {
                return;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "ejbserver.recovery", "Perform recovery of XAResources...");
            }
            Vector xaresList = new Vector();
            Vector jdbcConnList = new Vector();
            Vector jmsConnList = new Vector();
            Vector connectorConnList = new Vector();
            Context ic = Switch.getSwitch().getNamingManager().getInitialContext();
            this.recoverJdbcXAResources(xaresList, jdbcConnList);
            this.recoverExternalJndiResourceJMSXAResources(ic, xaresList, jmsConnList);
            this.recoverConnectorXAResources(xaresList, connectorConnList);
            int size = xaresList.size();
            XAResource[] xaresArray = new XAResource[size];
            for (int i = 0; i < size; ++i) {
                xaresArray[i] = (XAResource)xaresList.elementAt(i);
            }
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            String msg = localStrings.getLocalString("xaresource.recovering", "Recovering {0} XA resources...", new Object[]{String.valueOf(size)});
            _logger.log(Level.FINE, msg);
            tm.recover(xaresArray);
            this.closeJdbcXAResources(jdbcConnList);
            this.closeConnectorXAResources(connectorConnList);
            this.closeJMSXAResources(jmsConnList);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "xaresource.recover_error", ex);
        }
    }

    private void recoverJdbcXAResources(Vector xaresList, Vector connList) {
        ResourcesUtil resourceUtil = ResourcesUtil.getInstance();
        ConfigBean[] jdbcres = null;
        try {
            jdbcres = resourceUtil.getJdbcResources()[1];
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, ce.getMessage());
            return;
        }
        if (jdbcres == null || jdbcres.length == 0) {
            return;
        }
        HashSet<JdbcConnectionPool> jdbcPools = new HashSet<JdbcConnectionPool>();
        for (int i = 0; i < jdbcres.length; ++i) {
            try {
                if (!resourceUtil.isEnabled(jdbcres[i])) continue;
                JdbcConnectionPool pool = resourceUtil.getJdbcConnectionPoolByName(((JdbcResource)jdbcres[i]).getPoolName());
                if (pool != null && "javax.sql.XADataSource".equals(pool.getResType())) {
                    jdbcPools.add(pool);
                }
                this.logFine("ResourceInstaller:: recoverJdbcXAResources :: adding : " + ((JdbcResource)jdbcres[i]).getPoolName());
                continue;
            }
            catch (ConfigException ce) {
                _logger.log(Level.WARNING, ce.getMessage());
            }
        }
        this.loadAllJdbcResources();
        Properties xaresourcewrappers = new Properties();
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            TransactionService txs = ServerBeansFactory.getTransactionServiceBean(ctx);
            xaresourcewrappers.put("oracle.jdbc.xa.client.OracleXADataSource", "com.sun.enterprise.transaction.OracleXAResource");
            ElementProperty[] eprops = txs.getElementProperty();
            for (int i = 0; i < eprops.length; ++i) {
                String name = eprops[i].getName();
                String value = eprops[i].getValue();
                if (name.equals("oracle-xa-recovery-workaround")) {
                    if (!"false".equals(value)) continue;
                    xaresourcewrappers.remove("oracle.jdbc.xa.client.OracleXADataSource");
                    continue;
                }
                if (!name.equals("sybase-xa-recovery-workaround") || !value.equals("true")) continue;
                xaresourcewrappers.put("com.sybase.jdbc2.jdbc.SybXADataSource", "com.sun.enterprise.transaction.SybaseXAResource");
            }
        }
        catch (ConfigException cex) {
            _logger.log(Level.INFO, "jdbc.config_error", cex);
        }
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        Iterator iter = jdbcPools.iterator();
        while (iter.hasNext()) {
            JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)iter.next();
            if (jdbcConnectionPool.getResType() == null || jdbcConnectionPool.getName() == null || !jdbcConnectionPool.getResType().equals("javax.sql.XADataSource")) continue;
            String poolName = jdbcConnectionPool.getName();
            try {
                String[] dbUserPassword = resourceUtil.getdbUserPasswordOfJdbcConnectionPool(jdbcConnectionPool);
                String dbUser = dbUserPassword[0];
                String dbPassword = dbUserPassword[1];
                ManagedConnectionFactory fac = crt.obtainManagedConnectionFactory(poolName);
                Subject subject = new Subject();
                PasswordCredential pc = new PasswordCredential(dbUser, dbPassword.toCharArray());
                pc.setManagedConnectionFactory(fac);
                ResourcePrincipal prin = new ResourcePrincipal(dbUser, dbPassword);
                subject.getPrincipals().add(prin);
                subject.getPrivateCredentials().add(pc);
                ManagedConnection mc = fac.createManagedConnection(subject, null);
                connList.addElement(mc);
                try {
                    XAResource xares = mc.getXAResource();
                    if (xares == null) continue;
                    String clName = jdbcConnectionPool.getDatasourceClassname();
                    String wrapperclass = (String)xaresourcewrappers.get(clName);
                    if (wrapperclass != null) {
                        XAResourceWrapper xaresWrapper = null;
                        xaresWrapper = (XAResourceWrapper)Class.forName(wrapperclass).newInstance();
                        xaresWrapper.init(mc, subject);
                        xaresList.addElement(xaresWrapper);
                        continue;
                    }
                    xaresList.addElement(xares);
                }
                catch (ResourceException ex) {
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "datasource.xadatasource_error", poolName);
                _logger.log(Level.FINE, "datasource.xadatasource_error_excp", ex);
            }
        }
    }

    private void recoverConnectorXAResources(Vector xaresList, Vector connList) {
        ResourcesUtil resourceUtil = ResourcesUtil.getInstance();
        ConfigBean[] connRes = null;
        try {
            connRes = resourceUtil.getConnectorResources()[1];
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, ce.getMessage());
            return;
        }
        if (connRes == null || connRes.length == 0) {
            return;
        }
        HashSet<ConnectorConnectionPool> connPools = new HashSet<ConnectorConnectionPool>();
        for (int i = 0; i < connRes.length; ++i) {
            try {
                ConnectorConnectionPool pool;
                if (!resourceUtil.isEnabled(connRes[i]) || (pool = resourceUtil.getConnectorConnectionPoolByName(((ConnectorResource)connRes[i]).getPoolName())) == null || !"XATransaction".equals(this.getTransactionSupport(pool))) continue;
                connPools.add(pool);
                this.logFine("ResourceInstaller:: recoverConnectorXAResources :: adding : " + ((ConnectorResource)connRes[i]).getPoolName());
                continue;
            }
            catch (ConfigException ce) {
                _logger.warning(ce.getMessage());
            }
        }
        this.loadAllConnectorResources();
        Iterator iter = connPools.iterator();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        while (iter.hasNext()) {
            ConnectorConnectionPool connPool = (ConnectorConnectionPool)iter.next();
            String poolName = connPool.getName();
            try {
                String[] dbUserPassword = resourceUtil.getdbUserPasswordOfConnectorConnectionPool(connPool);
                if (dbUserPassword == null) continue;
                String dbUser = dbUserPassword[0];
                String dbPassword = dbUserPassword[1];
                ManagedConnectionFactory mcf = crt.obtainManagedConnectionFactory(poolName);
                Subject subject = new Subject();
                if (dbPassword == null) {
                    dbPassword = "";
                    _logger.log(Level.WARNING, "datasource.xadatasource_nullpassword_error", poolName);
                }
                if (dbUser == null) {
                    dbUser = "";
                    _logger.log(Level.WARNING, "datasource.xadatasource_nulluser_error", poolName);
                }
                PasswordCredential pc = new PasswordCredential(dbUser, dbPassword.toCharArray());
                pc.setManagedConnectionFactory(mcf);
                ResourcePrincipal prin = new ResourcePrincipal(dbUser, dbPassword);
                subject.getPrincipals().add(prin);
                subject.getPrivateCredentials().add(pc);
                ManagedConnection mc = mcf.createManagedConnection(subject, null);
                connList.addElement(mc);
                try {
                    XAResource xares = mc.getXAResource();
                    if (xares == null) continue;
                    xaresList.addElement(xares);
                }
                catch (ResourceException ex) {
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "datasource.xadatasource_error", poolName);
                _logger.log(Level.FINE, "datasource.xadatasource_error_excp", ex);
            }
        }
    }

    private void recoverExternalJndiResourceJMSXAResources(Context ic, Vector xaresList, Vector connList) {
        Set res = this.resourceInfo.getResourcesByType(10);
        this.recoverJMSXAResources(ic, xaresList, connList, res);
    }

    private void recoverJMSResourceJMSXAResources(Context ic, Vector xaresList, Vector connList) {
        JMSXAConnectionFactory obj;
        this.loadAllJmsResources();
        Set res = this.resourceInfo.getResourcesByType(2);
        this.recoverJMSXAResources(ic, xaresList, connList, res);
        String jndiName = null;
        try {
            jndiName = "MDB_CONTAINER_QUEUE_CF__jmsxa_default";
            obj = (JMSXAConnectionFactory)ic.lookup(jndiName);
            this.recoverJMSXAResource(xaresList, connList, obj, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "datasource.xadatasource_error", jndiName);
            _logger.log(Level.SEVERE, "datasource.xadatasource_error_excp", ex);
        }
        try {
            jndiName = "MDB_CONTAINER_TOPIC_CF__jmsxa_default";
            obj = (JMSXAConnectionFactory)ic.lookup(jndiName);
            this.recoverJMSXAResource(xaresList, connList, obj, false);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "datasource.xadatasource_error", jndiName);
            _logger.log(Level.SEVERE, "datasource.xadatasource_error_excp", ex);
        }
    }

    private void recoverJMSXAResources(Context ic, Vector xaresList, Vector connList, Set jmsRes) {
        Iterator iter = jmsRes.iterator();
        while (iter.hasNext()) {
            J2EEResource next = (J2EEResource)iter.next();
            if (next instanceof ExternalJndiResource && !((ExternalJndiResource)next).isJMSConnectionFactory()) continue;
            String jndiName = next.getName();
            try {
                boolean isQueue;
                JMSXAConnectionFactory obj;
                if (next instanceof ExternalJndiResource) {
                    Object objext = ic.lookup(jndiName);
                    if (!(objext instanceof ConnectionFactory)) {
                        throw new NamingException(localStrings.getLocalString("recovery.unexpected_objtype", "Unexpected object type " + objext.getClass().getName() + " for " + jndiName, new Object[]{objext.getClass().getName(), jndiName}));
                    }
                    obj = (JMSXAConnectionFactory)IASJmsUtil.wrapJMSConnectionFactoryObject(objext);
                    isQueue = objext instanceof QueueConnectionFactory;
                } else {
                    obj = (JMSXAConnectionFactory)ic.lookup(IASJmsUtil.getXAConnectionFactoryName(jndiName));
                    isQueue = obj instanceof JMSXAQueueConnectionFactory;
                }
                this.recoverJMSXAResource(xaresList, connList, obj, isQueue);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "datasource.xadatasource_error", jndiName);
                _logger.log(Level.SEVERE, "datasource.xadatasource_error_excp", ex);
            }
        }
    }

    private void recoverJMSXAResource(Vector xaresList, Vector connList, JMSXAConnectionFactory obj, boolean isQueue) throws Exception {
        if (isQueue) {
            JMSXAQueueConnectionFactory fac = (JMSXAQueueConnectionFactory)obj;
            JMSXAQueueConnection con = fac.createXAQueueConnection();
            connList.addElement(con);
            XAResource xares = con.createXAQueueSession(true, 1).getXAResource();
            xaresList.addElement(xares);
        } else {
            JMSXATopicConnectionFactory fac = (JMSXATopicConnectionFactory)obj;
            JMSXATopicConnection con = fac.createXATopicConnection();
            connList.addElement(con);
            XAResource xares = con.createXATopicSession(true, 1).getXAResource();
            xaresList.addElement(xares);
        }
    }

    private void closeJdbcXAResources(Vector connList) {
        int size = connList.size();
        for (int i = 0; i < size; ++i) {
            try {
                ManagedConnection con = (ManagedConnection)connList.elementAt(i);
                con.destroy();
                continue;
            }
            catch (ResourceException ex) {
                _logger.log(Level.FINE, "JDBC Resources cannot be closed", ex);
            }
        }
    }

    private void closeJMSXAResources(Vector connList) {
        int size = connList.size();
        for (int i = 0; i < size; ++i) {
            try {
                Object obj = connList.elementAt(i);
                ((JMSXAConnection)obj).close();
                continue;
            }
            catch (JMSException ex) {
                _logger.log(Level.FINE, "JMS Resources cannot be closed", ex);
            }
        }
    }

    private void closeConnectorXAResources(Vector connList) {
        int size = connList.size();
        for (int i = 0; i < size; ++i) {
            try {
                Object obj = connList.elementAt(i);
                ((ManagedConnection)obj).destroy();
                continue;
            }
            catch (ResourceException ex) {
                _logger.log(Level.FINE, "Connector Resources cannot be closed", ex);
            }
        }
    }

    public static String getPMJndiName(String userJndiName) {
        return userJndiName + PM_JNDI_EXTENSION;
    }

    public String getSystemModuleLocation(String moduleName) {
        String j2eeModuleDirName = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + moduleName;
        return j2eeModuleDirName;
    }

    public void installPersistenceManagerResources() throws Exception {
        this.logFine("***** Installing PersistenceManagerResources *****");
        Set pmfDatasources = this.resourceInfo.getResourcesByType(9);
        Iterator iter = pmfDatasources.iterator();
        while (iter.hasNext()) {
            this.logFine("***** In for loop PersistenceManagerResources *****");
            PMFResource next = (PMFResource)iter.next();
            this.installPersistenceManagerResource(next);
        }
        this.logFine("End of for loop PersistenceManagerResources *****");
    }

    public void installPersistenceManagerResource(PMFResource pmfRes) throws Exception {
        String jndiName = null;
        try {
            jndiName = pmfRes.getName();
            this.logFine("***** installPersistenceManagerResources jndiName *****" + jndiName);
            String factory = pmfRes.getFactoryClass();
            this.logFine("**** PersistenceManagerSettings - factory " + factory);
            Class<?> pmfImplClass = Class.forName(factory);
            Object pmfImpl = pmfImplClass.newInstance();
            String ds_jndi = pmfRes.getJdbcResourceJndiName();
            if (ds_jndi != null && ds_jndi.length() > 0) {
                String ds_jndi_pm = ResourceInstaller.getPMJndiName(ds_jndi);
                this.logFine("**** PersistenceManagerSettings - ds_jndi " + ds_jndi_pm);
                DataSource pmDataSource = null;
                try {
                    InitialContext ctx = new InitialContext();
                    pmDataSource = (DataSource)ctx.lookup(ds_jndi_pm);
                    Method connFacMethod = pmfImplClass.getMethod(SET_CONNECTION_FACTORY_NAME, String.class);
                    connFacMethod.invoke(pmfImpl, ds_jndi_pm);
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "jndi.persistence_manager_config", ds_jndi_pm);
                    _logger.log(Level.FINE, "jndi.persistence_manager_config_excp", ex);
                    throw ex;
                }
            }
            Set propSet = pmfRes.getProperties();
            Iterator propIter = propSet.iterator();
            while (propIter.hasNext()) {
                ResourceProperty prop = (ResourceProperty)propIter.next();
                String name = prop.getName();
                String value = (String)prop.getValue();
                this.logFine("**** PersistenceManager propSettings - " + name + " " + value);
                String methodName = SET_ + name.substring(0, 1).toUpperCase() + name.substring(1);
                Method method = pmfImplClass.getMethod(methodName, class$java$lang$String == null ? ResourceInstaller.class$("java.lang.String") : class$java$lang$String);
                method.invoke(pmfImpl, value);
            }
            NamingManager nm = Switch.getSwitch().getNamingManager();
            nm.publishObject(jndiName, pmfImpl, true);
            this.logFine("***** After publishing PersistenceManagerResources *****");
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "poolmgr.datasource_error", jndiName);
            _logger.log(Level.FINE, "poolmgr.datasource_error_excp", ex);
            throw ex;
        }
    }

    public void installCustomResource(CustomResource customRes) {
        NamingManager nm = Switch.getSwitch().getNamingManager();
        String bindName = null;
        try {
            bindName = customRes.getName();
            Reference ref = new Reference(customRes.getResType(), customRes.getFactoryClass(), null);
            Iterator props = customRes.getProperties().iterator();
            while (props.hasNext()) {
                ResourceProperty prop = (ResourceProperty)props.next();
                ref.add(new StringRefAddr(prop.getName(), (String)prop.getValue()));
            }
            nm.publishObject(bindName, (Object)ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error", bindName);
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error_excp", ex);
        }
    }

    public void installCustomResources() {
        Set customResSet = this.resourceInfo.getResourcesByType(11);
        Iterator iter = customResSet.iterator();
        while (iter.hasNext()) {
            CustomResource next = (CustomResource)iter.next();
            this.installCustomResource(next);
        }
    }

    public static Object loadObject(String className) {
        Object obj = null;
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (Exception cnf) {
            try {
                Class<?> c = ClassLoader.getSystemClassLoader().loadClass(className);
                obj = c.newInstance();
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "classloader.load_class_fail", className);
                _logger.log(Level.SEVERE, "classloader.load_class_fail_excp", ex.getMessage());
            }
        }
        return obj;
    }

    public void installExternalJndiResource(ExternalJndiResource extJndiRes) {
        NamingManager nm = Switch.getSwitch().getNamingManager();
        String bindName = null;
        try {
            bindName = extJndiRes.getName();
            String factoryClass = extJndiRes.getFactoryClass();
            String jndiLookupName = extJndiRes.getJndiLookupName();
            Object factory = ResourceInstaller.loadObject(factoryClass);
            if (factory == null) {
                _logger.log(Level.WARNING, "jndi.factory_load_error", factoryClass);
                return;
            }
            if (!(factory instanceof InitialContextFactory)) {
                _logger.log(Level.WARNING, "jndi.factory_class_unexpected", factoryClass);
                return;
            }
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            Iterator props = extJndiRes.getProperties().iterator();
            while (props.hasNext()) {
                ResourceProperty prop = (ResourceProperty)props.next();
                env.put(prop.getName(), prop.getValue());
            }
            Context context = null;
            try {
                context = ((InitialContextFactory)factory).getInitialContext(env);
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "jndi.initial_context_error", factoryClass);
                _logger.log(Level.SEVERE, "jndi.initial_context_error_excp", ne.getMessage());
            }
            if (context == null) {
                _logger.log(Level.SEVERE, "jndi.factory_create_error", factoryClass);
                return;
            }
            Reference ref = new Reference(extJndiRes.getResType(), "com.sun.enterprise.resource.JndiProxyObjectFactory", null);
            ref.add(new StringRefAddr("jndiName", bindName));
            ref.add(new StringRefAddr("jndiLookupName", jndiLookupName));
            ref.add(new StringRefAddr("jndiFactoryClass", factoryClass));
            ref.add(new ProxyRefAddr(bindName, env));
            nm.publishObject(bindName, (Object)ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error", bindName);
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error_excp", ex);
        }
    }

    public void installExternalJndiResources() {
        Set extResSet = this.resourceInfo.getResourcesByType(10);
        Iterator iter = extResSet.iterator();
        while (iter.hasNext()) {
            ExternalJndiResource next = (ExternalJndiResource)iter.next();
            this.installExternalJndiResource(next);
        }
    }

    public void uninstallExternalJndiResource(J2EEResource resource) {
        this.resourceInfo.removeResource(resource);
        JndiProxyObjectFactory.removeInitialContext(resource.getName());
        NamingManager nm = Switch.getSwitch().getNamingManager();
        try {
            nm.unpublishObject(resource.getName());
            if (((ExternalJndiResource)resource).isJMSConnectionFactory()) {
                nm.unpublishObject(IASJmsUtil.getXAConnectionFactoryName(resource.getName()));
            }
        }
        catch (NamingException e) {
            _logger.log(Level.FINE, "Error while unpublishing resource: " + resource.getName(), e);
        }
    }

    public void installMailResource(MailResource mailRes) {
        NamingManager nm = Switch.getSwitch().getNamingManager();
        String bindName = null;
        try {
            bindName = mailRes.getName();
            MailConfiguration config = new MailConfiguration(mailRes);
            nm.publishObject(bindName, (Object)config, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error", bindName);
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error_excp", ex);
        }
    }

    public void installMailResources() {
        Set mailResSet = this.resourceInfo.getResourcesByType(12);
        Iterator iter = mailResSet.iterator();
        while (iter.hasNext()) {
            MailResource next = (MailResource)iter.next();
            this.installMailResource(next);
        }
    }

    public void addResource(J2EEResource resource) throws PoolingException {
        try {
            this.resourceInfo.addResource(resource);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "J2EE.add_resource_error", ex);
            throw new PoolingException(ex.toString());
        }
    }

    public void removeResource(J2EEResource resource) throws PoolingException {
        try {
            this.resourceInfo.removeResource(resource);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "J2EE.remove_resource_error", ex);
            throw new PoolingException(ex.toString());
        }
    }

    public ConnectorDescriptor getDescriptorByConnectorName(String appName, String connectorName) {
        return null;
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    private String getTransactionSupport(ConnectorConnectionPool pool) {
        String txSupport = pool.getTransactionSupport();
        if (txSupport != null) {
            return txSupport;
        }
        try {
            txSupport = ConnectorRuntime.getRuntime().getConnectorDescriptor(pool.getResourceAdapterName()).getOutboundResourceAdapter().getTransSupport();
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.WARNING, cre.getMessage());
            txSupport = "NoTransaction";
        }
        return txSupport;
    }
}

