/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcConnectionPoolDeployer
implements ResourceDeployer {
    private static StringManager sm = StringManager.getManager(JdbcConnectionPoolDeployer.class);
    private static String msg = sm.getString("resource.restart_needed");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - deployResource : " + resource + " calling actualDeploy");
        this.actualDeployResource(resource);
    }

    public synchronized void actualDeployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - actualDeployResource : " + resource);
        com.sun.enterprise.config.serverbeans.JdbcConnectionPool jdbcConnPool = (com.sun.enterprise.config.serverbeans.JdbcConnectionPool)resource;
        JdbcConnectionPool poolResource = this.loadJdbcConnectionPool(jdbcConnPool);
        String moduleDir = null;
        String moduleName = null;
        String txSupport = null;
        if (poolResource.isXA()) {
            moduleName = ConnectorRuntime.JDBCXA_RA_NAME;
            txSupport = "XATransaction";
        } else if (poolResource.isCP()) {
            moduleName = ConnectorRuntime.JDBCCONNECTIONPOOLDATASOURCE_RA_NAME;
            txSupport = "LocalTransaction";
        } else {
            moduleName = ConnectorRuntime.JDBCDATASOURCE_RA_NAME;
            txSupport = "LocalTransaction";
        }
        moduleDir = this.getSystemModuleLocation(moduleName);
        ConnectorDescriptor connDesc = this.createConnectorDescriptor(moduleDir);
        ConnectorDescriptorInfo connDescInfo = this.createConnectorDescriptorInfo(connDesc, moduleName, poolResource);
        ConnectorConnectionPool connConnPool = this.createConnectorConnectionPool(poolResource, jdbcConnPool, txSupport);
        connConnPool.setMatchConnections(poolResource.isIsConnectionValidationRequired());
        try {
            ConnectorRuntime.getRuntime().createConnectorConnectionPool(connConnPool, connDescInfo);
        }
        catch (ConnectorRuntimeException cre) {
            cre.printStackTrace();
        }
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - unDeployResource : calling actualUndeploy of " + resource);
        this.actualUndeployResource(resource);
    }

    public synchronized void actualUndeployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - unDeployResource : " + resource);
        com.sun.enterprise.config.serverbeans.JdbcConnectionPool jdbcConnPool = (com.sun.enterprise.config.serverbeans.JdbcConnectionPool)resource;
        String poolName = jdbcConnPool.getName();
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        runtime.deleteConnectorConnectionPool(poolName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Pool Undeployed");
        }
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        com.sun.enterprise.config.serverbeans.JdbcConnectionPool jdbcConnPool = (com.sun.enterprise.config.serverbeans.JdbcConnectionPool)resource;
        if (!ConnectorRuntime.getRuntime().isConnectorConnectionPoolDeployed(jdbcConnPool.getName())) {
            _logger.fine("The JDBC connection pool " + jdbcConnPool.getName() + " is not referred or not yet created in this server " + "instance and hence pool redeployment is ignored");
            return;
        }
        JdbcConnectionPool poolResource = this.loadJdbcConnectionPool(jdbcConnPool);
        String moduleDir = null;
        String moduleName = null;
        String txSupport = null;
        if (poolResource.isXA()) {
            moduleName = ConnectorRuntime.JDBCXA_RA_NAME;
            txSupport = "XATransaction";
        } else if (poolResource.isCP()) {
            moduleName = ConnectorRuntime.JDBCCONNECTIONPOOLDATASOURCE_RA_NAME;
            txSupport = "LocalTransaction";
        } else {
            moduleName = ConnectorRuntime.JDBCDATASOURCE_RA_NAME;
            txSupport = "LocalTransaction";
        }
        moduleDir = this.getSystemModuleLocation(moduleName);
        ConnectorDescriptor connDesc = this.createConnectorDescriptor(moduleDir);
        ConnectorDescriptorInfo connDescInfo = this.createConnectorDescriptorInfo(connDesc, moduleName, poolResource);
        ConnectorConnectionPool connConnPool = this.createConnectorConnectionPool(poolResource, jdbcConnPool, txSupport);
        connConnPool.setTransactionSupport(ConnectionPoolObjectsUtils.parseTransactionSupportString(txSupport));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("setting txSupport to in +" + connConnPool.getName() + " to " + txSupport);
        }
        if (connConnPool == null) {
            throw new ConnectorRuntimeException("Unable to create ConnectorConnectionPoolfrom JDBC connection pool");
        }
        connConnPool.setConnectorDescriptorInfo(connDescInfo);
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("TransactionIsolation");
        excludes.add("GuaranteeIsolationLevel");
        excludes.add("ValidationTableName");
        excludes.add("ConnectionValidationRequired");
        try {
            _logger.finest("Calling reconfigure pool");
            boolean poolRecreateRequired = runtime.reconfigureConnectorConnectionPool(connConnPool, excludes);
            if (poolRecreateRequired) {
                _logger.finest("Pool recreation required");
                connConnPool.setMatchConnections(poolResource.isIsConnectionValidationRequired());
                runtime.recreateConnectorConnectionPool(connConnPool);
                _logger.finest("Pool recreation done");
            }
        }
        catch (ConnectorRuntimeException cre) {
            cre.printStackTrace();
            throw cre;
        }
    }

    public synchronized void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException(msg);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException(msg);
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        com.sun.enterprise.config.serverbeans.JdbcConnectionPool res = rbeans.getJdbcConnectionPoolByName(name);
        if (res == null) {
            String msg = sm.getString("resource.no_resource", name);
            throw new Exception(msg);
        }
        return res;
    }

    private ConnectorDescriptor createConnectorDescriptor(String moduleDir) {
        ConnectorDescriptor connectorDescriptor = null;
        FileArchive fa = new FileArchive();
        try {
            fa.open(moduleDir);
            ConnectorArchivist archivist = new ConnectorArchivist();
            connectorDescriptor = (ConnectorDescriptor)archivist.open(fa);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        return connectorDescriptor;
    }

    private ConnectorDescriptorInfo createConnectorDescriptorInfo(ConnectorDescriptor connDesc, String moduleName, JdbcConnectionPool jdbcConnPool) {
        ConnectorDescriptorInfo connDescInfo = new ConnectorDescriptorInfo();
        connDescInfo.setManagedConnectionFactoryClass(connDesc.getOutboundResourceAdapter().getManagedConnectionFactoryImpl());
        connDescInfo.setRarName(moduleName);
        connDescInfo.setResourceAdapterClassName(connDesc.getResourceAdapterClass());
        connDescInfo.setConnectionDefinitionName(connDesc.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connDescInfo.setConnectionFactoryClass(connDesc.getOutboundResourceAdapter().getConnectionFactoryImpl());
        connDescInfo.setConnectionFactoryInterface(connDesc.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connDescInfo.setConnectionClass(connDesc.getOutboundResourceAdapter().getConnectionImpl());
        connDescInfo.setConnectionInterface(connDesc.getOutboundResourceAdapter().getConnectionIntf());
        connDescInfo.setMCFConfigProperties(this.getMCFConfigProperties(jdbcConnPool, connDesc));
        connDescInfo.setResourceAdapterConfigProperties((Set)null);
        return connDescInfo;
    }

    private ConnectorConnectionPool createConnectorConnectionPool(JdbcConnectionPool jdbcPool, com.sun.enterprise.config.serverbeans.JdbcConnectionPool adminPool, String txSupport) {
        ConnectorConnectionPool conConnPool = new ConnectorConnectionPool(jdbcPool.getName());
        conConnPool.setMaxPoolSize(jdbcPool.getMaxPoolSize() != null ? jdbcPool.getMaxPoolSize() : adminPool.getDefaultMaxPoolSize());
        conConnPool.setSteadyPoolSize(jdbcPool.getSteadyPoolSize() != null ? jdbcPool.getSteadyPoolSize() : adminPool.getDefaultSteadyPoolSize());
        conConnPool.setMaxWaitTimeInMillis(jdbcPool.getMaxWaitTimeInMillis() != null ? jdbcPool.getMaxWaitTimeInMillis() : adminPool.getDefaultMaxWaitTimeInMillis());
        conConnPool.setPoolResizeQuantity(jdbcPool.getPoolResizeQuantity() != null ? jdbcPool.getPoolResizeQuantity() : adminPool.getDefaultPoolResizeQuantity());
        conConnPool.setIdleTimeoutInSeconds(jdbcPool.getIdleTimeoutInSeconds() != null ? jdbcPool.getIdleTimeoutInSeconds() : adminPool.getDefaultIdleTimeoutInSeconds());
        conConnPool.setFailAllConnections(jdbcPool.isFailAllConnections());
        conConnPool.setTransactionSupport(ConnectionPoolObjectsUtils.parseTransactionSupportString(txSupport));
        return conConnPool;
    }

    private EnvironmentProperty[] getMCFConfigProperties(JdbcConnectionPool jcp, ConnectorDescriptor connDesc) {
        ArrayList<EnvironmentProperty> propList = new ArrayList<EnvironmentProperty>();
        propList.add(new EnvironmentProperty("User", jcp.getUserName() == null ? "" : jcp.getUserName(), "user name", "java.lang.String"));
        propList.add(new EnvironmentProperty("Password", jcp.getPassword() == null ? "" : jcp.getPassword(), "Password", "java.lang.String"));
        propList.add(new EnvironmentProperty("ClassName", jcp.getDatasourceClassname() == null ? "" : jcp.getDatasourceClassname(), "The datasource class name", "java.lang.String"));
        propList.add(new EnvironmentProperty("ConnectionValidationRequired", new Boolean(jcp.isIsConnectionValidationRequired()).toString(), "Is connection validation required", "java.lang.String"));
        propList.add(new EnvironmentProperty("ValidationMethod", jcp.getConnectionValidationMethod() == null ? "" : jcp.getConnectionValidationMethod(), "How the connection is validated", "java.lang.String"));
        propList.add(new EnvironmentProperty("ValidationTableName", jcp.getValidationTableName() == null ? "" : jcp.getValidationTableName(), "Validation Table name", "java.lang.String"));
        propList.add(new EnvironmentProperty("TransactionIsolation", jcp.getTransactionIsolationLevel() == null ? "" : jcp.getTransactionIsolationLevel(), "Transaction Isolatin Level", "java.lang.String"));
        propList.add(new EnvironmentProperty("GuaranteeIsolationLevel", new Boolean(jcp.isIsolationLevelGuaranteed()).toString(), "Transaction Isolation Guarantee", "java.lang.String"));
        Set connDefDescSet = connDesc.getOutboundResourceAdapter().getConnectionDefs();
        if (connDefDescSet.size() != 1) {
            throw new MissingResourceException("Only one connDefDesc present", null, null);
        }
        Iterator iter = connDefDescSet.iterator();
        Set mcfConfigProps = null;
        while (iter.hasNext()) {
            mcfConfigProps = ((ConnectionDefDescriptor)iter.next()).getConfigProperties();
        }
        if (mcfConfigProps != null) {
            HashMap<String, String> mcfConPropKeys = new HashMap<String, String>();
            Iterator mcfConfigPropsIter = mcfConfigProps.iterator();
            while (mcfConfigPropsIter.hasNext()) {
                String key = ((EnvironmentProperty)mcfConfigPropsIter.next()).getName();
                mcfConPropKeys.put(key.toUpperCase(), key);
            }
            Iterator jcpItr = jcp.getProperties().iterator();
            String driverProperties = "";
            while (jcpItr.hasNext()) {
                ResourceProperty rp = (ResourceProperty)jcpItr.next();
                String name = rp.getName();
                if (mcfConPropKeys.containsKey(name.toUpperCase())) {
                    propList.add(new EnvironmentProperty((String)mcfConPropKeys.get(name.toUpperCase()), rp.getValue() == null ? "" : rp.getValue().toString(), "Some property", "java.lang.String"));
                    continue;
                }
                driverProperties = driverProperties + "set" + name + "#" + rp.getValue() + "##";
            }
            if (!driverProperties.equals("")) {
                propList.add(new EnvironmentProperty("DriverProperties", driverProperties, "some proprietarty properties", "java.lang.String"));
            }
        }
        propList.add(new EnvironmentProperty("Delimiter", "#", "delim", "java.lang.String"));
        EnvironmentProperty[] eProps = new EnvironmentProperty[propList.size()];
        ListIterator propListIter = propList.listIterator();
        int i = 0;
        while (propListIter.hasNext()) {
            eProps[i] = (EnvironmentProperty)propListIter.next();
            ++i;
        }
        return eProps;
    }

    private String getSystemModuleLocation(String moduleName) {
        String j2eeModuleDirName = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + moduleName;
        return j2eeModuleDirName;
    }

    private JdbcConnectionPool loadJdbcConnectionPool(com.sun.enterprise.config.serverbeans.JdbcConnectionPool jcp) {
        JdbcConnectionPool jr = new JdbcConnectionPool(jcp.getName());
        jr.setDatasourceClassname(jcp.getDatasourceClassname());
        jr.setMaxPoolSize(jcp.getMaxPoolSize());
        jr.setSteadyPoolSize(jcp.getSteadyPoolSize());
        jr.setMaxWaitTimeInMillis(jcp.getMaxWaitTimeInMillis());
        jr.setPoolResizeQuantity(jcp.getPoolResizeQuantity());
        jr.setIdleTimeoutInSeconds(jcp.getIdleTimeoutInSeconds());
        jr.setIsConnectionValidationRequired(jcp.isIsConnectionValidationRequired());
        jr.setConnectionValidationMethod(jcp.getConnectionValidationMethod());
        jr.setValidationTableName(jcp.getValidationTableName());
        jr.setFailAllConnections(jcp.isFailAllConnections());
        jr.setResType(jcp.getResType());
        jr.setTransactionIsolationLevel(jcp.getTransactionIsolationLevel());
        jr.setIsIsolationLevelGuaranteed(jcp.isIsIsolationLevelGuaranteed());
        ElementProperty[] s = jcp.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty ep = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(ep.getName(), ep.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }
}

