/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.GenericConverter;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceCollectionImpl;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JdbcDriver;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.RawResourceInfo;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.util.FileUtil;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class J2EEResourceFactoryImpl
implements J2EEResourceFactory {
    private static Logger _logger = null;
    private static final String FIELD_SEPARATOR = ".";
    private static final String PROP_INDICATOR = "prop";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String RESOURCE_PROP_RELATIVE_PATH;
    private static final int EQUAL = 0;
    private static final int SORT_BEFORE = -1;
    private static final int SORT_AFTER = 1;
    private static final boolean debug = false;
    private Properties outputProperties_ = new Properties();

    public J2EEResourceCollection loadDefaultResourceCollection() throws J2EEResourceException {
        String resourceFile = FileUtil.getAbsolutePath(RESOURCE_PROP_RELATIVE_PATH);
        return this.loadResourceCollection(resourceFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public J2EEResourceCollection loadResourceCollection(String resourcesURL) throws J2EEResourceException {
        J2EEResourceCollectionImpl resources = new J2EEResourceCollectionImpl();
        InputStream inputStream = null;
        try {
            try {
                boolean created;
                Properties resourceProperties = new Properties();
                File resourceFile = new File(resourcesURL);
                if (!resourceFile.exists() && !(created = resourceFile.createNewFile())) {
                    throw new IOException("Could not create " + resourceFile);
                }
                FileInputStream fis = new FileInputStream(resourceFile);
                inputStream = new BufferedInputStream(fis);
                resourceProperties.load(inputStream);
                List rawInfoList = this.propsToRawResourceInfo(resourceProperties);
                GenericConverter converter = new GenericConverter();
                Iterator iter = rawInfoList.iterator();
                while (iter.hasNext()) {
                    RawResourceInfo rawInfo = (RawResourceInfo)iter.next();
                    try {
                        J2EEResource resource = converter.rawInfoToResource(rawInfo);
                        resources.addResource(resource);
                    }
                    catch (J2EEResourceException jre) {
                        _logger.log(Level.SEVERE, "enterprise.resource_exception", jre);
                    }
                }
                Object var13_15 = null;
                if (inputStream == null) return resources;
            }
            catch (Exception e) {
                throw new J2EEResourceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        inputStream.close();
        return resources;
    }

    public void storeDefaultResourceCollection(J2EEResourceCollection resources) throws J2EEResourceException {
        String resourceFile = FileUtil.getAbsolutePath(RESOURCE_PROP_RELATIVE_PATH);
        this.storeResourceCollection(resources, resourceFile);
    }

    /*
     * Loose catch block
     */
    public void storeResourceCollection(J2EEResourceCollection resources, String resourcesURL) throws J2EEResourceException {
        block22: {
            IOException ioe2222;
            OutputStream resourceOutputStream;
            InputStream tempResourceInputStream;
            OutputStream tempResourceOutputStream;
            block20: {
                String nextLine;
                tempResourceOutputStream = null;
                tempResourceInputStream = null;
                resourceOutputStream = null;
                File tempResourceFile = File.createTempFile("resource", "");
                tempResourceFile.deleteOnExit();
                tempResourceOutputStream = new FileOutputStream(tempResourceFile);
                Vector<RawResourceInfo> allRawInfo = new Vector<RawResourceInfo>();
                Set allResources = resources.getAllResources();
                GenericConverter converter = new GenericConverter();
                Iterator iter = allResources.iterator();
                while (iter.hasNext()) {
                    J2EEResource next = (J2EEResource)iter.next();
                    RawResourceInfo rawInfo = converter.resourceToRawInfo(next);
                    allRawInfo.add(rawInfo);
                }
                this.storeRawInfoToPropsFile(allRawInfo, tempResourceOutputStream);
                tempResourceOutputStream.close();
                tempResourceOutputStream = null;
                tempResourceInputStream = new FileInputStream(tempResourceFile);
                BufferedReader tempResourceReader = new BufferedReader(new InputStreamReader(tempResourceInputStream));
                resourceOutputStream = new FileOutputStream(resourcesURL);
                BufferedWriter resourceWriter = new BufferedWriter(new OutputStreamWriter(resourceOutputStream));
                while ((nextLine = tempResourceReader.readLine()) != null) {
                    if (nextLine.startsWith("#")) continue;
                    resourceWriter.write(nextLine);
                    resourceWriter.newLine();
                }
                resourceWriter.close();
                Object var14_14 = null;
                if (tempResourceOutputStream == null) break block20;
                try {
                    tempResourceOutputStream.close();
                }
                catch (IOException ioe2222) {
                    // empty catch block
                }
            }
            if (tempResourceInputStream != null) {
                try {
                    tempResourceInputStream.close();
                }
                catch (IOException ioe2222) {
                    // empty catch block
                }
            }
            if (resourceOutputStream != null) {
                try {
                    resourceOutputStream.close();
                }
                catch (IOException ioe2222) {}
            }
            break block22;
            {
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "enterprise.resource_exception", e);
                    throw new J2EEResourceException(e);
                }
            }
            catch (Throwable throwable) {
                IOException ioe2222;
                Object var14_15 = null;
                if (tempResourceOutputStream != null) {
                    try {
                        tempResourceOutputStream.close();
                    }
                    catch (IOException ioe2222) {
                        // empty catch block
                    }
                }
                if (tempResourceInputStream != null) {
                    try {
                        tempResourceInputStream.close();
                    }
                    catch (IOException ioe2222) {
                        // empty catch block
                    }
                }
                if (resourceOutputStream != null) {
                    try {
                        resourceOutputStream.close();
                    }
                    catch (IOException ioe2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public J2EEResource createResource(int type, String name) {
        J2EEResourceBase resource = null;
        switch (type) {
            case 1: {
                resource = new JmsDestinationResource(name);
                break;
            }
            case 2: {
                resource = new JmsCnxFactoryResource(name);
                break;
            }
            case 3: {
                resource = new JdbcResource(name);
                break;
            }
            case 4: {
                resource = new JdbcXAResource(name);
                break;
            }
            case 5: {
                resource = new JdbcDriver(name);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return resource;
    }

    public ResourceProperty createProperty(String name) {
        return new ResourcePropertyImpl(name);
    }

    private List propsToRawResourceInfo(Properties resourceProperties) throws Exception {
        Vector<RawResourceInfo> allRawInfo = new Vector<RawResourceInfo>();
        Enumeration<?> propNames = resourceProperties.propertyNames();
        while (propNames.hasMoreElements()) {
            String numberStr;
            int resourceIndex;
            String nextProp = (String)propNames.nextElement();
            StringTokenizer tokenizer = new StringTokenizer(nextProp, FIELD_SEPARATOR);
            String resourceType = tokenizer.nextToken();
            RawResourceInfo info = new RawResourceInfo(resourceType, resourceIndex = Integer.parseInt(numberStr = tokenizer.nextToken()));
            int elementIndex = allRawInfo.indexOf(info);
            if (elementIndex == -1) {
                allRawInfo.add(info);
            } else {
                info = (RawResourceInfo)allRawInfo.elementAt(elementIndex);
            }
            String key = tokenizer.nextToken();
            String propValue = (String)resourceProperties.get(nextProp);
            if (key.equals(PROP_INDICATOR) && tokenizer.hasMoreTokens()) {
                key = tokenizer.nextToken();
                info.getProperties().put(key, propValue);
                continue;
            }
            info.getAttributes().put(key, propValue);
        }
        return allRawInfo;
    }

    private void storeRawInfoToPropsFile(List allRawInfo, OutputStream out) throws IOException {
        Object[] rawInfoArray = allRawInfo.toArray();
        Arrays.sort(rawInfoArray, new RawInfoSorter());
        Hashtable<String, Integer> indexCounters = new Hashtable<String, Integer>();
        for (int rawIndex = 0; rawIndex < rawInfoArray.length; ++rawIndex) {
            RawResourceInfo rawInfo = (RawResourceInfo)rawInfoArray[rawIndex];
            String resourceType = rawInfo.getResourceType();
            Integer index = (Integer)indexCounters.get(resourceType);
            if (index == null) {
                index = new Integer(0);
            }
            String propNamePrefix = resourceType + FIELD_SEPARATOR + index + FIELD_SEPARATOR;
            indexCounters.put(resourceType, new Integer(index + 1));
            this.writeNameValueCollection(out, propNamePrefix, rawInfo.getAttributes());
            this.writeNameValueCollection(out, propNamePrefix + PROP_INDICATOR + FIELD_SEPARATOR, rawInfo.getProperties());
        }
    }

    private void writeNameValueCollection(OutputStream out, String prefix, Hashtable nameValueCollection) throws IOException {
        Set entrySet = nameValueCollection.entrySet();
        Object[] nameValueArray = entrySet.toArray();
        Arrays.sort(nameValueArray, new NameValueSorter());
        for (int index = 0; index < nameValueArray.length; ++index) {
            Map.Entry next = (Map.Entry)nameValueArray[index];
            this.writeNameValuePair(out, prefix, next.getKey().toString(), next.getValue().toString());
        }
    }

    private void writeNameValuePair(OutputStream out, String prefix, String name, String value) throws IOException {
        this.outputProperties_.clear();
        this.outputProperties_.put(prefix + name, value);
        this.outputProperties_.store(out, null);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        RESOURCE_PROP_RELATIVE_PATH = "config" + File.separator + "resource.properties";
    }

    private static class NameValueSorter
    implements Comparator {
        private NameValueSorter() {
        }

        public int compare(Object o1, Object o2) {
            int sortResult = 0;
            Map.Entry pair1 = (Map.Entry)o1;
            Map.Entry pair2 = (Map.Entry)o2;
            if (!((Object)pair1).equals(pair2)) {
                String key1 = (String)pair1.getKey();
                String key2 = (String)pair2.getKey();
                sortResult = key1.equals(J2EEResourceFactoryImpl.NAME_ATTRIBUTE) ? -1 : (key2.equals(J2EEResourceFactoryImpl.NAME_ATTRIBUTE) ? 1 : key1.compareTo(key2));
            }
            return sortResult;
        }
    }

    private static class RawInfoSorter
    implements Comparator {
        private RawInfoSorter() {
        }

        public int compare(Object o1, Object o2) {
            int sortResult = 0;
            RawResourceInfo raw1 = (RawResourceInfo)o1;
            RawResourceInfo raw2 = (RawResourceInfo)o2;
            if (!raw1.equals(raw2)) {
                String type2;
                String type1 = raw1.getResourceType();
                if (type1.equals(type2 = raw2.getResourceType())) {
                    String name1 = (String)raw1.getAttributes().get(J2EEResourceFactoryImpl.NAME_ATTRIBUTE);
                    String name2 = (String)raw2.getAttributes().get(J2EEResourceFactoryImpl.NAME_ATTRIBUTE);
                    sortResult = name1.compareTo(name2);
                } else {
                    sortResult = type1.compareTo(type2);
                }
            }
            return sortResult;
        }
    }
}

