/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceConverter;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.JdbcDriver;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.RawResourceInfo;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericConverter
implements J2EEResourceConverter {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    private static final String RESOURCE_NAME_ATTR = "name";
    private static Hashtable resourceImplClasses;
    private static Hashtable attributeMethods;
    private int counter = 0;

    public J2EEResource rawInfoToResource(RawResourceInfo rawInfo) throws J2EEResourceException {
        J2EEResource resource = null;
        try {
            Class resourceClass = (Class)resourceImplClasses.get(rawInfo.getResourceType());
            if (resourceClass == null) {
                String errMsg = localStrings.getLocalString("GenericConverter.unknown.resource.type", "Unknown resource type {0}", new Object[]{rawInfo.getResourceType()});
                throw new J2EEResourceException(errMsg);
            }
            Class[] paramTypes = new Class[]{String.class};
            Constructor nameConstructor = resourceClass.getConstructor(paramTypes);
            String name = (String)rawInfo.getAttributes().get(RESOURCE_NAME_ATTR);
            if (name == null) {
                String errMsg = localStrings.getLocalString("GenericConverter.name.attribute.required", "Resource type {0} with index {1} is missing a 'name' attribute", new Object[]{rawInfo.getResourceType(), new Integer(rawInfo.getIndex())});
                throw new J2EEResourceException(errMsg);
            }
            Object[] initArgs = new Object[]{name};
            resource = (J2EEResource)nameConstructor.newInstance(initArgs);
            Set attributes = rawInfo.getAttributes().entrySet();
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                Map.Entry next = iter.next();
                String attrName = (String)next.getKey();
                String attrValue = (String)next.getValue();
                try {
                    if (attrName.equals(RESOURCE_NAME_ATTR)) continue;
                    Utility.invokeSetMethod(resource, attrName, attrValue);
                }
                catch (NoSuchMethodException nsme) {
                    String errMsg = localStrings.getLocalString("GenericConverter.invalid.attribute", "Attribute {0} of resource type {1} with index {2} is invalid", new Object[]{attrName, rawInfo.getResourceType(), new Integer(rawInfo.getIndex())});
                    throw new J2EEResourceException(errMsg);
                }
            }
            Set properties = rawInfo.getProperties().entrySet();
            Iterator iter2 = properties.iterator();
            while (iter2.hasNext()) {
                Map.Entry next = iter2.next();
                String propName = (String)next.getKey();
                ResourcePropertyImpl property = new ResourcePropertyImpl(propName);
                property.setValue(next.getValue());
                resource.addProperty(property);
            }
        }
        catch (J2EEResourceException jre) {
            throw jre;
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.rawinfotoresource_exception", e);
            throw new J2EEResourceException(e);
        }
        return resource;
    }

    public RawResourceInfo resourceToRawInfo(J2EEResource resource) throws J2EEResourceException {
        RawResourceInfo rawInfo = null;
        try {
            Object[] emptyArgs = new Class[]{};
            Class<?> resourceClass = resource.getClass();
            String resourceType = this.getResourceType(resourceClass.getName());
            rawInfo = new RawResourceInfo(resourceType, this.counter);
            ++this.counter;
            List attrMethods = GenericConverter.getAttributeMethods(resourceClass);
            Iterator iter = attrMethods.iterator();
            while (iter.hasNext()) {
                Method method = (Method)iter.next();
                Object value = method.invoke((Object)resource, emptyArgs);
                if (value == null) {
                    value = "";
                }
                String propName = method.getName().substring(3);
                propName = propName.substring(0, 1).toLowerCase() + propName.substring(1);
                rawInfo.getAttributes().put(propName, value);
            }
            Set properties = resource.getProperties();
            Iterator iter2 = properties.iterator();
            while (iter2.hasNext()) {
                ResourceProperty next = (ResourceProperty)iter2.next();
                rawInfo.getProperties().put(next.getName(), next.getValue());
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.resourcetorawinfo_exception", e);
            throw new J2EEResourceException(e);
        }
        return rawInfo;
    }

    private String getResourceType(String className) {
        Set implClasses = resourceImplClasses.entrySet();
        Iterator iter = implClasses.iterator();
        while (iter.hasNext()) {
            Map.Entry next = iter.next();
            Class nextClass = (Class)next.getValue();
            if (!nextClass.getName().equals(className)) continue;
            return (String)next.getKey();
        }
        throw new IllegalArgumentException();
    }

    private static List getAttributeMethods(Class resourceClass) throws Exception {
        Class[] emptyArgs = new Class[]{};
        Method[] methodsToSkip = new Method[]{resourceClass.getMethod("getType", emptyArgs), resourceClass.getMethod("getProperties", emptyArgs), resourceClass.getMethod("getProperty", String.class), Object.class.getMethod("getClass", emptyArgs)};
        Vector<Method> methodsForClass = (Vector<Method>)attributeMethods.get(resourceClass.getName());
        if (methodsForClass == null) {
            methodsForClass = new Vector<Method>();
            Method[] allMethods = resourceClass.getMethods();
            for (int methodIndex = 0; methodIndex < allMethods.length; ++methodIndex) {
                Method method = allMethods[methodIndex];
                if (!GenericConverter.isStorableAttrMethod(method, methodsToSkip)) continue;
                methodsForClass.add(method);
            }
            attributeMethods.put(resourceClass.getName(), methodsForClass);
        }
        return methodsForClass;
    }

    private static boolean isStorableAttrMethod(Method method, Method[] methodsToSkip) {
        for (int methodIndex = 0; methodIndex < methodsToSkip.length; ++methodIndex) {
            if (!method.equals(methodsToSkip[methodIndex])) continue;
            return false;
        }
        return method.getName().startsWith("get");
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        localStrings = new LocalStringManagerImpl(GenericConverter.class);
        resourceImplClasses = new Hashtable();
        attributeMethods = new Hashtable();
        resourceImplClasses.put("jmsCnxFactory", JmsCnxFactoryResource.class);
        resourceImplClasses.put("jmsDestination", JmsDestinationResource.class);
        resourceImplClasses.put("jdbcDataSource", JdbcResource.class);
        resourceImplClasses.put("jdbcXADataSource", JdbcXAResource.class);
        resourceImplClasses.put("jdbcDriver", JdbcDriver.class);
    }
}

