/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.factory;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectorObjectFactory
implements ObjectFactory {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorObjectFactory.class);

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        ClassLoader loader;
        Reference ref = (Reference)obj;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectorObjectFactory: " + ref + " Name:" + name);
        }
        String poolName = (String)ref.get(0).getContent();
        String moduleName = (String)ref.get(1).getContent();
        Switch sw = Switch.getSwitch();
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        if (runtime.getEnviron() == 2) {
            ConnectorDescriptor connectorDescriptor = null;
            try {
                InitialContext ic = new InitialContext();
                String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
                connectorDescriptor = (ConnectorDescriptor)ic.lookup(descriptorJNDIName);
            }
            catch (NamingException ne) {
                _logger.log(Level.FINE, "Failed to look up ConnectorDescriptor from JNDI", moduleName);
                throw new ConnectorRuntimeException("Failed to look up ConnectorDescriptor from JNDI");
            }
            runtime.createActiveResourceAdapter(connectorDescriptor, moduleName, null, false);
        }
        if (!runtime.checkAccessibility(moduleName, loader = Thread.currentThread().getContextClassLoader())) {
            throw new NamingException("Only the application that has the embedded resourceadapter can access the resource adapter");
        }
        String jndiName = name.toString();
        ConnectionManagerImpl mgr = (ConnectionManagerImpl)runtime.obtainConnectionManager(poolName);
        mgr.setJndiName(jndiName);
        mgr.setRarName(moduleName);
        mgr.initialize();
        ManagedConnectionFactory mcf = runtime.obtainManagedConnectionFactory(poolName);
        if (mcf == null) {
            _logger.log(Level.FINE, "Failed to create MCF ", poolName);
            throw new ConnectorRuntimeException("Failed to create MCF");
        }
        PoolManager poolmgr = Switch.getSwitch().getPoolManager();
        poolmgr.createEmptyConnectionPool(poolName);
        Object cf = mcf.createConnectionFactory((ConnectionManager)mgr);
        if (cf == null) {
            String msg = localStrings.getLocalString("no.resource.adapter", "");
            throw new ConfigurationException(msg);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Connection Factory:" + cf);
        }
        return cf;
    }
}

